/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.alerting;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractPhase;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingChangeListener;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingColor;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingParameter;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingRecord;
import com.deutscheboerse.comxerv.comtrader.service.alerting.AlertingSetting;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AlertingService {
    private static final Logger LOG = LoggerFactory.getLogger(AlertingService.class);
    private static final int INNER_TIMER_SECONDS = 5;
    private final SettingsService settingsService;
    private final TimeService timeService;
    private final UserService userService;
    private final AssignmentService assignmentService;
    private final List<AlertingChangeListener> listeners = new ArrayList<AlertingChangeListener>();
    private final SmallFastDataModel<Long, Contract> contractDataModel;
    private final ScheduledExecutorService executor;
    private final Table<Long, String, AlertingRecord> alertingRecords = Tables.synchronizedTable(HashBasedTable.create());

    @Inject
    public AlertingService(SettingsService settingsService, UserService userService, AssignmentService assignmentService, ApplicationContext appContext) {
        this.settingsService = settingsService;
        this.userService = userService;
        this.assignmentService = assignmentService;
        this.contractDataModel = appContext.getSmallDataModel(Contract.class);
        this.executor = appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.timeService = appContext.getService(TimeService.class);
        this.executor.scheduleAtFixedRate(this::checkFullMinute, 0L, 5L, TimeUnit.SECONDS);
        this.attachContractModelChangeListeners();
    }

    private void checkFullMinute() {
        if (this.timeService.getServerTime().getSecondOfMinute() <= 5) {
            this.notifyListenersWithActiveAlertingRecords();
        }
    }

    private void attachContractModelChangeListeners() {
        this.contractDataModel.registerListener(new DataModelListener<Contract>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(Contract contract) {
                return this.notifyUpdate(contract);
            }

            @Override
            public DataModelListener.NotificationResult notifyAddAll(Collection<Contract> contracts) {
                return this.notifyUpdateAll(contracts);
            }

            @Override
            public DataModelListener.NotificationResult notifyRemove(Contract contract) {
                AlertingService.this.removeAlertingRecords(contract);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll(Collection<Contract> contracts) {
                contracts.forEach(AlertingService.this::removeAlertingRecords);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public synchronized DataModelListener.NotificationResult notifyRemoveAll() {
                AlertingService.this.alertingRecords.clear();
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyUpdate(Contract contract) {
                AlertingService.this.createOrUpdateAlertingRecords(contract);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyUpdateAll(Collection<Contract> contracts) {
                contracts.forEach(AlertingService.this::createOrUpdateAlertingRecords);
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        });
    }

    public void addAlertingChangeListener(AlertingChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeAlertingChangeListener(AlertingChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void saveAlertingSettings(AlertingSetting entry) {
        this.settingsService.storeSettings(this.getAlertingSetting(entry.getProductId()), entry.isEnabled());
        this.settingsService.storeSettings(this.getAlertingOffsetSetting(entry.getProductId()), entry.getOffset());
        this.settingsService.storeSettings(this.getAlertingColorSetting(entry.getProductId()), entry.getColor());
        this.createOrUpdateAlertingRecords(entry);
    }

    public AlertingSetting getAlertingSettings(String productId) {
        return new AlertingSetting(productId, this.settingsService.loadSettings(this.getAlertingSetting(productId)), this.settingsService.loadSettings(this.getAlertingOffsetSetting(productId)), this.settingsService.loadSettings(this.getAlertingColorSetting(productId)));
    }

    private void createOrUpdateAlertingRecords(Contract contract) {
        List<AlertingRecord> newAlertingRecords = contract.getCompoundStatus().getDeliveryAreas().stream().map(da -> this.newAlertingRecord((DeliveryArea)da, contract)).filter(Objects::nonNull).toList();
        this.createOrUpdateAlertingRecords(newAlertingRecords);
    }

    private boolean isDeliveryAreaAssignedToUser(DeliveryArea da, Contract contract) {
        User currentUser = this.userService.getCurrentUser();
        if (currentUser.getRoles().isAdmin() || this.assignmentService.isUserAssignedToBgProductAndDa(currentUser, currentUser.getDefaultBalancingGroup(), (String)contract.getProduct().getId(), (String)da.getId())) {
            return true;
        }
        for (String bg : currentUser.getBalancingGroupIds()) {
            if (!this.assignmentService.isUserAssignedToBgProductAndDa(currentUser, bg, (String)contract.getProduct().getId(), (String)da.getId())) continue;
            return true;
        }
        return false;
    }

    private AlertingRecord newAlertingRecord(DeliveryArea da, Contract contract) {
        AlertingSetting storedSetting = this.getAlertingSettings((String)contract.getProduct().getId());
        if (storedSetting == null || !storedSetting.isEnabled()) {
            return null;
        }
        if (!this.isTradingPhaseEligibleForAlerting(contract.getCompoundStatus().getDeliveryAreaPhase(da)) || contract.getCompoundStatus().getActivePeriod(da) == null) {
            this.alertingRecords.remove(contract.getId(), da.getId());
            return null;
        }
        if (!this.isDeliveryAreaAssignedToUser(da, contract)) {
            this.alertingRecords.remove(contract.getId(), da.getId());
            return null;
        }
        DateTime tradingPhaseEnd = contract.getCompoundStatus().getActivePeriod(da).getEnd();
        return new AlertingRecord((Long)contract.getId(), (String)da.getId(), tradingPhaseEnd.minusMinutes(storedSetting.getOffset()), tradingPhaseEnd, storedSetting.getColor());
    }

    private boolean isTradingPhaseEligibleForAlerting(ContractPhase phase) {
        return ContractPhase.CONT.equals(phase) || ContractPhase.BALA.equals(phase) || ContractPhase.AUCT.equals(phase) || ContractPhase.SDAT.equals(phase);
    }

    private void createOrUpdateAlertingRecords(AlertingSetting newSetting) {
        List<Contract> contracts = this.contractDataModel.getAllEntitiesAsStream().filter(c -> newSetting.getProductId().equals(c.getProduct().getId())).toList();
        if (!newSetting.isEnabled()) {
            for (Contract contract2 : contracts) {
                this.removeAlertingRecords(contract2);
            }
            this.notifyListenersWithActiveAlertingRecords();
        } else {
            List<AlertingRecord> newRecords = contracts.stream().map(contract -> this.filterAndMapToNewRecords((Contract)contract, newSetting)).flatMap(Collection::stream).toList();
            this.createOrUpdateAlertingRecords(newRecords);
        }
    }

    private List<AlertingRecord> filterAndMapToNewRecords(Contract contract, AlertingSetting setting) {
        return contract.getCompoundStatus().getDeliveryAreas().stream().filter(da -> contract.getCompoundStatus().getActivePeriod((DeliveryArea)da) != null).filter(da -> this.isDeliveryAreaAssignedToUser((DeliveryArea)da, contract)).map(da -> {
            DateTime phaseEnd = contract.getCompoundStatus().getActivePeriod((DeliveryArea)da).getEnd();
            return new AlertingRecord((Long)contract.getId(), (String)da.getId(), phaseEnd.minusMinutes(setting.getOffset()), phaseEnd, setting.getColor());
        }).toList();
    }

    private synchronized void removeAlertingRecords(Contract contract) {
        this.alertingRecords.row((Long)contract.getId()).clear();
    }

    private synchronized void createOrUpdateAlertingRecords(List<AlertingRecord> updatedRecords) {
        for (AlertingRecord newRecord : updatedRecords) {
            AlertingRecord actualRecord = this.alertingRecords.get(newRecord.getContractId(), newRecord.getDeliveryAreaId());
            if (actualRecord == null) {
                this.alertingRecords.put(newRecord.getContractId(), newRecord.getDeliveryAreaId(), newRecord);
                continue;
            }
            actualRecord.setAlertingColor(newRecord.getAlertingColor());
            actualRecord.setStart(newRecord.getStart());
            actualRecord.setEnd(newRecord.getEnd());
        }
        this.notifyListenersWithActiveAlertingRecords();
    }

    private synchronized void notifyListenersWithActiveAlertingRecords() {
        List<AlertingRecord> activeRecords = this.alertingRecords.values().stream().filter(this::isActive).toList();
        this.notifyListeners(activeRecords);
    }

    private boolean isActive(AlertingRecord r) {
        return this.isActive(r.getStart(), r.getEnd());
    }

    private boolean isActive(DateTime start, DateTime end) {
        DateTime now = this.timeService.getServerTime();
        return start.isBefore(now) && end.isAfter(now);
    }

    private void notifyListeners(List<AlertingRecord> activeRecords) {
        LOG.debug("Notifying {} listeners", (Object)this.listeners.size());
        for (AlertingChangeListener listener : this.listeners) {
            listener.highlightContractDAs(activeRecords);
        }
    }

    private SettingsService.Settings<Boolean> getAlertingSetting(String productId) {
        return new SettingsService.Settings<Boolean>(AlertingService.class.getName() + "$" + productId + "$" + String.valueOf((Object)AlertingParameter.ENABLE), false);
    }

    private SettingsService.Settings<Integer> getAlertingOffsetSetting(String productId) {
        return new SettingsService.Settings<Integer>(AlertingService.class.getName() + "$" + productId + "$" + String.valueOf((Object)AlertingParameter.TIMER), 0);
    }

    private SettingsService.Settings<AlertingColor> getAlertingColorSetting(String productId) {
        return new SettingsService.Settings<AlertingColor>(AlertingService.class.getName() + "$" + productId + "$" + String.valueOf((Object)AlertingParameter.COLOR), AlertingColor.DEFAULT);
    }

    public AlertingRecord getAlertingInfo(Long contractId, String deliveryAreaId) {
        AlertingRecord alertingRecord = this.alertingRecords.get(contractId, deliveryAreaId);
        return alertingRecord == null || !this.isActive(alertingRecord) ? null : alertingRecord;
    }

    public boolean isAlertActive(Contract contract, DeliveryArea deliveryArea, DateTime start, DateTime end) {
        return this.isTradingPhaseEligibleForAlerting(contract.getCompoundStatus().getDeliveryAreaPhase(deliveryArea)) && this.isActive(start, end);
    }
}

