/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.entities.type.LogoutActionType;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.LogoutService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.emergency.EmergencyService;
import com.deutscheboerse.comxerv.comtrader.service.question.LogoutErrorConfirmation;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingSettingsService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Optional;

@Singleton
public class LogoutServiceImpl
implements LogoutService {
    private final BackendConnectionGateway backendConnectionGateway;
    private final TradingSettingsService tradingSettingsService;
    private final EmergencyService emergencyService;
    private final UserAlertService userAlertService;
    private final EventBus eventBus;
    private final UserService userService;
    private final TradeService tradeService;

    @Inject
    public LogoutServiceImpl(ApplicationContext applicationContext) {
        this.backendConnectionGateway = applicationContext.getService(BackendConnectionGateway.class);
        this.tradingSettingsService = applicationContext.getService(TradingSettingsService.class);
        this.emergencyService = applicationContext.getService(EmergencyService.class);
        this.userAlertService = applicationContext.getService(UserAlertService.class);
        this.eventBus = applicationContext.getService(EventBus.class);
        this.userService = applicationContext.getService(UserService.class);
        this.tradeService = applicationContext.getService(TradeService.class);
    }

    @Override
    public void logout() {
        if (this.isPreLogoutCheckSuccesfull()) {
            this.doPreLogoutAll(null);
        }
    }

    @Override
    public void logout(Runnable onExchangeLogout) {
        if (this.backendConnectionGateway.getSession() == null) {
            onExchangeLogout.run();
        } else if (this.isPreLogoutCheckSuccesfull()) {
            ExchangeLogoutListener exchangeLogoutListener = new ExchangeLogoutListener(onExchangeLogout, this.backendConnectionGateway, this.eventBus);
            this.eventBus.register(exchangeLogoutListener);
            this.doPreLogoutAll(exchangeLogoutListener);
        }
    }

    private boolean isPreLogoutCheckSuccesfull() {
        if (this.tradeService.getTradeCancellationProgress().inProgressProperty().get()) {
            return this.userAlertService.showQuestionDialog(Util.getLabel("commons_logoutAnywayQuestion"), Util.getLabel("tradeCancellationLogoutConfirmation"), new UserAlertService.Flag[0]);
        }
        return true;
    }

    private void doPreLogoutAll(ExchangeLogoutListener listener) {
        User user = this.userService.getOwnUser();
        boolean trader = user.getRoles().isTrader() || user.getRoles().isBroker() && user.getRoles().isOwnTrading();
        LogoutActionType logoutSettings = trader ? this.getLogoutAction() : LogoutActionType.DO_NOTHING;
        switch (logoutSettings) {
            case DEACTIVATE_ORDERS: {
                this.hibernateAndLogout(this.backendConnectionGateway.getSession(), listener);
                break;
            }
            case DELETE_ORDERS: {
                this.deleteAndLogout(this.backendConnectionGateway.getSession(), listener);
                break;
            }
            default: {
                this.doLogout();
            }
        }
    }

    private LogoutActionType getLogoutAction() {
        return Optional.of(this.tradingSettingsService.getLogoutSettings()).orElse(LogoutActionType.DO_NOTHING);
    }

    private void deleteAndLogout(Session session, ExchangeLogoutListener listener) {
        this.emergencyService.deleteAllWithoutQuestion(false, this.logoutOperationHandler(session, "logoutAction_DeletionError_Logout_Anyway", listener));
    }

    private void hibernateAndLogout(Session session, ExchangeLogoutListener listener) {
        this.emergencyService.hibernateAllActiveWithoutQuestion(false, this.logoutOperationHandler(session, "logoutAction_DeactivationError_Logout_Anyway", listener));
    }

    private ResponseHandler logoutOperationHandler(Session session, String errorMessage, ExchangeLogoutListener listener) {
        return response -> {
            if (ResponseStatus.SUCCESS.equals((Object)response.getStatus())) {
                this.doLogout();
            } else if (ResponseStatus.ERROR.equals((Object)response.getStatus())) {
                if (this.userAlertService.showQuestionDialog(Util.getLabel("commons_logoutAnywayQuestion"), Util.getLabel(errorMessage, session.getExchange().getDisplayName()), new UserAlertService.Flag[0])) {
                    this.doLogout();
                } else if (listener != null) {
                    this.eventBus.unregister(listener);
                }
            }
        };
    }

    private void doLogout() {
        FxUtil.runInFxThread(() -> this.backendConnectionGateway.logout(new LogoutErrorConfirmation(this.userAlertService)));
    }

    protected static class ExchangeLogoutListener {
        private final Runnable onExchangeLogout;
        private final BackendConnectionGateway backendConnectionGateway;
        private final EventBus eventBus;

        private ExchangeLogoutListener(Runnable onExchangeLogout, BackendConnectionGateway backendConnectionGateway, EventBus eventBus) {
            this.onExchangeLogout = onExchangeLogout;
            this.backendConnectionGateway = backendConnectionGateway;
            this.eventBus = eventBus;
        }

        @Subscribe
        public void handleLogoutEvent(LogoutEvent event) {
            if (this.backendConnectionGateway.getSession() == null) {
                this.onExchangeLogout.run();
                this.eventBus.unregister(this);
            }
        }
    }
}

