/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.order;

import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.StringColumn;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public class OrderMarketBasedColumn
extends StringColumn<Order>
implements ImportColumn<String, Order> {
    public static final boolean DEFAULT_MARKET_BASED_VALUE = Boolean.TRUE;
    private static final String LABEL_YES = Util.getLabel("commons_yes");
    private static final String LABEL_NO = Util.getLabel("commons_no");

    public OrderMarketBasedColumn(String header) {
        super(header);
    }

    @Override
    public void applyValue(String value, Order importedObject) throws ImportException {
        if (value == null) {
            importedObject.setMarketBased(DEFAULT_MARKET_BASED_VALUE);
        } else if (value.equalsIgnoreCase(LABEL_YES)) {
            importedObject.setMarketBased(Boolean.TRUE);
        } else if (value.equalsIgnoreCase(LABEL_NO)) {
            importedObject.setMarketBased(Boolean.FALSE);
        } else {
            throw new ImportException("Invalid Market Based", Util.getLabel("importException_invalidMarketBased"));
        }
    }

    @Override
    public String parseValue(String data) throws ImportException {
        if (StringUtils.isEmpty(data)) {
            return null;
        }
        if (data.equalsIgnoreCase(LABEL_YES) || data.equalsIgnoreCase(LABEL_NO)) {
            return data;
        }
        throw new ImportException("Invalid Market Based", Util.getLabel("importException_invalidMarketBased"));
    }

    @Override
    public String getValue(Order objectToExport) {
        return Boolean.TRUE.equals(objectToExport.isMarketBased()) ? LABEL_YES : LABEL_NO;
    }

    @Override
    public Collection<String> getErrorCodesKeys() {
        return Collections.singletonList(ValidationMessage.ORDER_VALIDATION_ERROR_MARKET_BASED_MANDATORY.getMessageKey());
    }
}

