/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.BasketRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.module.SenderExecutor;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.amqp.CorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ResponseWithCorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ErrorType;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandlerWithTimeout;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.event.ApplicationShutdownEvent;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderResponseHandlerFactory;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderSender;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderSubmitter;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrdersToSend;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.SentOrders;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.CrossTradeProtectionService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.OrderEntryProtectionService;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingSettingsService;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.m7.trading.api.Request;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.common.collect.ListMultimap;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@Singleton
public class CommonOrderSender
implements OrderSender {
    private static final Logger LOG = LoggerFactory.getLogger(CommonOrderSender.class);
    private static final Logger PERFORMANCE_LOG = LoggerFactory.getLogger("performance");
    private static final Marker ORDERBOOK_DELTA_MARKER = MarkerFactory.getMarker("ORDERBOOK_DELTA");
    private static final AtomicLong sentIdGenerator = new AtomicLong(-1L);
    private final ExecutorService executorService;
    private final ApplicationContext applicationContext;
    private final CrossTradeProtectionService crossTradeProtectionService;
    private final OrderEntryProtectionService orderEntryProtectionService;
    private final TradingSettingsService tradingSettingsService;
    private final BackendConnectionGateway backendConnectionGateway;
    private final OnBehalfService onBehalfService;
    private final UserAlertService userAlertService;
    private final OrderResponseHandlerFactory orderResponseHandlerFactory;
    private final DataModel<Long, Order> orderDataModel;
    private final TimeService timeService;
    private final UserService userService;
    private final MessagePublisher messagePublisher;

    @Inject
    public CommonOrderSender(ApplicationContext applicationContext) {
        this.crossTradeProtectionService = applicationContext.getService(CrossTradeProtectionService.class);
        this.backendConnectionGateway = applicationContext.getService(BackendConnectionGateway.class);
        this.tradingSettingsService = applicationContext.getService(TradingSettingsService.class);
        this.applicationContext = applicationContext;
        this.onBehalfService = applicationContext.getService(OnBehalfService.class);
        this.orderEntryProtectionService = applicationContext.getService(OrderEntryProtectionService.class);
        this.userAlertService = applicationContext.getService(UserAlertService.class);
        this.executorService = applicationContext.getService(ExecutorService.class, SenderExecutor.class);
        this.orderResponseHandlerFactory = applicationContext.getService(OrderResponseHandlerFactory.class);
        this.orderDataModel = applicationContext.getDataModel(Order.class);
        this.timeService = applicationContext.getService(TimeService.class);
        this.userService = applicationContext.getService(UserService.class);
        this.messagePublisher = applicationContext.getService(MessagePublisher.class);
    }

    @Subscribe
    public void handleApplicationShutdown(ApplicationShutdownEvent event) {
        this.executorService.shutdown();
    }

    @Override
    public void sendOrder(OrdersToSend ordersToSend) {
        this.sendOrder(ordersToSend, false);
    }

    @Override
    public void sendOrder(OrdersToSend ordersToSend, boolean allOrNothing) {
        this.sendOrder(ordersToSend, allOrNothing, null);
    }

    @Override
    public void sendOrder(OrdersToSend ordersToSend, boolean allOrNothing, Integer timeout) {
        this.executorService.submit(() -> this.sendOrderSync(ordersToSend, allOrNothing, timeout));
    }

    private void sendOrderSync(OrdersToSend ordersToSend, boolean allOrNothing, Integer timeout) {
        this.sendOrdersForExchange(ordersToSend, this.applicationContext.getService(ActiveExchange.class).getActiveExchange().get(), allOrNothing, timeout);
    }

    private void sendOrdersForExchange(OrdersToSend ordersToSend, Exchange exchange, boolean allOrNothing, Integer timeout) {
        boolean crossTradeProtectionPassed;
        BasketRestriction basketRestriction = ordersToSend.getBasketRestriction();
        RequestType requestType = ordersToSend.getRequestType();
        ResponseHandler responseHandler = ordersToSend.getResponseHandler().chain(this.messagePublisher::publishMessage).runInFxThread();
        OrderSubmitter submitter = this.applicationContext.getService(OrderSubmitter.class, exchange);
        if (submitter == null) {
            LOG.error("No submitter found for exchange {}", (Object)exchange);
            return;
        }
        List<Order> unconfirmedOrders = ordersToSend.getOrders();
        List<Order> confirmedOrders = this.orderSubmissionConfirmation(unconfirmedOrders, requestType);
        boolean confirmationPassed = !allOrNothing && !confirmedOrders.isEmpty() || unconfirmedOrders.size() == confirmedOrders.size();
        boolean onBehalfProtectionPassed = confirmationPassed && this.onBehalfProtectionPassed(confirmedOrders, requestType, ordersToSend.getOnBehalfUser());
        boolean orderEntryProtectionPassed = onBehalfProtectionPassed && this.orderEntryProtectionPassed(confirmedOrders, requestType);
        boolean bl = crossTradeProtectionPassed = orderEntryProtectionPassed && this.crossTradeProtectionPassed(confirmedOrders, requestType);
        if (crossTradeProtectionPassed) {
            ListMultimap<Request, Order> requests = submitter.createOrderRequests(confirmedOrders, requestType, basketRestriction, ordersToSend.getOnBehalfUser());
            for (Request request : requests.keySet()) {
                String correlationId = CorrelationId.next();
                Collection ordersForRequest = requests.get((Object)request);
                Map<String, OrderType> clientOrderIds = this.getClientOrderIds(ordersForRequest);
                OrdersToSend ordersToSendForRequest = new OrdersToSend(ordersForRequest, ordersToSend.getRequestType(), basketRestriction, responseHandler, ordersToSend.getOnBehalfUser());
                ResponseHandlerWithTimeout responseHandlerWithTimeout = this.getResponseHandlerWithTimeout(ordersToSendForRequest, correlationId, clientOrderIds.keySet(), timeout);
                SentOrders sentOrders = new SentOrders(responseHandlerWithTimeout, exchange, basketRestriction, clientOrderIds, correlationId);
                ObjectHandler<Object> objectHandler = this.getObjectHandler(submitter, sentOrders);
                ObjectHandler<Object> performanceLogObjectHandler = this.getPerformanceLogObjectHandler(submitter, correlationId);
                ExchangeConnection connection = this.backendConnectionGateway.getConnection();
                connection.addObjectHandler(objectHandler);
                connection.addObjectHandler(performanceLogObjectHandler);
                FxUtil.runInFxThread(() -> this.lambda$sendOrdersForExchange$3((List)ordersForRequest, ordersToSend, responseHandlerWithTimeout, connection, objectHandler, request, correlationId, submitter));
            }
        } else {
            responseHandler.handleResponse(new AsyncResponse(ResponseStatus.ERROR, null, null, ErrorType.CROSS_TRADE_PROTECTION_VETO));
        }
    }

    private void markOrdersAsSent(List<Order> orders, RequestType requestType) {
        UnaryOperator orderTransformer = requestType == RequestType.ADD ? this::markOrderAsSent : this::markOrderAsModified;
        List<Order> sentOrders = orders.stream().map(orderTransformer).filter(Objects::nonNull).toList();
        if (sentOrders.size() == 1) {
            this.orderDataModel.handleBroadcastEntity(sentOrders.get(0));
        } else if (sentOrders.size() > 1) {
            this.orderDataModel.handleBroadcastEntities(sentOrders);
        }
    }

    private Order markOrderAsModified(Order order) {
        if (this.orderDataModel.findById((Long)order.getId()) != null) {
            Order modifiedOrder = new Order(order);
            modifiedOrder.setStatus(OrderStatus.MODI);
            return modifiedOrder;
        }
        return null;
    }

    private Order markOrderAsSent(Order order) {
        Order sentOrder = new Order(order);
        if (order.getStatus() != OrderStatus.ERROR) {
            sentOrder.setId(sentIdGenerator.getAndDecrement());
        }
        sentOrder.setStatus(OrderStatus.SENT);
        sentOrder.setInitialQuantity(order.getRemainingQuantity());
        User user = this.userService.getCurrentUser();
        sentOrder.setUser(user);
        sentOrder.setTraderUserCode(user.getUserCode());
        sentOrder.setMemberCode(user.getMemberId());
        sentOrder.setRevisionNumber(Long.MIN_VALUE);
        sentOrder.setTimeStamp(this.timeService.getServerTime());
        sentOrder.setLastUpdateTimeStamp(this.timeService.getServerTime());
        return sentOrder;
    }

    private ResponseHandlerWithTimeout getResponseHandlerWithTimeout(OrdersToSend ordersToSend, String correlationId, Set<String> clientOrderIds, Integer timeout) {
        return this.orderResponseHandlerFactory.createResponseHandler(ordersToSend, correlationId, clientOrderIds, timeout);
    }

    private Map<String, OrderType> getClientOrderIds(Collection<Order> orders) {
        ConcurrentHashMap<String, OrderType> clientOrderIds = new ConcurrentHashMap<String, OrderType>();
        for (Order order : orders) {
            if (order.getClientOrderId() == null) {
                order.initNewClientOrderId();
            }
            clientOrderIds.put(order.getClientOrderId(), order.getOrderType());
        }
        return clientOrderIds;
    }

    protected void handleRuntimeException(RuntimeException e, ResponseHandler responseHandler) {
        LOG.error("Error while sending orders", e);
        responseHandler.handleGeneralError(e.getMessage());
    }

    private boolean onBehalfProtectionPassed(List<Order> confirmedOrders, RequestType requestType, User onBehalfUser) {
        User user;
        User user2 = user = onBehalfUser != null ? onBehalfUser : this.onBehalfService.getOnBehalfUser();
        if (user != null) {
            String header;
            String question = switch (requestType) {
                case RequestType.ADD -> {
                    header = Util.getLabel("onBehalf_add_order_questionHeader_submit");
                    yield Util.getLabel("onBehalf_add_order_question_submit");
                }
                case RequestType.ACTIVATE -> {
                    header = Util.getLabel("commons_activateOrderOnBehalf");
                    yield Util.getLabel("onBehalf_activate_orders_question");
                }
                case RequestType.DEACTIVATE -> {
                    header = Util.getLabel("onBehalf_deactivate_orders_question_header");
                    yield Util.getLabel("onBehalf_deactivate_orders_question");
                }
                case RequestType.MODIFY -> {
                    header = Util.getLabel("commons_modifyOrderOnBehalf");
                    yield Util.getLabel("onBehalf_modify_order_question_submit");
                }
                case RequestType.DELETE -> {
                    header = Util.getLabel("onBehalf_cancel_order_questionHeader_submit");
                    yield Util.getLabel("onBehalf_cancel_order_question_submit");
                }
                default -> throw new IllegalArgumentException("Invalid RequestType");
            };
            String confirmedOrdersText = confirmedOrders.stream().map(order -> this.formatOrderForOnBehalfQuestion((Order)order, user)).collect(Collectors.joining("\n"));
            if (confirmedOrdersText.length() > 300) {
                return this.userAlertService.showQuestionDialog(header, question, confirmedOrdersText, false, new UserAlertService.Flag[0]);
            }
            return this.userAlertService.showQuestionDialog(header, question + "\n\n" + confirmedOrdersText, new UserAlertService.Flag[0]);
        }
        return true;
    }

    private String formatOrderForOnBehalfQuestion(Order order, User user) {
        return Util.getLabel("onBehalf_submit_order_format", user.getMember().getDisplayName(), user.getDisplayName(), Util.getLabel(order.getDirection().getLabelKey()), order.getContract().getName(), order.getRemainingQuantity(), order.getContract().getProduct().getQuantityUnit(), order.getLimitPrice(), order.getContract().getProduct().getCurrencyCode(), order.getDeliveryArea().getName());
    }

    private void processServerResponse(ResponseWithCorrelationId response, ResponseHandlerWithTimeout responseHandler, OrderSubmitter submitter, ExchangeConnection connection, ObjectHandler<Object> objectHandler) {
        if (response.getResponse() != null) {
            boolean expectOtherMessages = submitter.processImmediateServerResponse(response.getResponse(), responseHandler);
            if (!expectOtherMessages) {
                connection.removeObjectHandler(objectHandler);
            }
        } else {
            boolean timeoutCanceled = responseHandler.cancel();
            if (timeoutCanceled) {
                responseHandler.runInFxThread().handleResponse(new AsyncResponse(ResponseStatus.ERROR, null, Util.getLabel("commons_noResponseFromServerOrder"), ErrorType.NO_RESPONSE));
            }
            connection.removeObjectHandler(objectHandler);
        }
    }

    private ObjectHandler<Object> getObjectHandler(OrderSubmitter submitter, SentOrders sentOrders) {
        return (session, object, correlationId) -> {
            if (sentOrders.getCorrelationId().equals(correlationId)) {
                return submitter.processAsyncServerResponse(object, sentOrders) ? ObjectHandler.Result.RETAIN : ObjectHandler.Result.REMOVE;
            }
            return ObjectHandler.Result.RETAIN;
        };
    }

    @Override
    public void sendEmergencyOrder(Exchange exchange, RequestType requestType, boolean considerOnBehalf, ResponseHandler responseHandler) {
        ResponseHandler wrappedResponseHandler = responseHandler.chain(this.messagePublisher::publishMessage);
        this.executorService.submit(() -> {
            try {
                OrderSubmitter submitter = this.applicationContext.getService(OrderSubmitter.class, exchange);
                if (submitter == null) {
                    LOG.error("No submitter found for exchange {}", (Object)exchange);
                } else {
                    Request request = submitter.createEmergencyOrderRequest(requestType, considerOnBehalf);
                    this.sendRequestWithoutTimeout(exchange, wrappedResponseHandler, submitter, request);
                }
            }
            catch (RuntimeException e) {
                this.handleRuntimeException(e, wrappedResponseHandler);
            }
        });
    }

    private void sendRequestWithoutTimeout(Exchange exchange, ResponseHandler responseHandler, OrderSubmitter submitter, Request request) {
        String correlationId = CorrelationId.next();
        ExchangeConnection connection = this.backendConnectionGateway.getConnection();
        SentOrders sentOrders = new SentOrders(responseHandler, exchange, null, Collections.emptyMap(), correlationId);
        ObjectHandler<Object> objectHandler = this.getObjectHandler(submitter, sentOrders);
        connection.addObjectHandler(objectHandler);
        ResponseWithCorrelationId response = connection.sendRequest(request, false, correlationId);
        submitter.processImmediateServerResponse(response.getResponse(), responseHandler);
    }

    private List<Order> orderSubmissionConfirmation(List<Order> unconfirmedOrders, RequestType requestType) {
        return this.tradingSettingsService.showOrderConfirmationPopup(unconfirmedOrders, requestType);
    }

    protected boolean crossTradeProtectionPassed(List<Order> orders, RequestType requestType) {
        boolean skipCrossTradeProtection = !this.crossTradeProtectionService.isEnabled() || RequestType.DELETE == requestType || RequestType.DEACTIVATE == requestType;
        boolean isModify = RequestType.MODIFY == requestType;
        return skipCrossTradeProtection || this.crossTradeProtectionService.checkOrdersWithEachOther(orders, true) && (isModify && this.crossTradeProtectionService.checkOrdersWithExclusion(orders, true) || !isModify && this.crossTradeProtectionService.checkOrders(orders, true));
    }

    private boolean orderEntryProtectionPassed(List<Order> orders, RequestType requestType) {
        return RequestType.DELETE == requestType || RequestType.DEACTIVATE == requestType || this.orderEntryProtectionService.checkOrders(orders);
    }

    private ObjectHandler<Object> getPerformanceLogObjectHandler(OrderSubmitter submitter, String expectedCorrelationId) {
        long now = System.currentTimeMillis();
        return (session, object, correlationId) -> {
            long elapsed = System.currentTimeMillis() - now;
            if (expectedCorrelationId.equals(correlationId) && submitter.isOrderbookUpdateBroadcastOrError(object)) {
                PERFORMANCE_LOG.debug(ORDERBOOK_DELTA_MARKER, Long.toString(elapsed));
                return ObjectHandler.Result.REMOVE;
            }
            if (elapsed > 300000L) {
                LOG.info("No orderbook message received for submitted order with correlation id {} (maybe due to the batch processing on backend)", (Object)expectedCorrelationId);
                return ObjectHandler.Result.REMOVE;
            }
            return ObjectHandler.Result.RETAIN;
        };
    }

    private /* synthetic */ void lambda$sendOrdersForExchange$3(List ordersForRequest, OrdersToSend ordersToSend, ResponseHandlerWithTimeout responseHandlerWithTimeout, ExchangeConnection connection, ObjectHandler objectHandler, Request request, String correlationId, OrderSubmitter submitter) {
        this.markOrdersAsSent(ordersForRequest, ordersToSend.getRequestType());
        responseHandlerWithTimeout.startTimeout(() -> connection.removeObjectHandler(objectHandler));
        this.executorService.execute(() -> {
            try {
                ResponseWithCorrelationId response = connection.sendRequest(request, false, correlationId);
                this.processServerResponse(response, responseHandlerWithTimeout, submitter, connection, objectHandler);
            }
            catch (RuntimeException e) {
                this.handleRuntimeException(e, responseHandlerWithTimeout);
            }
        });
    }
}

