/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.orderentry;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ErrorType;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandlerWithTimeout;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandlerWithTimeoutFactory;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.FailedOrderSubmissionEvent;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderModificationErrorDialog;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderResponseHandlerFactory;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrdersToSend;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.Basket;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.BasketFullException;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.BasketService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

@Singleton
public class OrderResponseHandlerFactoryImpl
implements OrderResponseHandlerFactory {
    private final ResponseHandlerWithTimeoutFactory responseHandlerWithTimeoutFactory;
    private final ApplicationContext applicationContext;

    @Inject
    public OrderResponseHandlerFactoryImpl(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.responseHandlerWithTimeoutFactory = applicationContext.getService(ResponseHandlerWithTimeoutFactory.class);
    }

    @Override
    public ResponseHandlerWithTimeout createResponseHandler(OrdersToSend ordersToSend, String correlationId, Set<String> clientOrderIds, Integer timeout) {
        OrderResponseHandlerImpl orderResponseHandler = new OrderResponseHandlerImpl(ordersToSend, clientOrderIds, this.applicationContext);
        return this.getResponseHandlerWithTimeout(orderResponseHandler, correlationId, clientOrderIds, timeout);
    }

    private ResponseHandlerWithTimeout getResponseHandlerWithTimeout(ResponseHandler responseHandler, String correlationId, Set<String> clientOrderIds, Integer timeout) {
        if (timeout == null) {
            return this.responseHandlerWithTimeoutFactory.createHandler(responseHandler, correlationId, clientOrderIds::isEmpty);
        }
        return this.responseHandlerWithTimeoutFactory.createHandler(responseHandler, correlationId, clientOrderIds::isEmpty, timeout);
    }

    private static class OrderResponseHandlerImpl
    implements ResponseHandler {
        private final ResponseHandler wrapped;
        private final Set<String> clientOrderIds;
        private final ApplicationContext applicationContext;
        private final OrderQueries orderQueries;
        private final DataModel<Long, Order> orderDataModel;
        private final Map<String, Order> ordersBeforeModification;
        private final Map<String, Order> ordersToSend;
        private final EventBus eventBus;

        public OrderResponseHandlerImpl(OrdersToSend ordersToSend, Set<String> clientOrderIds, ApplicationContext applicationContext) {
            this.wrapped = ordersToSend.getResponseHandler();
            this.clientOrderIds = clientOrderIds;
            this.applicationContext = applicationContext;
            this.orderQueries = applicationContext.getService(OrderQueries.class);
            this.orderDataModel = applicationContext.getDataModel(Order.class);
            this.eventBus = applicationContext.getService(EventBus.class);
            this.ordersBeforeModification = ordersToSend.getOrders().stream().map(BroadcastEntity::getId).filter(Objects::nonNull).map(this.orderDataModel::findById).filter(Objects::nonNull).map(Order::new).collect(Collectors.toMap(Order::getClientOrderId, Function.identity()));
            this.ordersToSend = ordersToSend.getOrders().stream().map(Order::new).collect(Collectors.toMap(Order::getClientOrderId, Function.identity()));
        }

        @Override
        public void handleResponse(AsyncResponse response) {
            if (response.getStatus() == ResponseStatus.ERROR && response.getClientOrderId() != null) {
                this.handleError(response);
                this.wrapped.handleResponse(response);
            } else if (response.getStatus() == ResponseStatus.ERROR && response.getClientOrderId() == null) {
                this.handleGeneralError(response);
            } else {
                this.wrapped.handleResponse(response);
            }
        }

        private void handleError(AsyncResponse response) {
            String clientOrderId = response.getClientOrderId();
            Optional<Order> order = this.orderQueries.findUnconfirmedByClientOrderId(clientOrderId);
            if (order.isPresent() && order.get().getStatus() == OrderStatus.SENT) {
                this.orderEntryFailed(response, order.get());
            } else if (order.isPresent() && order.get().getStatus() == OrderStatus.MODI) {
                Order lastKnownVersion = this.ordersBeforeModification.get(clientOrderId);
                this.orderDataModel.handleBroadcastEntity(lastKnownVersion);
                Order sentOrder = this.ordersToSend.get(clientOrderId);
                this.orderModificationFailed(new Order(sentOrder), response);
            } else if (this.isFailedModification(response)) {
                Order sentOrder = this.ordersToSend.get(clientOrderId);
                Optional<Order> currentVersion = this.orderQueries.findActiveByClientOrderId(clientOrderId);
                if (currentVersion.isPresent()) {
                    sentOrder.setId((Long)currentVersion.get().getId());
                    sentOrder.setRevisionNumber(currentVersion.get().getRevisionNumber());
                    this.orderModificationFailed(sentOrder, response);
                } else {
                    this.applicationContext.getService(UserAlertService.class).showConfirmationDialog(Util.getLabel("orderModificationErrorDialog_header"), Util.getLabel("orderEntryPanel_concurrentModificationQuestionInvalidated", sentOrder.getInitialOrderId()), UserAlertService.Flag.OK);
                }
            }
        }

        private boolean isFailedModification(AsyncResponse response) {
            String clientOrderId = response.getClientOrderId();
            return this.ordersToSend.containsKey(clientOrderId) && this.ordersBeforeModification.containsKey(clientOrderId) && this.ordersBeforeModification.get(clientOrderId).getStatus() != OrderStatus.ERROR;
        }

        private void orderEntryFailed(AsyncResponse response, Order order) {
            Order errorOrder = new Order(order);
            errorOrder.setStatus(OrderStatus.ERROR);
            errorOrder.setRevisionNumber(errorOrder.getRevisionNumber() + 1L);
            errorOrder.setErrorMessage(response.getMessage());
            this.applicationContext.getDataModel(Order.class).handleBroadcastEntity(errorOrder);
            this.eventBus.post(new FailedOrderSubmissionEvent(FailedOrderSubmissionEvent.Type.ENTRY));
        }

        private void handleGeneralError(AsyncResponse response) {
            this.clientOrderIds.stream().map(response::copyWithClientOrderId).forEach(this::handleResponse);
            if (response.getErrorType() == ErrorType.BASKET_NOT_VALID || response.getErrorType() == ErrorType.LINKED_BASKET_NOT_MATCHED) {
                this.linkedOrValidBasketSubmissionFailed(response);
            }
        }

        private void linkedOrValidBasketSubmissionFailed(AsyncResponse response) {
            List<Order> failedOrders = this.ordersToSend.keySet().stream().map(this::loadFailedOrderFromBasketSubmission).toList();
            List<Order> failedOrdersWithIds = failedOrders.stream().filter(order -> order.getId() != null).toList();
            if (CollectionUtils.isNotEmpty(failedOrdersWithIds)) {
                this.orderDataModel.removeAll(failedOrdersWithIds);
            }
            this.wrapped.handleResponse(response);
            boolean dismissBasketSubmissionError = this.applicationContext.getService(UserAlertService.class).showQuestionDialog(Util.getLabel("basket_submissionFailed"), response.getMessage(), UserAlertService.Flag.OK_ADD_TO_BASKED);
            if (!dismissBasketSubmissionError) {
                Basket basket = this.applicationContext.getService(BasketService.class).getActiveBasket();
                try {
                    for (Order order2 : failedOrders) {
                        basket.add(order2);
                    }
                }
                catch (BasketFullException e) {
                    this.applicationContext.getService(MessagePublisher.class).publishMessage(Util.getLabel("basketFullMessage", e.getAllowed()), MessageSeverity.ERROR);
                }
            }
        }

        private Order loadFailedOrderFromBasketSubmission(String clientOrderId) {
            Order order = this.orderQueries.findUnconfirmedByClientOrderId(clientOrderId).orElse(this.ordersToSend.get(clientOrderId));
            order.setStatus(this.ordersToSend.get(clientOrderId).getStatus());
            return order;
        }

        private void orderModificationFailed(Order order, AsyncResponse asyncResponse) {
            this.eventBus.post(new FailedOrderSubmissionEvent(FailedOrderSubmissionEvent.Type.MODIFICATION));
            this.applicationContext.getService(OrderModificationErrorDialog.class).orderModificationFailed(order, asyncResponse);
        }
    }
}

