/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.profile;

import com.deutscheboerse.comxerv.comtrader.service.profile.FaultTolerantRemoteProfileService;
import com.deutscheboerse.comxerv.comtrader.service.profile.LocalProfileService;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.ProfileService;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.ProfileServiceException;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.data.Profile;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LocalAndRemoteProfileService
implements ProfileService {
    private static final Logger LOG = LoggerFactory.getLogger(LocalAndRemoteProfileService.class);
    private final ProfileService localProfileService;
    private final ProfileService remoteProfileService;

    @Inject
    public LocalAndRemoteProfileService(LocalProfileService localProfileService, FaultTolerantRemoteProfileService remoteProfileService) {
        this.localProfileService = localProfileService;
        this.remoteProfileService = remoteProfileService;
    }

    @Override
    public boolean profileExists(String exchangeId, String userName, String environmentId) throws ProfileServiceException {
        Optional<Boolean> localExists = this.profileExists(this.localProfileService, exchangeId, userName, environmentId);
        Optional<Boolean> remoteExists = this.profileExists(this.remoteProfileService, exchangeId, userName, environmentId);
        if (!localExists.isPresent() && !remoteExists.isPresent()) {
            throw new ProfileServiceException(ProfileServiceException.ErrorType.OTHER, "Could not check profile.");
        }
        return localExists.orElse(false) != false || remoteExists.orElse(false) != false;
    }

    private Optional<Boolean> profileExists(ProfileService profileService, String exchangeId, String userName, String environmentId) {
        try {
            return Optional.ofNullable(profileService.profileExists(exchangeId, userName, environmentId));
        }
        catch (ProfileServiceException e) {
            LOG.error("Could not check profile.", e);
            return Optional.empty();
        }
    }

    @Override
    public void createProfile(Profile profile) throws ProfileServiceException {
        try {
            this.createProfile(profile, this.remoteProfileService);
        }
        catch (ProfileServiceException e) {
            LOG.error("Could not create profile", e);
        }
        finally {
            this.createProfile(profile, this.localProfileService);
        }
    }

    private void createProfile(Profile profile, ProfileService profileService) {
        try {
            profileService.createProfile(profile);
        }
        catch (ProfileServiceException e) {
            if (e.getErrorType() == ProfileServiceException.ErrorType.PROFILE_ALREADY_EXISTS) {
                profileService.storeProfile(profile);
            }
            throw e;
        }
    }

    @Override
    public void storeProfile(Profile profile) throws ProfileServiceException {
        try {
            this.storeProfile(profile, this.remoteProfileService);
        }
        catch (ProfileServiceException e) {
            LOG.error("Could not store profile", e);
        }
        finally {
            this.storeProfile(profile, this.localProfileService);
        }
    }

    private void storeProfile(Profile profile, ProfileService profileService) {
        try {
            profileService.storeProfile(profile);
        }
        catch (ProfileServiceException e) {
            if (e.getErrorType() == ProfileServiceException.ErrorType.PROFILE_DOESNT_EXIST) {
                profileService.createProfile(profile);
            }
            throw e;
        }
    }

    @Override
    public Profile loadProfile(String exchangeId, String userName, String environmentId) throws ProfileServiceException {
        Optional<Profile> remoteProfile = this.getProfile(this.remoteProfileService, exchangeId, userName, environmentId);
        Optional<Profile> localProfile = this.getProfile(this.localProfileService, exchangeId, userName, environmentId);
        Optional<Profile> profile = this.getProfile(remoteProfile, localProfile);
        if (!remoteProfile.isPresent() && !localProfile.isPresent()) {
            throw new ProfileServiceException(ProfileServiceException.ErrorType.OTHER, "Could not load profile.");
        }
        if (remoteProfile.isPresent()) {
            this.overwriteProfile(remoteProfile.get(), this.localProfileService);
        } else {
            this.overwriteProfile(localProfile.get(), this.remoteProfileService);
        }
        return profile.get();
    }

    private void overwriteProfile(Profile profile, ProfileService destinationProfileService) {
        try {
            if (destinationProfileService.profileExists(profile.getExchangeId(), profile.getUserName(), profile.getEnvironmentId())) {
                destinationProfileService.storeProfile(profile);
            } else {
                destinationProfileService.createProfile(profile);
            }
        }
        catch (ProfileServiceException e) {
            LOG.error("Could not overwrite profile.", e);
        }
    }

    private Optional<Profile> getProfile(Optional<Profile> remoteProfile, Optional<Profile> localProfile) {
        return Stream.of(remoteProfile, localProfile).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private Optional<Profile> getProfile(ProfileService service, String exchangeId, String userName, String environmentId) {
        try {
            return Optional.ofNullable(service.loadProfile(exchangeId, userName, environmentId));
        }
        catch (ProfileServiceException e) {
            LOG.error("Could not load profile", e);
            return Optional.empty();
        }
    }
}

