/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.profile;

import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileContent;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileContentWithFormatVersion;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileMigrationService;
import com.deutscheboerse.comxerv.comtrader.service.profile.UserProfile;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.ProfileServiceException;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.data.Profile;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.io.xml.WstxDriver;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.security.NoTypePermission;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProfileSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(ProfileSerializer.class);
    private final XStream xStream = new XStream(new WstxDriver());
    private final ProfileMigrationService profileMigrationService;

    @Inject
    public ProfileSerializer(ProfileMigrationService profileMigrationService) {
        this.xStream.ignoreUnknownElements();
        this.xStream.addPermission(NoTypePermission.NONE);
        this.xStream.allowTypesByWildcard(new String[]{"com.deutscheboerse.**", "com.sun.javafx.**", "org.joda.**", "java.**", "javafx.**", "com.thoughtworks.xstream.mapper.**"});
        this.xStream.alias("ProfileContent", ProfileContent.class);
        this.xStream.alias("ProfileContentWithFormatVersion", ProfileContent.class);
        this.profileMigrationService = profileMigrationService;
    }

    public UserProfile getUserProfile(Profile profile) {
        UserProfile userProfile = new UserProfile();
        userProfile.setExchangeId(profile.getExchangeId());
        userProfile.setEnvironment(profile.getEnvironmentId());
        userProfile.setUserName(profile.getUserName());
        userProfile.setLastProfileSaveTimeStamp(profile.getLastProfileSaveTimeStamp());
        ProfileContentWithFormatVersion oldContent = new ProfileContentWithFormatVersion((ProfileContent)this.readValue(profile.getContent()), profile.getFormatVersion());
        ProfileContentWithFormatVersion migratedContent = this.profileMigrationService.migrateProfile(oldContent);
        userProfile.setFormatVersion(migratedContent.getFormatVersion());
        this.setUserProfileContent(userProfile, migratedContent);
        return userProfile;
    }

    public Profile getProfile(UserProfile userProfile) {
        Profile profile = new Profile();
        profile.setExchangeId(userProfile.getExchangeId());
        profile.setEnvironmentId(userProfile.getEnvironment());
        profile.setUserName(userProfile.getUserName());
        profile.setLastProfileSaveTimeStamp(userProfile.getLastProfileSaveTimeStamp());
        profile.setFormatVersion(userProfile.getFormatVersion());
        ProfileContent profileContent = new ProfileContent();
        this.setContent(profileContent, userProfile);
        profile.setContent(this.writeValue(profileContent));
        return profile;
    }

    private void setContent(ProfileContent profileContent, UserProfile userProfile) {
        profileContent.setSettings(this.serializeMap(userProfile.getSettings()));
        profileContent.setComponentData(this.serializeMap(userProfile.getComponentData()));
        profileContent.setStages(this.serializeMap(userProfile.getStages()));
    }

    public String getProfileContentForExport(UserProfile userProfile) {
        ProfileContentWithFormatVersion profileContentWithFormatVersion = new ProfileContentWithFormatVersion();
        profileContentWithFormatVersion.setFormatVersion(userProfile.getFormatVersion());
        this.setContent(profileContentWithFormatVersion, userProfile);
        return this.writeValue(profileContentWithFormatVersion);
    }

    private Map<String, String> serializeMap(Map<String, ?> data) {
        HashMap<String, String> serializedData = new HashMap<String, String>();
        data.entrySet().forEach(entry -> serializedData.put((String)entry.getKey(), this.writeValue(entry.getValue())));
        return serializedData;
    }

    public UserProfile loadExportedProfile(String data) {
        ProfileContentWithFormatVersion oldContent;
        try {
            oldContent = (ProfileContentWithFormatVersion)this.readValue(data);
        }
        catch (Exception e) {
            throw new ProfileServiceException(ProfileServiceException.ErrorType.IO_ERROR, "Could not load profile", e);
        }
        ProfileContentWithFormatVersion migratedContent = this.profileMigrationService.migrateProfile(oldContent);
        UserProfile userProfile = new UserProfile();
        userProfile.setFormatVersion(migratedContent.getFormatVersion());
        this.setUserProfileContent(userProfile, migratedContent);
        return userProfile;
    }

    private void setUserProfileContent(UserProfile userProfile, ProfileContent profileContent) {
        userProfile.setSettings(this.deserializeMap(profileContent.getSettings()));
        userProfile.setComponentData(this.deserializeMap(profileContent.getComponentData()));
        userProfile.setStages(this.deserializeMap(profileContent.getStages()));
    }

    private <T> Map<String, T> deserializeMap(Map<String, String> serializedData) {
        HashMap<String, T> data = new HashMap<String, T>();
        for (Map.Entry<String, String> entry : serializedData.entrySet()) {
            try {
                T readValue = this.readValue(entry.getValue());
                data.put(entry.getKey(), readValue);
            }
            catch (CannotResolveClassException crce) {
                LOG.warn("{} not deserialized.", (Object)entry.getKey());
            }
            catch (ConversionException ce) {
                if (ce.getCause() instanceof CannotResolveClassException) {
                    LOG.warn("{} not deserialized.", (Object)entry.getKey());
                    continue;
                }
                throw ce;
            }
        }
        return data;
    }

    protected String writeValue(Object value) {
        try {
            return this.xStream.toXML(value);
        }
        catch (RuntimeException e) {
            LOG.error("Could not serialize value.", e);
            throw e;
        }
    }

    protected <T> T readValue(String data) {
        try {
            return (T)this.xStream.fromXML(data);
        }
        catch (RuntimeException e) {
            LOG.error("Could not parse value.", e);
            throw e;
        }
    }
}

