/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.trade;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.TradeSettlement;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeSettlementProcessor;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TradeSettlementProcessorImpl
implements TradeSettlementProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TradeSettlementProcessorImpl.class);
    private final DataModel<Long, FullTrade> fullTradeDataModel;

    @Inject
    public TradeSettlementProcessorImpl(ApplicationContext applicationContext) {
        this.fullTradeDataModel = applicationContext.getDataModel(FullTrade.class);
    }

    @Override
    public void processTradeSettlement(TradeSettlement tradeSettlement) {
        FullTrade fullTrade = this.fullTradeDataModel.findById((Long)tradeSettlement.getId());
        if (fullTrade != null) {
            fullTrade.updateTradeSettlement(tradeSettlement);
        } else {
            LOG.warn("Trade not found for settlement info: {}", tradeSettlement.getId());
        }
    }
}

