/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.trade;

import com.deutscheboerse.comxerv.comtrader.core.util.DisplayName;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryType;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.collect.Sets;
import java.util.Set;

public enum TradingAction implements DisplayName
{
    MATCH("commons_matchOrLiftOrder"),
    ADD("commons_addOrderLabel"),
    SIMPLE_MATCH("commons_simpleMatchOrder"),
    SIMPLE_ADD("commons_simpleAddOrder"),
    CONTEXT_MENU("mouseClickActionType_contextMenu"),
    MODIFY("commons_modifyOwnOrder"),
    NO_ACTION("commons_noAction");

    private final String displayName;
    private static final Set<TradingAction> AGGREGATED_ACTIONS;
    private static final Set<TradingAction> NOT_AGGREGATED_ACTIONS;

    private TradingAction(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return Util.getLabel(this.displayName);
    }

    public static Set<TradingAction> values(OrderbookEntryType type) {
        switch (type) {
            case AGGREGATED: {
                return AGGREGATED_ACTIONS;
            }
            case NOT_AGGREGATED: {
                return NOT_AGGREGATED_ACTIONS;
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    static {
        AGGREGATED_ACTIONS = Sets.immutableEnumSet((Enum)MATCH, (Enum[])new TradingAction[]{ADD, SIMPLE_MATCH, SIMPLE_ADD, NO_ACTION});
        NOT_AGGREGATED_ACTIONS = Sets.immutableEnumSet((Enum)MATCH, (Enum[])new TradingAction[]{ADD, SIMPLE_MATCH, SIMPLE_ADD, MODIFY, CONTEXT_MENU, NO_ACTION});
    }
}

