/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.regex.Pattern;

public class NumberFormatUtils {
    private NumberFormatUtils() {
    }

    public static boolean isNumber(String str, DecimalFormat decimalFormat) {
        if (str == null || str.length() == 0) {
            return false;
        }
        String regex = NumberFormatUtils.numberRegex(decimalFormat);
        return str.matches(regex);
    }

    private static String numberRegex(DecimalFormat decimalFormat) {
        DecimalFormatSymbols decimalSymbols = decimalFormat.getDecimalFormatSymbols();
        String decimalSep = Pattern.quote("" + decimalSymbols.getDecimalSeparator());
        String groupSep = Pattern.quote("" + decimalSymbols.getGroupingSeparator());
        String decimalPart = "(" + decimalSep + "[0-9]*)?";
        if (decimalFormat.isGroupingUsed()) {
            return "-?[0-9]{1,3}(" + groupSep + "[0-9]{3})*" + decimalPart;
        }
        return "-?[0-9]+" + decimalPart;
    }

    public static char decimalSeparator(DecimalFormat numberFormat) {
        return numberFormat.getDecimalFormatSymbols().getDecimalSeparator();
    }
}

