/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.m7.trading.api.type;

import java.util.HashMap;
import java.util.Map;

public enum StatusMessageScope {
    NOBODY("NOB"),
    PUBLIC("PUB"),
    PUBLIC_PRODUCT("PRD"),
    MARKET_AREA("MAR"),
    ADMIN("ADM"),
    ADMIN_PRODUCT("ADP"),
    NON_ADMIN("NAD"),
    NON_ADMIN_PRODUCT("NAP"),
    BALGRP("BGR"),
    BALGRP_PRODUCT("BGP"),
    MEMBER("MEM"),
    MEMBER_PRODUCT("MEP");

    private static final Map<String, StatusMessageScope> map;
    private final String value;

    private StatusMessageScope(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static StatusMessageScope getType(String name) {
        StatusMessageScope scope = map.get(name);
        if (scope == null) {
            throw new IllegalArgumentException("No StatusMessageScope '" + name + "'");
        }
        return scope;
    }

    static {
        map = new HashMap<String, StatusMessageScope>(StatusMessageScope.values().length + 1, 1.0f);
        for (StatusMessageScope scope : StatusMessageScope.values()) {
            StatusMessageScope prev = map.put(scope.getValue(), scope);
            if (prev == null) continue;
            throw new IllegalStateException("Duplicate key for StatusMessageScope: " + scope.getValue());
        }
    }
}

