/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.css.Styleable;
import javafx.scene.Parent;
import javafx.scene.Scene;

public class StyleUtil {
    public static void addStyleClass(Styleable node, String styleClass) {
        if (!node.getStyleClass().contains(styleClass)) {
            node.getStyleClass().add(styleClass);
        }
    }

    public static void addStyleClasses(Styleable node, String ... styleClasses) {
        for (String styleClass : styleClasses) {
            StyleUtil.addStyleClass(node, styleClass);
        }
    }

    public static void addStyleClass(Styleable node, String styleClass, boolean condition) {
        if (condition) {
            StyleUtil.addStyleClass(node, styleClass);
        } else {
            node.getStyleClass().remove(styleClass);
        }
    }

    public static void addStylePath(Scene scene, String cssPath) {
        if (scene != null && !scene.getStylesheets().contains(cssPath)) {
            scene.getStylesheets().add(cssPath);
        }
    }

    public static void addStylePath(Parent scene, String cssPath) {
        if (scene != null && !scene.getStylesheets().contains(cssPath)) {
            scene.getStylesheets().add(cssPath);
        }
    }

    public static void addStyleClass(Styleable node, String trueClass, String falseClass, boolean condition) {
        if (condition) {
            node.getStyleClass().remove(falseClass);
            StyleUtil.addStyleClass(node, trueClass);
        } else {
            node.getStyleClass().remove(trueClass);
            StyleUtil.addStyleClass(node, falseClass);
        }
    }

    public static void setStyleClass(Styleable node, List<String> styleClasses) {
        List styleClasses2Remove = node.getStyleClass().stream().filter(s -> !styleClasses.contains(s)).collect(Collectors.toList());
        List styleClasses2Add = styleClasses.stream().filter(s -> !node.getStyleClass().contains(s)).collect(Collectors.toList());
        if (!styleClasses2Remove.isEmpty() && !styleClasses2Add.isEmpty()) {
            node.getStyleClass().setAll((Collection<String>)styleClasses);
        } else {
            if (!styleClasses2Remove.isEmpty()) {
                node.getStyleClass().removeAll(styleClasses2Remove);
            }
            if (!styleClasses2Add.isEmpty()) {
                node.getStyleClass().addAll(styleClasses2Add);
            }
        }
    }
}

