/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util.control.table;

import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;

public class AllColumnsEqualWidthListener {
    private final TableView tableView;
    private final WeakInvalidationListener weakRebindColumnsListener;

    private AllColumnsEqualWidthListener(TableView tableView) {
        this.tableView = tableView;
        ObservableList columns = tableView.getColumns();
        InvalidationListener rebindColumnsListener = observable2 -> this.rebindColumns();
        this.weakRebindColumnsListener = new WeakInvalidationListener(rebindColumnsListener);
        columns.addListener(this::columnsChanged);
        columns.stream().map(TableColumnBase::visibleProperty).forEach(column -> column.addListener(this.weakRebindColumnsListener));
    }

    private void columnsChanged(ListChangeListener.Change<? extends TableColumn> c) {
        while (c.next()) {
            for (TableColumn tableColumn : c.getRemoved()) {
                tableColumn.visibleProperty().removeListener(this.weakRebindColumnsListener);
            }
            for (TableColumn tableColumn : c.getAddedSubList()) {
                tableColumn.visibleProperty().addListener(this.weakRebindColumnsListener);
            }
        }
        this.rebindColumns();
    }

    private void rebindColumns() {
        ObservableList columns = this.tableView.getColumns();
        ReadOnlyDoubleProperty tableWidth = this.tableView.widthProperty();
        long visibleColumns = columns.stream().filter(TableColumnBase::isVisible).count();
        if (visibleColumns != 0L) {
            columns.stream().filter(TableColumnBase::isVisible).forEach(column -> {
                column.prefWidthProperty().unbind();
                column.prefWidthProperty().bind(tableWidth.divide(visibleColumns));
            });
        }
    }

    public static void apply(TableView tableView) {
        new AllColumnsEqualWidthListener(tableView).rebindColumns();
    }
}

