/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.util.exception;

import com.sun.istack.localization.Localizable;
import com.sun.istack.localization.LocalizableMessage;
import com.sun.istack.localization.LocalizableMessageFactory;
import com.sun.istack.localization.Localizer;
import com.sun.istack.localization.NullLocalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.ws.WebServiceException;

public abstract class JAXWSExceptionBase
extends WebServiceException
implements Localizable,
LocalizableMessageFactory.ResourceBundleSupplier {
    private static final long serialVersionUID = 1L;
    private transient Localizable msg;

    @Deprecated
    protected JAXWSExceptionBase(String key, Object ... args2) {
        super(JAXWSExceptionBase.findNestedException(args2));
        this.msg = new LocalizableMessage(this.getDefaultResourceBundleName(), this, key, args2);
    }

    protected JAXWSExceptionBase(String message) {
        this(new NullLocalizable(message));
    }

    protected JAXWSExceptionBase(Throwable throwable) {
        this(new NullLocalizable(throwable.toString()), throwable);
    }

    protected JAXWSExceptionBase(Localizable msg) {
        this.msg = msg;
    }

    protected JAXWSExceptionBase(Localizable msg, Throwable cause) {
        super(cause);
        this.msg = msg;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.msg.getResourceBundleName());
        out.writeObject(this.msg.getKey());
        Object[] args2 = this.msg.getArguments();
        if (args2 == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(args2.length);
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i] == null || args2[i] instanceof Serializable) {
                out.writeObject(args2[i]);
                continue;
            }
            out.writeObject(args2[i].toString());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object[] args2;
        in.defaultReadObject();
        String resourceBundleName = (String)in.readObject();
        String key = (String)in.readObject();
        int len = in.readInt();
        if (len == -1) {
            args2 = null;
        } else {
            args2 = new Object[len];
            for (int i = 0; i < args2.length; ++i) {
                args2[i] = in.readObject();
            }
        }
        this.msg = new LocalizableMessageFactory(resourceBundleName).getMessage(key, args2);
    }

    private static Throwable findNestedException(Object[] args2) {
        if (args2 == null) {
            return null;
        }
        for (Object o : args2) {
            if (!(o instanceof Throwable)) continue;
            return (Throwable)o;
        }
        return null;
    }

    @Override
    public String getMessage() {
        Localizer localizer = new Localizer();
        return localizer.localize(this);
    }

    protected abstract String getDefaultResourceBundleName();

    @Override
    public final String getKey() {
        return this.msg.getKey();
    }

    @Override
    public final Object[] getArguments() {
        return this.msg.getArguments();
    }

    @Override
    public final String getResourceBundleName() {
        return this.msg.getResourceBundleName();
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle(this.getDefaultResourceBundleName(), locale);
    }
}

