/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.apache.commons.beanutils.MethodUtils;

public class ConstructorUtils {
    private static final Class<?>[] EMPTY_CLASS_PARAMETERS = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static <T> Constructor<T> getAccessibleConstructor(Class<T> klass, Class<?> parameterType) {
        Class[] parameterTypes = new Class[]{parameterType};
        return ConstructorUtils.getAccessibleConstructor(klass, parameterTypes);
    }

    public static <T> Constructor<T> getAccessibleConstructor(Class<T> klass, Class<?>[] parameterTypes) {
        try {
            return ConstructorUtils.getAccessibleConstructor(klass.getConstructor(parameterTypes));
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static <T> Constructor<T> getAccessibleConstructor(Constructor<T> ctor) {
        if (ctor == null || !Modifier.isPublic(ctor.getModifiers())) {
            return null;
        }
        Class<T> clazz = ctor.getDeclaringClass();
        if (Modifier.isPublic(clazz.getModifiers())) {
            return ctor;
        }
        return null;
    }

    private static <T> Constructor<T> getMatchingAccessibleConstructor(Class<T> clazz, Class<?>[] parameterTypes) {
        try {
            Constructor<T> ctor = clazz.getConstructor(parameterTypes);
            try {
                ctor.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return ctor;
        }
        catch (NoSuchMethodException ctor) {
            Constructor<?>[] ctors;
            int paramSize = parameterTypes.length;
            for (Constructor<?> ctor2 : ctors = clazz.getConstructors()) {
                Constructor<?> ctor3;
                Class<?>[] ctorParams = ctor2.getParameterTypes();
                int ctorParamSize = ctorParams.length;
                if (ctorParamSize != paramSize) continue;
                boolean match = true;
                for (int n = 0; n < ctorParamSize; ++n) {
                    if (MethodUtils.isAssignmentCompatible(ctorParams[n], parameterTypes[n])) continue;
                    match = false;
                    break;
                }
                if (!match || (ctor3 = ConstructorUtils.getAccessibleConstructor(ctor2)) == null) continue;
                try {
                    ctor3.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                Constructor<?> typedCtor = ctor3;
                return typedCtor;
            }
            return null;
        }
    }

    public static <T> T invokeConstructor(Class<T> klass, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] args2 = ConstructorUtils.toArray(arg);
        return ConstructorUtils.invokeConstructor(klass, args2);
    }

    public static <T> T invokeConstructor(Class<T> klass, Object[] args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (null == args2) {
            args2 = EMPTY_OBJECT_ARRAY;
        }
        int arguments = args2.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args2[i].getClass();
        }
        return ConstructorUtils.invokeConstructor(klass, args2, parameterTypes);
    }

    public static <T> T invokeConstructor(Class<T> klass, Object[] args2, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> ctor;
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if (args2 == null) {
            args2 = EMPTY_OBJECT_ARRAY;
        }
        if (null == (ctor = ConstructorUtils.getMatchingAccessibleConstructor(klass, parameterTypes))) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + klass.getName());
        }
        return ctor.newInstance(args2);
    }

    public static <T> T invokeExactConstructor(Class<T> klass, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object[] args2 = ConstructorUtils.toArray(arg);
        return ConstructorUtils.invokeExactConstructor(klass, args2);
    }

    public static <T> T invokeExactConstructor(Class<T> klass, Object[] args2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (null == args2) {
            args2 = EMPTY_OBJECT_ARRAY;
        }
        int arguments = args2.length;
        Class[] parameterTypes = new Class[arguments];
        for (int i = 0; i < arguments; ++i) {
            parameterTypes[i] = args2[i].getClass();
        }
        return ConstructorUtils.invokeExactConstructor(klass, args2, parameterTypes);
    }

    public static <T> T invokeExactConstructor(Class<T> klass, Object[] args2, Class<?>[] parameterTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> ctor;
        if (args2 == null) {
            args2 = EMPTY_OBJECT_ARRAY;
        }
        if (parameterTypes == null) {
            parameterTypes = EMPTY_CLASS_PARAMETERS;
        }
        if (null == (ctor = ConstructorUtils.getAccessibleConstructor(klass, parameterTypes))) {
            throw new NoSuchMethodException("No such accessible constructor on object: " + klass.getName());
        }
        return ctor.newInstance(args2);
    }

    private static Object[] toArray(Object arg) {
        Object[] args2 = null;
        if (arg != null) {
            args2 = new Object[]{arg};
        }
        return args2;
    }

    @Deprecated
    public ConstructorUtils() {
    }
}

