/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableBooleanBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableBooleanEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableBooleanHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableBooleanSingletonBag;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.factory.primitive.BooleanBags;

@ServiceProvider(value=ImmutableBooleanBagFactory.class)
public class ImmutableBooleanBagFactoryImpl
implements ImmutableBooleanBagFactory {
    public static final ImmutableBooleanBagFactory INSTANCE = new ImmutableBooleanBagFactoryImpl();

    @Override
    public ImmutableBooleanBag empty() {
        return ImmutableBooleanEmptyBag.INSTANCE;
    }

    @Override
    public ImmutableBooleanBag of() {
        return this.empty();
    }

    @Override
    public ImmutableBooleanBag with() {
        return this.empty();
    }

    @Override
    public ImmutableBooleanBag of(boolean one) {
        return this.with(one);
    }

    @Override
    public ImmutableBooleanBag with(boolean one) {
        return new ImmutableBooleanSingletonBag(one);
    }

    @Override
    public ImmutableBooleanBag of(boolean ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableBooleanBag with(boolean ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableBooleanHashBag.newBagWith(items);
    }

    @Override
    public ImmutableBooleanBag ofAll(BooleanIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableBooleanBag withAll(BooleanIterable items) {
        if (items instanceof ImmutableBooleanBag) {
            return (ImmutableBooleanBag)items;
        }
        if (items == null) {
            return this.with();
        }
        BooleanHashBag bag = new BooleanHashBag();
        items.forEach(bag::add);
        if (bag.size() == 0) {
            return this.with();
        }
        if (bag.size() == 1) {
            return this.with(bag.toArray());
        }
        return ImmutableBooleanHashBag.newBagWith(bag);
    }

    @Override
    public ImmutableBooleanBag ofAll(Iterable<Boolean> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableBooleanBag withAll(Iterable<Boolean> iterable) {
        return BooleanBags.mutable.withAll(iterable).toImmutable();
    }
}

