/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.primitive.ShortSets;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.primitive.ImmutableShortSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.set.primitive.ShortSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.set.primitive.AbstractShortSet;

public abstract class AbstractImmutableShortSet
extends AbstractShortSet
implements ImmutableShortSet {
    @Override
    public ImmutableShortSet newWith(short element) {
        return ShortHashSet.newSet(this).with(element).toImmutable();
    }

    @Override
    public ImmutableShortSet newWithout(short element) {
        return ShortHashSet.newSet(this).without(element).toImmutable();
    }

    @Override
    public ImmutableShortSet newWithAll(ShortIterable elements) {
        return ShortHashSet.newSet(this).withAll(elements).toImmutable();
    }

    @Override
    public ImmutableShortSet newWithoutAll(ShortIterable elements) {
        return ShortHashSet.newSet(this).withoutAll(elements).toImmutable();
    }

    @Override
    public ShortSet freeze() {
        return this;
    }

    @Override
    public ImmutableShortSet toImmutable() {
        return this;
    }

    @Override
    public RichIterable<ShortIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        MutableList result = Lists.mutable.empty();
        if (this.notEmpty()) {
            if (this.size() <= size) {
                result.add(this);
            } else {
                ShortIterator iterator2 = this.shortIterator();
                while (iterator2.hasNext()) {
                    MutableShortSet batch = ShortSets.mutable.empty();
                    for (int i = 0; i < size && iterator2.hasNext(); ++i) {
                        batch.add(iterator2.next());
                    }
                    result.add(batch.toImmutable());
                }
            }
        }
        return result.toImmutable();
    }
}

