/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.util.stream.Stream;
import org.eclipse.collections.api.factory.stack.MutableStackFactory;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;

@ServiceProvider(value=MutableStackFactory.class)
public class MutableStackFactoryImpl
implements MutableStackFactory {
    public static final MutableStackFactory INSTANCE = new MutableStackFactoryImpl();

    @Override
    public <T> MutableStack<T> empty() {
        return ArrayStack.newStack();
    }

    @Override
    public <T> MutableStack<T> with(T ... elements) {
        return ArrayStack.newStackWith(elements);
    }

    @Override
    public <T> MutableStack<T> withAll(Iterable<? extends T> elements) {
        return ArrayStack.newStack(elements);
    }

    @Override
    public <T> MutableStack<T> fromStream(Stream<? extends T> stream) {
        ArrayStack stack = ArrayStack.newStack();
        stream.forEach(stack::push);
        return stack;
    }

    @Override
    public <T> MutableStack<T> withReversed(T ... elements) {
        return ArrayStack.newStackFromTopToBottom(elements);
    }

    @Override
    public <T> MutableStack<T> withAllReversed(Iterable<? extends T> items) {
        return ArrayStack.newStackFromTopToBottom(items);
    }
}

