/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.DB;
import org.mapdb.DBException;
import org.mapdb.DBMaker;
import org.mapdb.DataIO;
import org.mapdb.Store;
import org.mapdb.StoreDirect;
import org.mapdb.StoreDirectAbstract;
import org.mapdb.StoreOnHeap;
import org.mapdb.StoreReadOnlyWrapper;
import org.mapdb.StoreWAL;
import org.mapdb.volume.ByteArrayVol;
import org.mapdb.volume.ByteBufferMemoryVol;
import org.mapdb.volume.FileChannelVol;
import org.mapdb.volume.MappedFileVol;
import org.mapdb.volume.RandomAccessFileVol;
import org.mapdb.volume.ReadOnlyVolumeFactory;
import org.mapdb.volume.Volume;
import org.mapdb.volume.VolumeFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0004H\u0007J\u0018\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0014\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\u000f\u001a\u00020\u0004H\u0007J\b\u0010\u0010\u001a\u00020\u0004H\u0007J\u0018\u0010\u0011\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0014\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\u0013\u001a\u00020\u0004H\u0007J\u0018\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007\u00a8\u0006\u001b"}, d2={"Lorg/mapdb/DBMaker;", "", "()V", "fileDB", "Lorg/mapdb/DBMaker$Maker;", "file", "Ljava/io/File;", "", "heapDB", "heapShardedHashMap", "Lorg/mapdb/DB$HashMapMaker;", "concurrency", "", "heapShardedHashSet", "Lorg/mapdb/DB$HashSetMaker;", "memoryDB", "memoryDirectDB", "memoryShardedHashMap", "memoryShardedHashSet", "tempFileDB", "volumeDB", "volume", "Lorg/mapdb/volume/Volume;", "volumeExists", "", "Maker", "StoreType", "mapdb"})
public final class DBMaker {
    @NotNull
    public static final DBMaker INSTANCE = new DBMaker();

    private DBMaker() {
    }

    @JvmStatic
    @NotNull
    public static final Maker tempFileDB() {
        File file = File.createTempFile("mapdb", "temp");
        file.delete();
        file.deleteOnExit();
        Intrinsics.checkNotNull(file);
        return DBMaker.fileDB(file).deleteFilesAfterClose();
    }

    @JvmStatic
    @NotNull
    public static final Maker fileDB(@NotNull String file) {
        Intrinsics.checkNotNullParameter(file, "file");
        return new Maker(StoreType.fileRaf, null, null, file, 6, null);
    }

    @JvmStatic
    @NotNull
    public static final Maker fileDB(@NotNull File file) {
        Intrinsics.checkNotNullParameter(file, "file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "getPath(...)");
        return DBMaker.fileDB(string);
    }

    @JvmStatic
    @NotNull
    public static final Maker heapDB() {
        return new Maker(StoreType.onheap, null, null, null, 14, null);
    }

    @JvmStatic
    @NotNull
    public static final Maker memoryDB() {
        return new Maker(StoreType.bytearray, null, null, null, 14, null);
    }

    @JvmStatic
    @NotNull
    public static final Maker memoryDirectDB() {
        return new Maker(StoreType.directbuffer, null, null, null, 14, null);
    }

    @JvmStatic
    @NotNull
    public static final Maker volumeDB(@NotNull Volume volume, boolean volumeExists) {
        Intrinsics.checkNotNullParameter(volume, "volume");
        return new Maker(null, volume, volumeExists, null, 8, null);
    }

    @JvmStatic
    @NotNull
    public static final DB.HashSetMaker<?> memoryShardedHashSet(int concurrency) {
        DB db = new DB(new StoreOnHeap(false, 1, null), false, true, null, 0, 24, null);
        return new DB.HashSetMaker(db, "map", memoryShardedHashSet.1.INSTANCE).layout(concurrency, 128, 4);
    }

    @JvmStatic
    @NotNull
    public static final DB.HashSetMaker<?> heapShardedHashSet(int concurrency) {
        DB db = new DB(new StoreOnHeap(false, 1, null), false, true, null, 0, 24, null);
        return new DB.HashSetMaker(db, "map", heapShardedHashSet.1.INSTANCE).layout(concurrency, 128, 4);
    }

    @JvmStatic
    @NotNull
    public static final DB.HashMapMaker<?, ?> memoryShardedHashMap(int concurrency) {
        DB db = new DB(new StoreOnHeap(false, 1, null), false, true, null, 0, 24, null);
        return new DB.HashMapMaker(db, "map", false, memoryShardedHashMap.1.INSTANCE, 4, null).layout(concurrency, 128, 4);
    }

    @JvmStatic
    @NotNull
    public static final DB.HashMapMaker<?, ?> heapShardedHashMap(int concurrency) {
        DB db = new DB(new StoreOnHeap(false, 1, null), false, true, null, 0, 24, null);
        return new DB.HashMapMaker(db, "map", false, heapShardedHashMap.1.INSTANCE, 4, null).layout(concurrency, 128, 4);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\fJ\b\u0010\"\u001a\u00020#H\u0004J\u0006\u0010$\u001a\u00020\u0000J\u0006\u0010%\u001a\u00020\u0000J\u0006\u0010&\u001a\u00020\u0000J\u0006\u0010'\u001a\u00020\u0000J\u0006\u0010(\u001a\u00020\u0000J\u0006\u0010)\u001a\u00020\u0000J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0012J\b\u0010,\u001a\u00020\u0000H\u0007J\u0006\u0010-\u001a\u00020\u0000J\u0006\u0010.\u001a\u00020\u0000J\u0006\u0010/\u001a\u00020\u0000J\u0006\u00100\u001a\u00020\u0000J\u0006\u00101\u001a\u00020\u0000J\u0006\u00102\u001a\u00020\u0000J\u000e\u00102\u001a\u00020\u00002\u0006\u00103\u001a\u00020\fJ\u0006\u00104\u001a\u00020\u0000J\u0006\u00105\u001a\u00020\u0000J\u0006\u00106\u001a\u00020\u0000J\u0006\u00107\u001a\u00020\u0000J\u0006\u00108\u001a\u000209J\u0006\u0010:\u001a\u00020\u0000J\u0006\u0010;\u001a\u00020\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001dR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/mapdb/DBMaker$Maker;", "", "_storeType", "Lorg/mapdb/DBMaker$StoreType;", "_customVolume", "Lorg/mapdb/volume/Volume;", "_volumeExist", "", "file", "", "(Lorg/mapdb/DBMaker$StoreType;Lorg/mapdb/volume/Volume;Ljava/lang/Boolean;Ljava/lang/String;)V", "_allocateIncrement", "", "_allocateStartSize", "_checksumHeaderBypass", "_checksumStoreEnable", "_cleanerHack", "_closeOnJvmShutdown", "", "_concurrencyScale", "_fileDeleteAfterClose", "_fileDeleteAfterOpen", "_fileLockWait", "_fileMmapPreclearDisable", "_fileMmapfIfSupported", "_fileSyncDisable", "_isThreadSafe", "_readOnly", "_transactionEnable", "Ljava/lang/Boolean;", "allocateIncrement", "incrementSize", "allocateStartSize", "size", "assertFile", "", "checksumHeaderBypass", "checksumStoreEnable", "cleanerHackEnable", "closeOnJvmShutdown", "closeOnJvmShutdownWeakReference", "concurrencyDisable", "concurrencyScale", "segmentCount", "deleteFilesAfterClose", "executorEnable", "fileChannelEnable", "fileDeleteAfterClose", "fileDeleteAfterOpen", "fileLockDisable", "fileLockWait", "timeout", "fileMmapEnable", "fileMmapEnableIfSupported", "fileMmapPreclearDisable", "fileSyncDisable", "make", "Lorg/mapdb/DB;", "readOnly", "transactionEnable", "mapdb"})
    public static final class Maker {
        @Nullable
        private StoreType _storeType;
        @Nullable
        private final Volume _customVolume;
        @Nullable
        private final Boolean _volumeExist;
        @Nullable
        private final String file;
        private long _allocateStartSize;
        private long _allocateIncrement;
        private boolean _transactionEnable;
        private boolean _fileDeleteAfterClose;
        private boolean _fileDeleteAfterOpen;
        private boolean _isThreadSafe;
        private int _concurrencyScale;
        private boolean _cleanerHack;
        private boolean _fileMmapPreclearDisable;
        private long _fileLockWait;
        private boolean _fileMmapfIfSupported;
        private int _closeOnJvmShutdown;
        private boolean _readOnly;
        private boolean _checksumStoreEnable;
        private boolean _checksumHeaderBypass;
        private boolean _fileSyncDisable;

        public Maker(@Nullable StoreType _storeType, @Nullable Volume _customVolume, @Nullable Boolean _volumeExist, @Nullable String file) {
            this._storeType = _storeType;
            this._customVolume = _customVolume;
            this._volumeExist = _volumeExist;
            this.file = file;
            this._isThreadSafe = true;
            this._concurrencyScale = 8;
        }

        public /* synthetic */ Maker(StoreType storeType, Volume volume, Boolean bl, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                volume = null;
            }
            if ((n & 4) != 0) {
                bl = null;
            }
            if ((n & 8) != 0) {
                string = null;
            }
            this(storeType, volume, bl, string);
        }

        @NotNull
        public final Maker transactionEnable() {
            this._transactionEnable = true;
            return this;
        }

        @NotNull
        public final Maker allocateStartSize(long size) {
            this._allocateStartSize = size;
            return this;
        }

        @NotNull
        public final Maker allocateIncrement(long incrementSize) {
            this._allocateIncrement = incrementSize;
            return this;
        }

        @Deprecated(message="method renamed to `fileDeleteAfterClose()`")
        @NotNull
        public final Maker deleteFilesAfterClose() {
            this._fileDeleteAfterClose = true;
            return this;
        }

        @NotNull
        public final Maker fileDeleteAfterClose() {
            this._fileDeleteAfterClose = true;
            return this;
        }

        @NotNull
        public final Maker fileDeleteAfterOpen() {
            this._fileDeleteAfterOpen = true;
            return this;
        }

        @NotNull
        public final Maker fileSyncDisable() {
            this._fileSyncDisable = true;
            return this;
        }

        @NotNull
        public final Maker executorEnable() {
            return this;
        }

        @NotNull
        public final Maker concurrencyDisable() {
            this._isThreadSafe = false;
            return this;
        }

        @NotNull
        public final Maker concurrencyScale(int segmentCount) {
            this._concurrencyScale = segmentCount;
            return this;
        }

        protected final void assertFile() {
            StoreType[] storeTypeArray = new StoreType[]{StoreType.fileRaf, StoreType.fileMMap, StoreType.fileChannel};
            if (!ArraysKt.contains(storeTypeArray, this._storeType)) {
                throw new DBException.WrongConfiguration("File related options are not allowed for in-memory store");
            }
        }

        @NotNull
        public final Maker fileMmapEnable() {
            this.assertFile();
            this._storeType = StoreType.fileMMap;
            return this;
        }

        @NotNull
        public final Maker cleanerHackEnable() {
            this._cleanerHack = true;
            return this;
        }

        @NotNull
        public final Maker fileMmapPreclearDisable() {
            this._fileMmapPreclearDisable = true;
            return this;
        }

        @NotNull
        public final Maker fileLockDisable() {
            this.assertFile();
            this._fileLockWait = -1L;
            return this;
        }

        @NotNull
        public final Maker fileLockWait(long timeout) {
            this.assertFile();
            this._fileLockWait = timeout;
            return this;
        }

        @NotNull
        public final Maker fileLockWait() {
            return this.fileLockWait(Long.MAX_VALUE);
        }

        @NotNull
        public final Maker checksumStoreEnable() {
            this._checksumStoreEnable = true;
            return this;
        }

        @NotNull
        public final Maker checksumHeaderBypass() {
            this._checksumHeaderBypass = true;
            return this;
        }

        @NotNull
        public final Maker fileMmapEnableIfSupported() {
            this.assertFile();
            this._fileMmapfIfSupported = true;
            return this;
        }

        @NotNull
        public final Maker fileChannelEnable() {
            this.assertFile();
            this._storeType = StoreType.fileChannel;
            return this;
        }

        @NotNull
        public final Maker closeOnJvmShutdown() {
            this._closeOnJvmShutdown = 1;
            return this;
        }

        @NotNull
        public final Maker closeOnJvmShutdownWeakReference() {
            this._closeOnJvmShutdown = 2;
            return this;
        }

        @NotNull
        public final Maker readOnly() {
            this._readOnly = true;
            return this;
        }

        @NotNull
        public final DB make() {
            Store store;
            VolumeFactory volumeFactory;
            boolean storeOpened = false;
            int concShift = DataIO.shift(DataIO.nextPowTwo(this._concurrencyScale));
            StoreType storeType2 = this._storeType;
            if (this._fileMmapfIfSupported && DataIO.JVMSupportsLargeMappedFiles()) {
                storeType2 = StoreType.fileMMap;
            }
            StoreType storeType = storeType2;
            switch (storeType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[storeType.ordinal()]) {
                case 1: {
                    volumeFactory = null;
                    break;
                }
                case 2: {
                    volumeFactory = ByteArrayVol.FACTORY;
                    break;
                }
                case 3: {
                    if (this._cleanerHack) {
                        volumeFactory = ByteBufferMemoryVol.FACTORY_WITH_CLEANER_HACK;
                        break;
                    }
                    volumeFactory = ByteBufferMemoryVol.FACTORY;
                    break;
                }
                case 4: {
                    volumeFactory = RandomAccessFileVol.FACTORY;
                    break;
                }
                case 5: {
                    volumeFactory = FileChannelVol.FACTORY;
                    break;
                }
                case 6: {
                    volumeFactory = new MappedFileVol.MappedFileFactory(this._cleanerHack, this._fileMmapPreclearDisable);
                    break;
                }
                case -1: {
                    Volume volume = this._customVolume;
                    Intrinsics.checkNotNull(volume);
                    Boolean bl = this._volumeExist;
                    Intrinsics.checkNotNull(bl);
                    volumeFactory = VolumeFactory.wrap(volume, bl);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            VolumeFactory volfab = volumeFactory;
            if (this._readOnly && volfab != null && !volfab.handlesReadonly()) {
                volfab = new ReadOnlyVolumeFactory(volfab);
            }
            if (this._storeType == StoreType.onheap) {
                store = this._readOnly ? (Store)new StoreReadOnlyWrapper(new StoreOnHeap(false, 1, null)) : (Store)new StoreOnHeap(false, 1, null);
            } else {
                StoreDirectAbstract storeDir;
                StoreDirectAbstract storeDirectAbstract;
                boolean bl;
                boolean bl2;
                boolean bl3;
                boolean bl4;
                boolean bl5;
                long l;
                long l2;
                long l3;
                VolumeFactory volumeFactory2;
                String string;
                Object object;
                VolumeFactory volumeFactory3 = volfab;
                Intrinsics.checkNotNull(volumeFactory3);
                storeOpened = volumeFactory3.exists(this.file);
                if (!this._transactionEnable || this._readOnly) {
                    object = StoreDirect.Companion;
                    string = this.file;
                    volumeFactory2 = volfab;
                    l3 = this._fileLockWait;
                    l2 = this._allocateIncrement;
                    l = this._allocateStartSize;
                    bl5 = this._readOnly;
                    bl4 = this._fileDeleteAfterClose;
                    bl3 = this._fileDeleteAfterOpen;
                    bl2 = this._checksumStoreEnable;
                    bl = this._isThreadSafe;
                    boolean bl6 = this._checksumHeaderBypass;
                    storeDirectAbstract = StoreDirect.Companion.make$default((StoreDirect.Companion)object, string, volumeFactory2, l3, bl5, bl, concShift, l2, l, bl4, bl3, bl2, false, bl6, 2048, null);
                } else {
                    if (this._checksumStoreEnable) {
                        throw new DBException.WrongConfiguration("Checksum is not supported with transaction enabled.");
                    }
                    object = StoreWAL.Companion;
                    string = this.file;
                    volumeFactory2 = volfab;
                    l3 = this._fileLockWait;
                    l2 = this._allocateIncrement;
                    l = this._allocateStartSize;
                    bl5 = this._fileDeleteAfterClose;
                    bl4 = this._fileDeleteAfterOpen;
                    bl3 = this._checksumStoreEnable;
                    bl2 = this._isThreadSafe;
                    bl = this._checksumHeaderBypass;
                    storeDirectAbstract = storeDir = (StoreDirectAbstract)StoreWAL.Companion.make$default((StoreWAL.Companion)object, string, volumeFactory2, l3, bl2, concShift, l2, l, bl5, bl4, bl3, false, bl, 1024, null);
                }
                if (this._fileSyncDisable) {
                    storeDir.setFileSyncDisable$mapdb(true);
                }
                store = storeDir;
            }
            Store store2 = store;
            return new DB(store2, storeOpened, this._isThreadSafe, null, this._closeOnJvmShutdown, 8, null);
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[StoreType.values().length];
                try {
                    nArray[StoreType.onheap.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StoreType.bytearray.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StoreType.directbuffer.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StoreType.fileRaf.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StoreType.fileChannel.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StoreType.fileMMap.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/mapdb/DBMaker$StoreType;", "", "(Ljava/lang/String;I)V", "onheap", "directbuffer", "bytearray", "fileRaf", "fileMMap", "fileChannel", "mapdb"})
    public static final class StoreType
    extends Enum<StoreType> {
        public static final /* enum */ StoreType onheap = new StoreType();
        public static final /* enum */ StoreType directbuffer = new StoreType();
        public static final /* enum */ StoreType bytearray = new StoreType();
        public static final /* enum */ StoreType fileRaf = new StoreType();
        public static final /* enum */ StoreType fileMMap = new StoreType();
        public static final /* enum */ StoreType fileChannel = new StoreType();
        private static final /* synthetic */ StoreType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static StoreType[] values() {
            return (StoreType[])$VALUES.clone();
        }

        public static StoreType valueOf(String value) {
            return Enum.valueOf(StoreType.class, value);
        }

        @NotNull
        public static EnumEntries<StoreType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = storeTypeArray = new StoreType[]{StoreType.onheap, StoreType.directbuffer, StoreType.bytearray, StoreType.fileRaf, StoreType.fileMMap, StoreType.fileChannel};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

