/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.LongIterator;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.ArrayIteratorsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongProgression;
import kotlin.ranges.RangesKt;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.LongLongHashMap;
import org.eclipse.collections.impl.map.mutable.primitive.LongObjectHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CC;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Serializer;
import org.mapdb.StoreDirectAbstract;
import org.mapdb.StoreDirectJava;
import org.mapdb.StoreTx;
import org.mapdb.Utils;
import org.mapdb.WriteAheadLog;
import org.mapdb.volume.ReadOnlyVolume;
import org.mapdb.volume.SingleByteArrayVol;
import org.mapdb.volume.Volume;
import org.mapdb.volume.VolumeFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 z2\u00020\u00012\u00020\u0002:\u0001zBg\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\b\u0012\u0006\u0010\u000f\u001a\u00020\n\u0012\u0006\u0010\u0010\u001a\u00020\n\u0012\u0006\u0010\u0011\u001a\u00020\n\u0012\u0006\u0010\u0012\u001a\u00020\n\u0012\u0006\u0010\u0013\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0014J\b\u0010B\u001a\u00020\bH\u0014J\b\u0010C\u001a\u00020\bH\u0014J\b\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020EH\u0016J\b\u0010G\u001a\u00020EH\u0016J=\u0010H\u001a\u00020\n\"\u0004\b\u0000\u0010I2\u0006\u0010J\u001a\u00020\b2\b\u0010K\u001a\u0004\u0018\u0001HI2\b\u0010L\u001a\u0004\u0018\u0001HI2\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HI0NH\u0016\u00a2\u0006\u0002\u0010OJ$\u0010P\u001a\u00020E\"\u0004\b\u0000\u0010I2\u0006\u0010J\u001a\u00020\b2\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HI0NH\u0016J\b\u0010Q\u001a\u00020\nH\u0016J\u0010\u0010R\u001a\u00020E2\u0006\u0010S\u001a\u00020\bH\u0014J+\u0010T\u001a\u0004\u0018\u0001HI\"\u0004\b\u0000\u0010I2\u0006\u0010J\u001a\u00020\b2\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HI0NH\u0016\u00a2\u0006\u0002\u0010UJ\u000e\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00040WH\u0016J\b\u0010X\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u00020\b2\u0006\u0010J\u001a\u00020\bH\u0014J\u0018\u0010[\u001a\u00020E2\u0006\u0010\\\u001a\u00020\b2\u0006\u0010J\u001a\u00020\bH\u0004J\u0018\u0010]\u001a\u00020&2\u0006\u0010\\\u001a\u00020\b2\u0006\u0010J\u001a\u00020\bH\u0004J \u0010^\u001a\u00020\b2\u0006\u0010_\u001a\u00020&2\u0006\u0010`\u001a\u00020\f2\u0006\u0010J\u001a\u00020\bH\u0004J\u0018\u0010a\u001a\u00020\b2\u0006\u0010b\u001a\u00020\b2\u0006\u0010c\u001a\u00020\bH\u0004J\u0010\u0010d\u001a\u00020&2\u0006\u0010e\u001a\u00020\bH\u0002J0\u0010f\u001a\u00020E2\u0006\u0010g\u001a\u00020\b2\u0006\u0010h\u001a\u00020\b2\u0006\u0010i\u001a\u00020\b2\u0006\u0010j\u001a\u00020\b2\u0006\u0010k\u001a\u00020\nH\u0004J \u0010l\u001a\u00020E2\u0006\u0010g\u001a\u00020\b2\u0006\u0010i\u001a\u00020\b2\u0006\u0010k\u001a\u00020\nH\u0014J\u0018\u0010m\u001a\u00020\b2\u0006\u0010g\u001a\u00020\b2\u0006\u0010k\u001a\u00020\nH\u0014J\b\u0010n\u001a\u00020\bH\u0016J+\u0010o\u001a\u00020\b\"\u0004\b\u0000\u0010I2\b\u0010p\u001a\u0004\u0018\u0001HI2\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HI0NH\u0016\u00a2\u0006\u0002\u0010qJ\b\u0010r\u001a\u00020EH\u0016J\u0018\u0010s\u001a\u00020E2\u0006\u0010J\u001a\u00020\b2\u0006\u0010i\u001a\u00020\bH\u0014J3\u0010t\u001a\u00020E\"\u0004\b\u0000\u0010I2\u0006\u0010J\u001a\u00020\b2\b\u0010p\u001a\u0004\u0018\u0001HI2\f\u0010M\u001a\b\u0012\u0004\u0012\u0002HI0NH\u0016\u00a2\u0006\u0002\u0010uJ\u001a\u0010v\u001a\u00020E2\u0006\u0010J\u001a\u00020\b2\b\u0010w\u001a\u0004\u0018\u00010xH\u0002J\b\u0010y\u001a\u00020EH\u0016R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b\u001f\u0010 R\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001eX\u0084\u0004\u00a2\u0006\n\n\u0002\u0010!\u001a\u0004\b#\u0010 R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020&X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020-X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001a\u00100\u001a\u000201X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0014\u00106\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u000209X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u000209X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010;R\u0014\u0010>\u001a\u00020?X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010A\u00a8\u0006{"}, d2={"Lorg/mapdb/StoreWAL;", "Lorg/mapdb/StoreDirectAbstract;", "Lorg/mapdb/StoreTx;", "file", "", "volumeFactory", "Lorg/mapdb/volume/VolumeFactory;", "fileLockWait", "", "isThreadSafe", "", "concShift", "", "allocateIncrement", "allocateStartSize", "fileDeleteAfterClose", "fileDeleteAfterOpen", "checksum", "checksumHeader", "checksumHeaderBypass", "(Ljava/lang/String;Lorg/mapdb/volume/VolumeFactory;JZIJJZZZZZ)V", "allocatedPages", "Lorg/eclipse/collections/impl/list/mutable/primitive/LongArrayList;", "getAllocatedPages", "()Lorg/eclipse/collections/impl/list/mutable/primitive/LongArrayList;", "cacheIndexLinks", "Lorg/eclipse/collections/impl/map/mutable/primitive/LongLongHashMap;", "getCacheIndexLinks", "()Lorg/eclipse/collections/impl/map/mutable/primitive/LongLongHashMap;", "cacheIndexVals", "", "getCacheIndexVals", "()[Lorg/eclipse/collections/impl/map/mutable/primitive/LongLongHashMap;", "[Lorg/eclipse/collections/impl/map/mutable/primitive/LongLongHashMap;", "cacheRecords", "getCacheRecords", "cacheStacks", "Lorg/eclipse/collections/impl/map/mutable/primitive/LongObjectHashMap;", "", "getCacheStacks", "()Lorg/eclipse/collections/impl/map/mutable/primitive/LongObjectHashMap;", "headBytes", "getHeadBytes", "()[B", "headVol", "Lorg/mapdb/volume/SingleByteArrayVol;", "getHeadVol", "()Lorg/mapdb/volume/SingleByteArrayVol;", "indexPagesBackup", "", "getIndexPagesBackup", "()[J", "setIndexPagesBackup", "([J)V", "isReadOnly", "()Z", "realVolume", "Lorg/mapdb/volume/Volume;", "getRealVolume", "()Lorg/mapdb/volume/Volume;", "volume", "getVolume", "wal", "Lorg/mapdb/WriteAheadLog;", "getWal", "()Lorg/mapdb/WriteAheadLog;", "allocateNewIndexPage", "allocateNewPage", "close", "", "commit", "compact", "compareAndSwap", "R", "recid", "expectedOldRecord", "newRecord", "serializer", "Lorg/mapdb/Serializer;", "(JLjava/lang/Object;Ljava/lang/Object;Lorg/mapdb/Serializer;)Z", "delete", "fileLoad", "freeSizeIncrement", "increment", "get", "(JLorg/mapdb/Serializer;)Ljava/lang/Object;", "getAllFiles", "", "getAllRecids", "Lkotlin/collections/LongIterator;", "getIndexVal", "linkedRecordDelete", "indexValue", "linkedRecordGet", "linkedRecordPut", "output", "size", "longStackFindEnd", "pageOffset", "pos", "longStackLoadChunk", "chunkOffset", "longStackNewChunk", "masterLinkOffset", "prevPageOffset", "value", "valueSize", "recursive", "longStackPut", "longStackTake", "preallocate", "put", "record", "(Ljava/lang/Object;Lorg/mapdb/Serializer;)J", "rollback", "setIndexVal", "update", "(JLjava/lang/Object;Lorg/mapdb/Serializer;)V", "updateProtected", "di", "Lorg/mapdb/DataOutput2;", "verify", "Companion", "mapdb"})
@SourceDebugExtension(value={"SMAP\nStoreWAL.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoreWAL.kt\norg/mapdb/StoreWAL\n+ 2 Utils.kt\norg/mapdb/Utils\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,932:1\n124#2,5:933\n88#2,7:938\n88#2,4:945\n124#2,5:949\n93#2,2:954\n124#2,5:956\n88#2,7:961\n124#2,5:968\n124#2,5:973\n124#2,5:978\n88#2,4:983\n124#2,5:987\n93#2,2:992\n88#2,7:994\n124#2,5:1001\n124#2,5:1006\n99#2,7:1011\n13309#3,2:1018\n13309#3,2:1020\n*S KotlinDebug\n*F\n+ 1 StoreWAL.kt\norg/mapdb/StoreWAL\n*L\n120#1:933,5\n187#1:938,7\n211#1:945,4\n218#1:949,5\n211#1:954,2\n239#1:956,5\n242#1:961,7\n343#1:968,5\n359#1:973,5\n383#1:978,5\n388#1:983,4\n403#1:987,5\n388#1:992,2\n426#1:994,7\n448#1:1001,5\n484#1:1006,5\n499#1:1011,7\n579#1:1018,2\n583#1:1020,2\n*E\n"})
public final class StoreWAL
extends StoreDirectAbstract
implements StoreTx {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Volume realVolume;
    @NotNull
    private final Volume volume;
    @NotNull
    private final byte[] headBytes;
    @NotNull
    private final SingleByteArrayVol headVol;
    @NotNull
    private final LongObjectHashMap<byte[]> cacheStacks;
    @NotNull
    private final LongLongHashMap[] cacheIndexVals;
    @NotNull
    private final LongLongHashMap cacheIndexLinks;
    @NotNull
    private final LongLongHashMap[] cacheRecords;
    @NotNull
    private final WriteAheadLog wal;
    @NotNull
    private long[] indexPagesBackup;
    @NotNull
    private final LongArrayList allocatedPages;
    private final boolean isReadOnly;
    private static final long TOMB1 = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoreWAL(@Nullable String file, @NotNull VolumeFactory volumeFactory, long fileLockWait, boolean isThreadSafe, int concShift, long allocateIncrement, long allocateStartSize, boolean fileDeleteAfterClose, boolean fileDeleteAfterOpen, boolean checksum, boolean checksumHeader, boolean checksumHeaderBypass) {
        int n;
        Intrinsics.checkNotNullParameter(volumeFactory, "volumeFactory");
        super(file, volumeFactory, isThreadSafe, concShift, fileDeleteAfterClose, checksum, checksumHeader, checksumHeaderBypass);
        Volume volume = volumeFactory.makeVolume(file, false, fileLockWait, Math.max(20, DataIO.shift((int)allocateIncrement)), DataIO.roundUp(allocateStartSize, 0x100000L), false);
        Intrinsics.checkNotNull(volume);
        this.realVolume = volume;
        this.volume = new ReadOnlyVolume(this.realVolume);
        this.headBytes = new byte[32864];
        this.headVol = new SingleByteArrayVol(this.headBytes);
        this.cacheStacks = new LongObjectHashMap();
        int n2 = 0;
        int n3 = this.getSegmentCount();
        LongLongHashMap[] longLongHashMapArray = new LongLongHashMap[n3];
        StoreWAL storeWAL = this;
        while (n2 < n3) {
            n = n2++;
            longLongHashMapArray[n] = new LongLongHashMap();
        }
        storeWAL.cacheIndexVals = longLongHashMapArray;
        this.cacheIndexLinks = new LongLongHashMap();
        n2 = 0;
        n3 = this.getSegmentCount();
        longLongHashMapArray = new LongLongHashMap[n3];
        storeWAL = this;
        while (n2 < n3) {
            n = n2++;
            longLongHashMapArray[n] = new LongLongHashMap();
        }
        storeWAL.cacheRecords = longLongHashMapArray;
        this.wal = new WriteAheadLog(file, volumeFactory, 0L, fileDeleteAfterOpen);
        this.indexPagesBackup = new long[0];
        this.allocatedPages = new LongArrayList();
        if (checksum) {
            throw new DBException.WrongConfiguration("StoreWAL does not support checksum yet");
        }
        Utils utils = Utils.INSTANCE;
        Lock lock$iv = this.getStructuralLock();
        boolean $i$f$lock = false;
        Lock lock = lock$iv;
        if (lock != null) {
            lock.lock();
        }
        try {
            boolean bl = false;
            if (!this.getVolumeExistsAtStart()) {
                this.realVolume.ensureAvailable(0x100000L);
                this.getHeadVol().putLong(0L, this.fileHeaderCompose());
                this.getHeadVol().putLong(8L, 1L);
                this.setDataTail(0L);
                this.setMaxRecid(0L);
                this.setFileTail$mapdb(0x100000L);
                LongProgression longProgression = RangesKt.step(RangesKt.until(64L, 32864L), 8L);
                long offset = longProgression.getFirst();
                long l = longProgression.getLast();
                long l2 = longProgression.getStep();
                if (l2 > 0L && offset <= l || l2 < 0L && l <= offset) {
                    while (true) {
                        this.getHeadVol().putLong(offset, DataIO.parity4Set(0L));
                        if (offset == l) break;
                        offset += l2;
                    }
                }
                this.getHeadVol().putInt(16L, this.storeHeaderCompose());
                DataIO.putInt(this.headBytes, 20, this.calculateHeaderChecksum());
                this.realVolume.putLong(32864L, DataIO.parity16Set(0L));
                this.realVolume.putData(0L, this.headBytes, 0, this.headBytes.length);
                if (!this.getFileSyncDisable$mapdb()) {
                    this.realVolume.sync();
                }
            } else {
                if (this.getVolume().length() <= 0L) {
                    throw new DBException.DataCorruption("File is empty");
                }
                this.getVolume().getData(0L, this.headBytes, 0, this.headBytes.length);
                this.fileHeaderCheck();
                MutableLongList mutableLongList = this.getIndexPages();
                Intrinsics.checkNotNullExpressionValue(mutableLongList, "<get-indexPages>(...)");
                this.loadIndexPages(mutableLongList);
                long[] lArray = this.getIndexPages().toArray();
                Intrinsics.checkNotNullExpressionValue(lArray, "toArray(...)");
                this.indexPagesBackup = lArray;
            }
            if (file != null && fileDeleteAfterOpen) {
                new File(file).delete();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            Lock lock2 = lock$iv;
            if (lock2 != null) {
                lock2.unlock();
            }
        }
    }

    @NotNull
    protected final Volume getRealVolume() {
        return this.realVolume;
    }

    @Override
    @NotNull
    protected Volume getVolume() {
        return this.volume;
    }

    @NotNull
    protected final byte[] getHeadBytes() {
        return this.headBytes;
    }

    @Override
    @NotNull
    protected SingleByteArrayVol getHeadVol() {
        return this.headVol;
    }

    @NotNull
    protected final LongObjectHashMap<byte[]> getCacheStacks() {
        return this.cacheStacks;
    }

    @NotNull
    protected final LongLongHashMap[] getCacheIndexVals() {
        return this.cacheIndexVals;
    }

    @NotNull
    protected final LongLongHashMap getCacheIndexLinks() {
        return this.cacheIndexLinks;
    }

    @NotNull
    protected final LongLongHashMap[] getCacheRecords() {
        return this.cacheRecords;
    }

    @NotNull
    protected final WriteAheadLog getWal() {
        return this.wal;
    }

    @NotNull
    protected final long[] getIndexPagesBackup() {
        return this.indexPagesBackup;
    }

    protected final void setIndexPagesBackup(@NotNull long[] lArray) {
        Intrinsics.checkNotNullParameter(lArray, "<set-?>");
        this.indexPagesBackup = lArray;
    }

    @NotNull
    protected final LongArrayList getAllocatedPages() {
        return this.allocatedPages;
    }

    @Override
    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    protected long getIndexVal(long recid2) {
        int segment = this.recidToSegment(recid2);
        Utils.INSTANCE.assertReadLock(this.getLocks()[segment]);
        long indexOffset = this.recidToOffset(recid2);
        long ret = this.cacheIndexVals[segment].get(indexOffset);
        if (ret == 0L) {
            ret = this.getVolume().getLong(indexOffset);
        }
        if (ret == 0L) {
            throw new DBException.GetVoid(recid2);
        }
        return DataIO.parity1Get(ret);
    }

    @Override
    protected void setIndexVal(long recid2, long value) {
        int segment = this.recidToSegment(recid2);
        Utils.INSTANCE.assertReadLock(this.getLocks()[segment]);
        long indexOffset = this.recidToOffset(recid2);
        this.cacheIndexVals[segment].put(indexOffset, DataIO.parity1Set(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> boolean compareAndSwap(long recid2, @Nullable R expectedOldRecord, @Nullable R newRecord, @NotNull Serializer<R> serializer) {
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLocks()[this.recidToSegment(recid2)];
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            R old = this.get(recid2, serializer);
            if (old == null && expectedOldRecord != null) {
                boolean bl2 = false;
                return bl2;
            }
            if (old != null && expectedOldRecord == null) {
                boolean bl3 = false;
                return bl3;
            }
            if (old != expectedOldRecord) {
                R r = old;
                Intrinsics.checkNotNull(r);
                R r2 = expectedOldRecord;
                Intrinsics.checkNotNull(r2);
                if (!serializer.equals(r, r2)) {
                    boolean bl4 = false;
                    return bl4;
                }
            }
            DataOutput2 di = this.serialize(newRecord, serializer);
            this.updateProtected(recid2, di);
            boolean bl5 = true;
            return bl5;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> void delete(long recid2, @NotNull Serializer<R> serializer) {
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        this.assertNotClosed();
        int segment = this.recidToSegment(recid2);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLocks()[segment];
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            long oldIndexVal = this.getIndexVal(recid2);
            long oldSize = StoreDirectJava.indexValToSize(oldIndexVal);
            if (oldSize == 65534L) {
                throw new DBException.GetVoid(recid2);
            }
            if (oldSize != 65535L) {
                Utils utils2 = Utils.INSTANCE;
                Lock lock$iv2 = this.getStructuralLock();
                boolean $i$f$lock = false;
                Lock lock = lock$iv2;
                if (lock != null) {
                    lock.lock();
                }
                try {
                    boolean bl2 = false;
                    if (this.indexValFlagLinked(oldIndexVal)) {
                        this.linkedRecordDelete(oldIndexVal, recid2);
                    } else if (oldSize > 5L) {
                        long oldOffset = StoreDirectJava.indexValToOffset(oldIndexVal);
                        long sizeUp = DataIO.roundUp(oldSize, 16L);
                        this.releaseData(sizeUp, oldOffset, false);
                        this.cacheRecords[segment].remove(StoreDirectJava.indexValToOffset(oldIndexVal));
                    }
                    this.releaseRecid(recid2);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    Lock lock2 = lock$iv2;
                    if (lock2 != null) {
                        lock2.unlock();
                    }
                }
            }
            this.setIndexVal(recid2, this.indexValCompose(65534L, 0L, 0, 0, 1));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long preallocate() {
        long l;
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        Object lock$iv = this.getStructuralLock();
        boolean $i$f$lock = false;
        Lock lock = lock$iv;
        if (lock != null) {
            lock.lock();
        }
        try {
            boolean bl = false;
            l = this.allocateRecid();
        }
        finally {
            Lock lock2 = lock$iv;
            if (lock2 != null) {
                lock2.unlock();
            }
        }
        long recid2 = l;
        Utils this_$iv = Utils.INSTANCE;
        lock$iv = this.getLocks()[this.recidToSegment(recid2)];
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            this.setIndexVal(recid2, this.indexValCompose(65535L, 0L, 0, 1, 1));
            long l2 = recid2;
            return l2;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    @NotNull
    protected final byte[] linkedRecordGet(long indexValue, long recid2) {
        if (!this.indexValFlagLinked(indexValue)) {
            throw new AssertionError((Object)"not linked record");
        }
        int segment = this.recidToSegment(recid2);
        LongLongHashMap cacheRec = this.cacheRecords[segment];
        byte[] b = new byte[131072];
        int bpos = 0;
        long pointer = indexValue;
        while (true) {
            long walId;
            boolean isLinked;
            int nextPointerSize = (isLinked = this.indexValFlagLinked(pointer)) ? 8 : 0;
            int size = (int)StoreDirectJava.indexValToSize(pointer) - nextPointerSize;
            long offset = StoreDirectJava.indexValToOffset(pointer);
            if (bpos + size >= b.length) {
                Intrinsics.checkNotNullExpressionValue(Arrays.copyOf(b, b.length * 2), "copyOf(...)");
            }
            if ((walId = cacheRec.get(offset)) != 0L) {
                byte[] ba = this.wal.walGetRecord(walId, recid2);
                System.arraycopy(ba, nextPointerSize, b, bpos, size);
                bpos += size;
                if (!isLinked) break;
                pointer = DataIO.parity3Get(DataIO.getLong(ba, 0));
                continue;
            }
            this.getVolume().getData(offset + (long)nextPointerSize, b, bpos, size);
            bpos += size;
            if (!isLinked) break;
            pointer = DataIO.parity3Get(this.getVolume().getLong(offset));
        }
        byte[] byArray = Arrays.copyOf(b, bpos);
        Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(...)");
        return byArray;
    }

    protected final void linkedRecordDelete(long indexValue, long recid2) {
        if (!this.indexValFlagLinked(indexValue)) {
            throw new AssertionError((Object)"not linked record");
        }
        int segment = this.recidToSegment(recid2);
        LongLongHashMap cacheRec = this.cacheRecords[segment];
        long pointer = indexValue;
        while (pointer != 0L) {
            long l;
            boolean isLinked = this.indexValFlagLinked(pointer);
            long size = StoreDirectJava.indexValToSize(pointer);
            long offset = StoreDirectJava.indexValToOffset(pointer);
            if (isLinked) {
                long walId = cacheRec.get(offset);
                if (walId == 0L) {
                    l = DataIO.parity3Get(this.getVolume().getLong(offset));
                } else {
                    byte[] ba = this.wal.walGetRecord(walId, recid2);
                    l = DataIO.parity3Get(DataIO.getLong(ba, 0));
                }
            } else {
                l = 0L;
            }
            pointer = l;
            long sizeUp = DataIO.roundUp(size, 16L);
            this.releaseData(sizeUp, offset, false);
            cacheRec.remove(offset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long linkedRecordPut(@NotNull byte[] output, int size, long recid2) {
        long l;
        Intrinsics.checkNotNullParameter(output, "output");
        int segment = this.recidToSegment(recid2);
        LongLongHashMap cacheRec = this.cacheRecords[segment];
        long remSize = size;
        long chunkSize = 0L;
        chunkSize = Math.min(65520L, remSize);
        Utils utils = Utils.INSTANCE;
        Lock lock$iv = this.getStructuralLock();
        boolean $i$f$lock = false;
        Lock lock = lock$iv;
        if (lock != null) {
            lock.lock();
        }
        try {
            boolean bl = false;
            l = this.allocateData(DataIO.roundUp((int)chunkSize, 16), false);
        }
        finally {
            Lock lock2 = lock$iv;
            if (lock2 != null) {
                lock2.unlock();
            }
        }
        long chunkOffset = l;
        long walId = this.wal.walPutRecord(recid2, output, (int)(remSize - chunkSize), (int)chunkSize);
        cacheRec.put(chunkOffset, walId);
        remSize -= chunkSize;
        long isLinked = 0L;
        while (remSize > 0L) {
            long l2;
            long prevLink = DataIO.parity3Set((chunkSize + isLinked << 48) + chunkOffset + isLinked);
            isLinked = 8L;
            chunkSize = Math.min(65512L, remSize);
            Utils utils2 = Utils.INSTANCE;
            Lock lock$iv2 = this.getStructuralLock();
            boolean $i$f$lock2 = false;
            Lock lock3 = lock$iv2;
            if (lock3 != null) {
                lock3.lock();
            }
            try {
                boolean bl = false;
                l2 = this.allocateData((int)DataIO.roundUp(chunkSize + (long)8, 16L), false);
            }
            finally {
                Lock lock4 = lock$iv2;
                if (lock4 != null) {
                    lock4.unlock();
                }
            }
            chunkOffset = l2;
            byte[] ba = new byte[(int)chunkSize + 8];
            DataIO.putLong(ba, 0, prevLink);
            System.arraycopy(output, (int)(remSize -= chunkSize), ba, 8, (int)chunkSize);
            walId = this.wal.walPutRecord(recid2, ba, 0, ba.length);
            cacheRec.put(chunkOffset, walId);
        }
        if (remSize != 0L) {
            throw new AssertionError();
        }
        return (chunkSize + (long)8 << 48) + chunkOffset + isLinked + 2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> long put(@Nullable R record, @NotNull Serializer<R> serializer) {
        long l;
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        DataOutput2 di = this.serialize(record, serializer);
        this.assertNotClosed();
        Utils utils = Utils.INSTANCE;
        Lock lock$iv = this.getStructuralLock();
        boolean $i$f$lock = false;
        Lock lock = lock$iv;
        if (lock != null) {
            lock.lock();
        }
        try {
            boolean bl = false;
            l = this.allocateRecid();
        }
        finally {
            Lock lock2 = lock$iv;
            if (lock2 != null) {
                lock2.unlock();
            }
        }
        long recid2 = l;
        long indexOffset = this.recidToOffset(recid2);
        int segment = this.recidToSegment(recid2);
        Utils bl = Utils.INSTANCE;
        ReadWriteLock lock$iv2 = this.getLocks()[segment];
        boolean $i$f$lockWrite = false;
        if (lock$iv2 != null) {
            lock$iv2.writeLock().lock();
        }
        try {
            boolean bl2 = false;
            if (di != null) {
                if (di.pos == 0) {
                    long indexVal = this.indexValCompose(0L, 0L, 0, 0, 1);
                    this.setIndexVal(recid2, indexVal);
                } else if (di.pos < 6) {
                    long offset = DataIO.getLong(di.buf, 0) >>> (7 - di.pos) * 8;
                    long l2 = di.pos;
                    long indexVal = this.indexValCompose(l2, offset, 0, 0, 1);
                    this.setIndexVal(recid2, indexVal);
                } else if ((long)di.pos > 65520L) {
                    Intrinsics.checkNotNullExpressionValue(di.buf, "buf");
                    long indexVal = this.linkedRecordPut(di.buf, di.pos, recid2);
                    this.setIndexVal(recid2, indexVal);
                } else {
                    long l3;
                    Utils utils2 = Utils.INSTANCE;
                    Lock lock$iv3 = this.getStructuralLock();
                    boolean $i$f$lock2 = false;
                    Lock lock3 = lock$iv3;
                    if (lock3 != null) {
                        lock3.lock();
                    }
                    try {
                        boolean bl3 = false;
                        l3 = this.allocateData(DataIO.roundUp(di.pos, 16), false);
                    }
                    finally {
                        Lock lock4 = lock$iv3;
                        if (lock4 != null) {
                            lock4.unlock();
                        }
                    }
                    long volOffset = l3;
                    long walId = this.wal.walPutRecord(recid2, di.buf, 0, di.pos);
                    this.cacheRecords[segment].put(volOffset, walId);
                    long l4 = di.pos;
                    long indexVal = this.indexValCompose(l4, volOffset, 0, 0, 1);
                    this.setIndexVal(recid2, indexVal);
                }
            } else {
                long indexVal = this.indexValCompose(65535L, 0L, 0, 0, 1);
                this.cacheIndexVals[segment].put(indexOffset, indexVal);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv2 != null) {
                lock$iv2.writeLock().unlock();
            }
        }
        return recid2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> void update(long recid2, @Nullable R record, @NotNull Serializer<R> serializer) {
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        this.assertNotClosed();
        DataOutput2 di = this.serialize(record, serializer);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLocks()[this.recidToSegment(recid2)];
        boolean $i$f$lockWrite = false;
        if (lock$iv != null) {
            lock$iv.writeLock().lock();
        }
        try {
            boolean bl = false;
            this.updateProtected(recid2, di);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateProtected(long recid2, DataOutput2 di) {
        long l;
        long newUpSize;
        Utils.INSTANCE.assertWriteLock(this.getLocks()[this.recidToSegment(recid2)]);
        long oldIndexVal = this.getIndexVal(recid2);
        boolean oldLinked = this.indexValFlagLinked(oldIndexVal);
        long oldSize = StoreDirectJava.indexValToSize(oldIndexVal);
        if (oldSize == 65534L) {
            throw new DBException.GetVoid(recid2);
        }
        long l2 = newUpSize = di == null ? -16L : DataIO.roundUp(StoreWAL.updateProtected$roundSixDown(di.pos), 16L);
        if (oldLinked || newUpSize != DataIO.roundUp(StoreWAL.updateProtected$roundSixDown(oldSize), 16L) && oldSize != 65535L && oldSize > 5L) {
            Utils utils = Utils.INSTANCE;
            Lock lock$iv = this.getStructuralLock();
            boolean $i$f$lock = false;
            Lock lock = lock$iv;
            if (lock != null) {
                lock.lock();
            }
            try {
                boolean bl = false;
                if (oldLinked) {
                    this.linkedRecordDelete(oldIndexVal, recid2);
                } else {
                    long oldOffset = StoreDirectJava.indexValToOffset(oldIndexVal);
                    long sizeUp = DataIO.roundUp(oldSize, 16L);
                    this.releaseData(sizeUp, oldOffset, false);
                    this.cacheRecords[this.recidToSegment(recid2)].remove(oldOffset);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                Lock lock2 = lock$iv;
                if (lock2 != null) {
                    lock2.unlock();
                }
            }
        }
        if (di == null) {
            this.setIndexVal(recid2, this.indexValCompose(65535L, 0L, 0, 0, 1));
            return;
        }
        if ((long)di.pos > 65520L) {
            Intrinsics.checkNotNullExpressionValue(di.buf, "buf");
            long newIndexVal = this.linkedRecordPut(di.buf, di.pos, recid2);
            this.setIndexVal(recid2, newIndexVal);
            return;
        }
        int size = di.pos;
        if (size != 0 && size < 6) {
            l = DataIO.getLong(di.buf, 0) >>> (7 - size) * 8;
        } else if (!oldLinked && newUpSize == DataIO.roundUp(oldSize, 16L) && oldSize >= 6L) {
            l = StoreDirectJava.indexValToOffset(oldIndexVal);
        } else if (size == 0) {
            l = 0L;
        } else {
            Utils bl = Utils.INSTANCE;
            Lock lock$iv = this.getStructuralLock();
            boolean $i$f$lock = false;
            Lock lock = lock$iv;
            if (lock != null) {
                lock.lock();
            }
            try {
                boolean bl2 = false;
                long l3 = this.allocateData(DataIO.roundUp(size, 16), false);
                l = l3;
            }
            finally {
                Lock lock3 = lock$iv;
                if (lock3 != null) {
                    lock3.unlock();
                }
            }
        }
        long offset = l;
        if (size > 5) {
            long walId = this.wal.walPutRecord(recid2, di.buf, 0, size);
            this.cacheRecords[this.recidToSegment(recid2)].put(offset, walId);
        }
        this.setIndexVal(recid2, this.indexValCompose(size, offset, 0, 0, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public <R> R get(long recid2, @NotNull Serializer<R> serializer) {
        Intrinsics.checkNotNullParameter(serializer, "serializer");
        int segment = this.recidToSegment(recid2);
        Utils utils = Utils.INSTANCE;
        ReadWriteLock lock$iv = this.getLocks()[segment];
        boolean $i$f$lockRead = false;
        if (lock$iv != null) {
            lock$iv.readLock().lock();
        }
        try {
            boolean bl = false;
            long indexVal = this.getIndexVal(recid2);
            long size = StoreDirectJava.indexValToSize(indexVal);
            if (size == 65535L) {
                R r = null;
                return r;
            }
            if (size == 65534L) {
                throw new DBException.GetVoid(recid2);
            }
            if (this.indexValFlagLinked(indexVal)) {
                byte[] ba = this.linkedRecordGet(indexVal, recid2);
                R r = this.deserialize(serializer, new DataInput2.ByteArray(ba), ba.length);
                return r;
            }
            long volOffset = StoreDirectJava.indexValToOffset(indexVal);
            if (size < 6L) {
                if (size > 5L) {
                    throw new DBException.DataCorruption("wrong size record header");
                }
                R r = serializer.deserializeFromLong(volOffset >>> 8, (int)size);
                return r;
            }
            long walId = this.cacheRecords[segment].get(volOffset);
            DataInput2 di = walId != 0L ? (DataInput2)new DataInput2.ByteArray(this.wal.walGetRecord(walId, recid2)) : this.getVolume().getDataInput(volOffset, (int)size);
            Intrinsics.checkNotNull(di);
            R r = this.deserialize(serializer, di, size);
            return r;
        }
        finally {
            if (lock$iv != null) {
                lock$iv.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public LongIterator getAllRecids() {
        LongArrayList ret;
        block8: {
            ret = new LongArrayList();
            Utils.INSTANCE.lockReadAll(this.getLocks());
            try {
                long maxRecid = this.getMaxRecid();
                long recid2 = 1L;
                if (recid2 > maxRecid) break block8;
                while (true) {
                    try {
                        long indexVal = this.getIndexVal(recid2);
                        if (!this.indexValFlagUnused(indexVal)) {
                            ret.add(recid2);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (recid2 != maxRecid) {
                        ++recid2;
                        continue;
                    }
                    break;
                }
            }
            finally {
                Utils.INSTANCE.unlockReadAll(this.getLocks());
            }
        }
        return ArrayIteratorsKt.iterator(ret.toArray());
    }

    @Override
    public void verify() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Utils.INSTANCE.lockWriteAll(this.getLocks());
        try {
            if (!this.getClosed().compareAndSet(false, true)) {
                return;
            }
            this.getVolume().close();
            if (this.getFileDeleteAfterClose() && this.getFile() != null) {
                new File(this.getFile()).delete();
                this.wal.destroyWalFiles();
            }
        }
        finally {
            Utils.INSTANCE.unlockWriteAll(this.getLocks());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        Utils.INSTANCE.lockWriteAll(this.getLocks());
        try {
            LongLongHashMap it;
            LongLongHashMap element$iv;
            int n;
            this.realVolume.getData(0L, this.headBytes, 0, this.headBytes.length);
            this.cacheIndexLinks.clear();
            LongLongHashMap[] $this$forEach$iv = this.cacheIndexVals;
            boolean $i$f$forEach = false;
            int n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl = false;
                it.clear();
                it.compact();
            }
            $this$forEach$iv = this.cacheRecords;
            $i$f$forEach = false;
            n2 = $this$forEach$iv.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv = $this$forEach$iv[n];
                boolean bl = false;
                it.clear();
                it.compact();
            }
            this.cacheStacks.clear();
            this.cacheStacks.compact();
            this.getIndexPages().clear();
            for (long page : this.indexPagesBackup) {
                this.getIndexPages().add(page);
            }
            this.wal.rollback();
        }
        finally {
            Utils.INSTANCE.unlockWriteAll(this.getLocks());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        Utils.INSTANCE.lockWriteAll(this.getLocks());
        try {
            DataIO.putInt(this.headBytes, 20, this.calculateHeaderChecksum());
            this.wal.walPutByteArray(0L, this.headBytes, 0, this.headBytes.length);
            this.wal.commit();
            this.realVolume.putData(0L, this.headBytes, 0, this.headBytes.length);
            this.realVolume.ensureAvailable(this.getFileTail$mapdb());
            for (LongLongHashMap indexVals : this.cacheIndexVals) {
                indexVals.forEachKeyValue((arg_0, arg_1) -> StoreWAL.commit$lambda$17(this, arg_0, arg_1));
                indexVals.clear();
                indexVals.compact();
            }
            this.cacheIndexLinks.forEachKeyValue((arg_0, arg_1) -> StoreWAL.commit$lambda$18(this, arg_0, arg_1));
            this.cacheIndexLinks.clear();
            this.cacheStacks.forEachKeyValue((arg_0, arg_1) -> StoreWAL.commit$lambda$19(new Function2<Long, byte[], Unit>(this){
                final /* synthetic */ StoreWAL this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                public final void invoke(long offset, byte[] bytes) {
                    this.this$0.getRealVolume().putData(offset, bytes, 0, bytes.length);
                }
            }, arg_0, arg_1));
            this.cacheStacks.clear();
            this.cacheStacks.compact();
            for (LongLongHashMap records : this.cacheRecords) {
                records.forEachKeyValue((arg_0, arg_1) -> StoreWAL.commit$lambda$20(this, arg_0, arg_1));
                records.clear();
                records.compact();
            }
            long[] lArray = this.getIndexPages().toArray();
            Intrinsics.checkNotNullExpressionValue(lArray, "toArray(...)");
            this.indexPagesBackup = lArray;
            if (!this.getFileSyncDisable$mapdb()) {
                this.realVolume.sync();
            }
            this.wal.destroyWalFiles();
            this.wal.close();
        }
        finally {
            Utils.INSTANCE.unlockWriteAll(this.getLocks());
        }
    }

    @Override
    public void compact() {
    }

    @Override
    protected long allocateNewPage() {
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        long eof = this.getFileTail$mapdb();
        long newEof = eof + 0x100000L;
        this.allocatedPages.add(eof);
        this.setFileTail$mapdb(newEof);
        return eof;
    }

    @Override
    protected long allocateNewIndexPage() {
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        long indexPage = this.allocateNewPage();
        long pagePointerOffset = this.getIndexPages().isEmpty() ? 32864L : this.getIndexPages().get(this.getIndexPages().size() - 1) + (long)8;
        this.wal.walPutLong(pagePointerOffset, DataIO.parity16Set(indexPage));
        this.cacheIndexLinks.put(pagePointerOffset, DataIO.parity16Set(indexPage));
        this.getIndexPages().add(indexPage);
        this.wal.walPutLong(indexPage + (long)8, DataIO.parity16Set(0L));
        this.cacheIndexLinks.put(indexPage + (long)8, DataIO.parity16Set(0L));
        return indexPage;
    }

    @Override
    protected void freeSizeIncrement(long increment) {
    }

    @Override
    protected void longStackPut(long masterLinkOffset, long value, boolean recursive) {
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        if (masterLinkOffset <= 0L || masterLinkOffset > 0x100000L || masterLinkOffset % (long)8 != 0L) {
            throw new DBException.DataCorruption("wrong master link");
        }
        if (value >> 48 != 0L) {
            throw new AssertionError();
        }
        DataIO.parity1Get(value);
        long valueSize = DataIO.packLongSize(value);
        long masterLinkVal = DataIO.parity4Get(this.getHeadVol().getLong(masterLinkOffset));
        if (masterLinkVal == 0L) {
            this.longStackNewChunk(masterLinkOffset, 0L, value, valueSize, true);
            return;
        }
        long currSize = masterLinkVal >>> 48;
        long chunkOffset = masterLinkVal & 0xFFFFFFFFFFF0L;
        byte[] ba = this.longStackLoadChunk(chunkOffset);
        if (currSize + valueSize > (long)ba.length) {
            this.longStackNewChunk(masterLinkOffset, chunkOffset, value, valueSize, true);
            return;
        }
        DataIO.packLong(ba, (int)currSize, value);
        long newMasterLinkValue = (currSize + valueSize << 48) + chunkOffset;
        this.getHeadVol().putLong(masterLinkOffset, DataIO.parity4Set(newMasterLinkValue));
    }

    private final byte[] longStackLoadChunk(long chunkOffset) {
        byte[] ba = this.cacheStacks.get(chunkOffset);
        if (ba == null) {
            long prevLinkVal = DataIO.parity4Get(this.getVolume().getLong(chunkOffset));
            int pageSize = (int)(prevLinkVal >>> 48);
            ba = new byte[pageSize];
            this.getVolume().getData(chunkOffset, ba, 0, pageSize);
            this.cacheStacks.put(chunkOffset, ba);
        }
        if ((long)ba.length > 256L) {
            throw new AssertionError();
        }
        return ba;
    }

    protected final void longStackNewChunk(long masterLinkOffset, long prevPageOffset, long value, long valueSize, boolean recursive) {
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        if (masterLinkOffset <= 0L || masterLinkOffset > 0x100000L || masterLinkOffset % (long)8 != 0L) {
            throw new DBException.DataCorruption("wrong master link");
        }
        long newChunkSize = -1L;
        if (!recursive) {
            long size = 256L;
            long l = ProgressionUtilKt.getProgressionLastElement(256L, 16L, -16L);
            if (l <= size) {
                while (true) {
                    long indexVal;
                    long masterLinkOffset2;
                    if (masterLinkOffset != (masterLinkOffset2 = this.longStackMasterLinkOffset(size)) && (indexVal = DataIO.parity4Get(this.getHeadVol().getLong(masterLinkOffset2))) != 0L) {
                        newChunkSize = size;
                        break;
                    }
                    if (size == l) break;
                    size += -16L;
                }
            }
        }
        long dataTail = this.getDataTail();
        long remainderSize = DataIO.roundUp(dataTail, 0x100000L) - dataTail;
        if (newChunkSize == -1L) {
            long dataTail2 = dataTail;
            if (dataTail2 == 0L) {
                newChunkSize = 160L;
            } else {
                long l = newChunkSize = remainderSize > 256L || remainderSize < 16L ? 160L : remainderSize;
            }
        }
        if (newChunkSize % (long)16 != 0L) {
            throw new AssertionError();
        }
        long newChunkOffset = this.allocateData((int)newChunkSize, true);
        byte[] ba = new byte[(int)newChunkSize];
        this.cacheStacks.put(newChunkOffset, ba);
        DataIO.putLong(ba, 0, DataIO.parity4Set((newChunkSize << 48) + prevPageOffset));
        DataIO.packLong(ba, 8, value);
        long newSize = (long)8 + valueSize;
        long newMasterLinkValue = (newSize << 48) + newChunkOffset;
        this.getHeadVol().putLong(masterLinkOffset, DataIO.parity4Set(newMasterLinkValue));
    }

    @Override
    protected long longStackTake(long masterLinkOffset, boolean recursive) {
        long l;
        int pos;
        Utils.INSTANCE.assertLocked(this.getStructuralLock());
        if (masterLinkOffset <= 0L || masterLinkOffset > 0x100000L || masterLinkOffset % (long)8 != 0L) {
            throw new DBException.DataCorruption("wrong master link");
        }
        long masterLinkVal = DataIO.parity4Get(this.getHeadVol().getLong(masterLinkOffset));
        if (masterLinkVal == 0L) {
            return 0L;
        }
        long offset = masterLinkVal & 0xFFFFFFFFFFF0L;
        byte[] ba = this.longStackLoadChunk(offset);
        for (pos = (int)Math.max((masterLinkVal >>> 48) - 1L, 8L); pos > 8 && (ba[pos - 1] & 0x80) == 0; --pos) {
        }
        if ((long)pos < 8L) {
            throw new DBException.DataCorruption("position too small");
        }
        if (DataIO.getLong(ba, 0) >>> 48 <= (long)pos) {
            throw new DBException.DataCorruption("position beyond chunk " + masterLinkOffset);
        }
        long ret = DataIO.unpackLong(ba, pos);
        int n = pos + DataIO.packLongSize(ret);
        for (int i = pos; i < n; ++i) {
            ba[i] = 0;
        }
        if ((long)pos > 8L) {
            this.getHeadVol().putLong(masterLinkOffset, DataIO.parity4Set(((long)pos << 48) + offset));
            if (ret >> 48 != 0L) {
                throw new AssertionError();
            }
            if (ret != 0L) {
                DataIO.parity1Get(ret);
            }
            return ret;
        }
        long prevChunkValue = DataIO.parity4Get(DataIO.getLong(ba, 0));
        DataIO.putLong(ba, 0, 0L);
        long currentSize = prevChunkValue >>> 48;
        long prevChunkOffset = prevChunkValue & 0xFFFFFFFFFFF0L;
        if (prevChunkOffset != 0L) {
            byte[] baPrev = this.longStackLoadChunk(prevChunkOffset);
            long pos2 = DataIO.parity4Get(DataIO.getLong(baPrev, 0)) >>> 48;
            l = this.longStackFindEnd(prevChunkOffset, pos2);
        } else {
            l = 0L;
        }
        long masterLinkPos = l;
        this.getHeadVol().putLong(masterLinkOffset, DataIO.parity4Set((masterLinkPos << 48) + prevChunkOffset));
        this.releaseData(currentSize, offset, true);
        if (ret >> 48 != 0L) {
            throw new AssertionError();
        }
        if (ret != 0L) {
            DataIO.parity1Get(ret);
        }
        return ret;
    }

    protected final long longStackFindEnd(long pageOffset, long pos) {
        int pos2;
        byte[] ba = this.longStackLoadChunk(pageOffset);
        for (pos2 = (int)pos; pos2 > 8 && ba[pos2 - 1] == 0; --pos2) {
        }
        return pos2;
    }

    @Override
    public boolean fileLoad() {
        return this.getVolume().fileLoad();
    }

    @Override
    @NotNull
    public Iterable<String> getAllFiles() {
        if (this.getFile() == null) {
            List<String> list = Arrays.asList(new String[0]);
            Intrinsics.checkNotNullExpressionValue(list, "asList(...)");
            return list;
        }
        String[] stringArray = new String[]{this.getFile()};
        ArrayList<String> ret = CollectionsKt.arrayListOf(stringArray);
        Collection collection = ret;
        Iterable<String> iterable = this.wal.getAllFiles();
        Intrinsics.checkNotNullExpressionValue(iterable, "getAllFiles(...)");
        CollectionsKt.addAll(collection, iterable);
        return CollectionsKt.toList((Iterable)ret);
    }

    private static final long updateProtected$roundSixDown(long size) {
        return size < 6L ? 0L : size;
    }

    private static final void commit$lambda$17(StoreWAL this$0, long indexOffset, long indexVal) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.realVolume.putLong(indexOffset, indexVal);
    }

    private static final void commit$lambda$18(StoreWAL this$0, long indexOffset, long indexVal) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.realVolume.putLong(indexOffset, indexVal);
    }

    private static final void commit$lambda$19(Function2 $tmp0, long p0, Object p1) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void commit$lambda$20(StoreWAL this$0, long offset, long walId) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        byte[] bytes = this$0.wal.walGetRecord(walId, 0L);
        this$0.realVolume.putData(offset, bytes, 0, bytes.length);
    }

    @JvmStatic
    @NotNull
    public static final StoreWAL make(@Nullable String file, @NotNull VolumeFactory volumeFactory, long fileLockWait, boolean isThreadSafe, int concShift, long allocateIncrement, long allocateStartSize, boolean fileDeleteAfterClose, boolean fileDelteAfterOpen, boolean checksum, boolean checksumHeader, boolean checksumHeaderBypass) {
        return Companion.make(file, volumeFactory, fileLockWait, isThreadSafe, concShift, allocateIncrement, allocateStartSize, fileDeleteAfterClose, fileDelteAfterOpen, checksum, checksumHeader, checksumHeaderBypass);
    }

    protected static final long getTOMB1() {
        return Companion.getTOMB1();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0082\u0001\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00042\b\b\u0002\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010\u0015\u001a\u00020\u00102\b\b\u0002\u0010\u0016\u001a\u00020\u00102\b\b\u0002\u0010\u0017\u001a\u00020\u00102\b\b\u0002\u0010\u0018\u001a\u00020\u00102\b\b\u0002\u0010\u0019\u001a\u00020\u0010H\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0004X\u0085D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/mapdb/StoreWAL$Companion;", "", "()V", "TOMB1", "", "getTOMB1$annotations", "getTOMB1", "()J", "make", "Lorg/mapdb/StoreWAL;", "file", "", "volumeFactory", "Lorg/mapdb/volume/VolumeFactory;", "fileLockWait", "isThreadSafe", "", "concShift", "", "allocateIncrement", "allocateStartSize", "fileDeleteAfterClose", "fileDelteAfterOpen", "checksum", "checksumHeader", "checksumHeaderBypass", "mapdb"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final StoreWAL make(@Nullable String file, @NotNull VolumeFactory volumeFactory, long fileLockWait, boolean isThreadSafe, int concShift, long allocateIncrement, long allocateStartSize, boolean fileDeleteAfterClose, boolean fileDelteAfterOpen, boolean checksum, boolean checksumHeader, boolean checksumHeaderBypass) {
            Intrinsics.checkNotNullParameter(volumeFactory, "volumeFactory");
            return new StoreWAL(file, volumeFactory, fileLockWait, isThreadSafe, concShift, allocateIncrement, allocateStartSize, fileDeleteAfterClose, fileDelteAfterOpen, checksum, checksumHeader, checksumHeaderBypass);
        }

        public static /* synthetic */ StoreWAL make$default(Companion companion, String string, VolumeFactory volumeFactory, long l, boolean bl, int n, long l2, long l3, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = null;
            }
            if ((n2 & 2) != 0) {
                VolumeFactory volumeFactory2;
                if (string == null) {
                    VolumeFactory volumeFactory3 = CC.DEFAULT_MEMORY_VOLUME_FACTORY;
                    volumeFactory2 = volumeFactory3;
                    Intrinsics.checkNotNullExpressionValue(volumeFactory3, "DEFAULT_MEMORY_VOLUME_FACTORY");
                } else {
                    VolumeFactory volumeFactory4 = CC.DEFAULT_FILE_VOLUME_FACTORY;
                    volumeFactory2 = volumeFactory4;
                    Intrinsics.checkNotNullExpressionValue(volumeFactory4, "DEFAULT_FILE_VOLUME_FACTORY");
                }
                volumeFactory = volumeFactory2;
            }
            if ((n2 & 4) != 0) {
                l = 0L;
            }
            if ((n2 & 8) != 0) {
                bl = true;
            }
            if ((n2 & 0x10) != 0) {
                n = 3;
            }
            if ((n2 & 0x20) != 0) {
                l2 = 0x100000L;
            }
            if ((n2 & 0x40) != 0) {
                l3 = 0L;
            }
            if ((n2 & 0x80) != 0) {
                bl2 = false;
            }
            if ((n2 & 0x100) != 0) {
                bl3 = false;
            }
            if ((n2 & 0x200) != 0) {
                bl4 = false;
            }
            if ((n2 & 0x400) != 0) {
                bl5 = true;
            }
            if ((n2 & 0x800) != 0) {
                bl6 = false;
            }
            return companion.make(string, volumeFactory, l, bl, n, l2, l3, bl2, bl3, bl4, bl5, bl6);
        }

        protected final long getTOMB1() {
            return TOMB1;
        }

        @JvmStatic
        protected static /* synthetic */ void getTOMB1$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

