/*
 * Decompiled with CFR 0.152.
 */
package tech.energyit.statsd;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;

final class Numbers {
    private static final int ROUNDING_MULTIPLIER = 1000000000;
    private static final char[] DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private static final char[] DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    private Numbers() {
    }

    private static int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    static void putLongAsAsciiBytes(long i, ByteBuffer buf) {
        int q2;
        int r;
        int numberOfChars = i < 0L ? Numbers.stringSize(-i) + 1 : Numbers.stringSize(i);
        buf.position(buf.position() + numberOfChars);
        int charPos = buf.position();
        int sign = 0;
        if (i < 0L) {
            sign = 45;
            i = -i;
        }
        while (i > Integer.MAX_VALUE) {
            long q = i / 100L;
            r = (int)(i - ((q << 6) + (q << 5) + (q << 2)));
            i = q;
            buf.put(--charPos, (byte)DigitOnes[r]);
            buf.put(--charPos, (byte)DigitTens[r]);
        }
        int i2 = (int)i;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            buf.put(--charPos, (byte)DigitOnes[r]);
            buf.put(--charPos, (byte)DigitTens[r]);
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            buf.put(--charPos, (byte)digits[r]);
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            buf.put(--charPos, (byte)sign);
        }
    }

    public static void putDoubleAsAsciiBytes(double v, ByteBuffer bb, Charset messageCharset, boolean exact) {
        if (exact || v >= 9.223372036854776E18 || v <= -9.223372036854776E18) {
            bb.put(String.valueOf(v).getBytes(messageCharset));
        } else {
            long digits = (long)v;
            if (digits == 0L && v < 0.0) {
                bb.put((byte)45);
            }
            Numbers.putLongAsAsciiBytes(digits, bb);
            bb.put((byte)46);
            long fraction = Math.round(Math.abs(v - (double)digits) * 1.0E9);
            if (fraction > 0L) {
                long shift = 10L;
                while (fraction * shift < 1000000000L) {
                    shift *= 10L;
                    bb.put((byte)48);
                }
                long divisor = 10L;
                while (fraction % divisor == 0L) {
                    divisor *= 10L;
                }
                Numbers.putLongAsAsciiBytes(fraction / (divisor / 10L), bb);
            } else {
                Numbers.putLongAsAsciiBytes(0L, bb);
            }
        }
    }
}

