/*
 * Decompiled with CFR 0.152.
 */
package tech.energyit.statsd;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.function.Supplier;
import tech.energyit.statsd.IOUtils;
import tech.energyit.statsd.Sender;
import tech.energyit.statsd.StatsDClientErrorHandler;

public class SynchronousSender
implements Sender,
Closeable {
    private final DatagramChannel clientChannel;
    private final StatsDClientErrorHandler errorHandler;

    private SynchronousSender(Supplier<DatagramChannel> socketSupplier, Supplier<InetSocketAddress> addressLookup, StatsDClientErrorHandler errorHandler, boolean blockingChannel) {
        this.errorHandler = errorHandler;
        try {
            this.clientChannel = socketSupplier.get();
            this.clientChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Boolean.TRUE);
            this.clientChannel.configureBlocking(blockingChannel);
            this.clientChannel.connect(addressLookup.get());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to connect channel", e);
        }
    }

    @Override
    public void send(ByteBuffer msg) {
        try {
            int sizeOfBuffer = msg.limit();
            int sentBytes = this.clientChannel.write(msg);
            if (sizeOfBuffer != sentBytes) {
                this.errorHandler.handle("Could not send complete message : %s. %d/%d bytes sent.", msg.toString(), sentBytes, sizeOfBuffer);
            }
        }
        catch (IOException e) {
            this.errorHandler.handle(e);
        }
    }

    @Override
    public void close() {
        if (this.clientChannel != null) {
            try {
                this.clientChannel.close();
            }
            catch (Exception e) {
                this.errorHandler.handle(e);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean blockingChannel = false;
        private Supplier<DatagramChannel> socketSupplier = IOUtils::newDatagramChannel;
        private Supplier<InetSocketAddress> addressLookup = () -> new InetSocketAddress(IOUtils.inetAddress("localhost"), 8125);
        private StatsDClientErrorHandler errorHandler = StatsDClientErrorHandler.NO_OP_HANDLER;

        public Builder blockingChannel(boolean blockingChannel) {
            this.blockingChannel = blockingChannel;
            return this;
        }

        public Builder withHostAndPort(String hostname, int port) {
            this.addressLookup = () -> new InetSocketAddress(IOUtils.inetAddress(hostname), port);
            return this;
        }

        public Builder withSocketSupplier(Supplier<DatagramChannel> socketSupplier) {
            this.socketSupplier = socketSupplier;
            return this;
        }

        public Builder withAddressLookup(Supplier<InetSocketAddress> addressLookup) {
            this.addressLookup = addressLookup;
            return this;
        }

        public Builder withErrorHandler(StatsDClientErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public SynchronousSender build() {
            return new SynchronousSender(this.socketSupplier, this.addressLookup, this.errorHandler, this.blockingChannel);
        }
    }
}

