/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.listener;

import com.deutscheboerse.comxerv.comtrader.api.comxerv.common.listener.MapperAwareNotifyListenerObjectHandler;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.CurrentTradingLimit;
import com.deutscheboerse.comxerv.comtrader.entities.TradingLimit;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.service.BroadcastListenerHandlerForClass;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.m7.trading.api.v6.CashLmtRprt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CashLmtRprtNotifyListenersObjectHandler
extends MapperAwareNotifyListenerObjectHandler<CashLmtRprt> {
    private final SmallFastDataModel<String, TradingLimit> tradingLimitDataModel;
    private final SmallFastDataModel<String, CurrentTradingLimit> currentTradingLimitDataModel;

    public CashLmtRprtNotifyListenersObjectHandler(BroadcastListenerHandlerForClass broadcastHandler, ApplicationContext appContext, MapperHandler mappers) {
        super(broadcastHandler, mappers);
        this.tradingLimitDataModel = appContext.getSmallDataModel(TradingLimit.class);
        this.currentTradingLimitDataModel = appContext.getSmallDataModel(CurrentTradingLimit.class);
    }

    @Override
    public Collection<? extends BroadcastEntity<String>> unpack(CashLmtRprt object, Exchange exchange, String correlationId) {
        ArrayList<BroadcastEntity> broadcastEntities = new ArrayList<BroadcastEntity>();
        if (object != null) {
            List<TradingLimit> tradingLimits = this.mappers.translateList(TradingLimit.class, object.getCashLmtList().getCashLmt(), object);
            List<CurrentTradingLimit> currentTradingLimit = this.mappers.translateList(CurrentTradingLimit.class, object.getCurrentCashLmtList().getCurrentCashLmt(), object);
            broadcastEntities.addAll(currentTradingLimit);
            broadcastEntities.addAll(tradingLimits);
        }
        return broadcastEntities;
    }

    @Override
    public ObjectHandler.Result handleObject(Session session, CashLmtRprt object, String correlationId) {
        this.tradingLimitDataModel.removeAll();
        this.currentTradingLimitDataModel.removeAll();
        return super.handleObject(session, object, correlationId);
    }
}

