/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.type.BasketRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OpenOrClose;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValidityRestriction;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.m7.trading.api.v6.ListExecInstType;
import com.deutscheboerse.m7.trading.api.v6.OpenCloseIndType;
import com.deutscheboerse.m7.trading.api.v6.OrdrExeRestrictionType;
import com.deutscheboerse.m7.trading.api.v6.OrdrType;
import com.deutscheboerse.m7.trading.api.v6.ValidityRestrictionType;

public abstract class AbstractOrderMapper<F, T>
extends AbstractMapper<F, T> {
    protected AbstractOrderMapper(ApplicationContext applicationContext, Exchange exchange, Class<F> from, Class<T> to) {
        super(applicationContext, exchange, from, to);
    }

    protected OpenCloseIndType mapOpenCloseIndicator(OpenOrClose openOrClose) {
        switch (openOrClose) {
            case CLOSE: {
                return OpenCloseIndType.C;
            }
            case OPEN: {
                return OpenCloseIndType.O;
            }
        }
        throw new IllegalStateException("Invalid open/close indicator. " + String.valueOf(openOrClose));
    }

    protected BasketRestriction mapListExecInst(ListExecInstType listExecInst) {
        switch (listExecInst) {
            case NONE: {
                return BasketRestriction.NONE;
            }
            case VALID: {
                return BasketRestriction.VLD;
            }
            case LNKD: {
                return BasketRestriction.LNK;
            }
        }
        throw new IllegalStateException("Invalid basket restriction.");
    }

    protected ListExecInstType mapBasketRestriction(BasketRestriction basketRestriction) {
        switch (basketRestriction) {
            case NONE: {
                return ListExecInstType.NONE;
            }
            case LNK: {
                return ListExecInstType.LNKD;
            }
            case VLD: {
                return ListExecInstType.VALID;
            }
        }
        throw new IllegalStateException("Invalid basket restriction. " + String.valueOf((Object)basketRestriction));
    }

    protected OrdrType mapOrderType(OrderType source, Contract contract) {
        switch (source) {
            case BALANCE: {
                return OrdrType.L;
            }
            case ICEBERG: {
                return OrdrType.I;
            }
            case STOP: {
                return OrdrType.S;
            }
            case REGULAR: 
            case OTC_PREARRANGED: {
                if (contract == null || contract.getType().isBlock()) {
                    return OrdrType.B;
                }
                return OrdrType.O;
            }
            case BESPOKE_PREARRANGED: {
                return OrdrType.E;
            }
        }
        throw new IllegalStateException("Invalid order type: " + String.valueOf(source));
    }

    protected ValidityRestrictionType mapValidityRestriction(ValidityRestriction validityRestriction) {
        switch (validityRestriction) {
            case GOOD_FOR_SESSION: {
                return ValidityRestrictionType.GFS;
            }
            case GOOD_TILL_DATE: {
                return ValidityRestrictionType.GTD;
            }
            case NONE: {
                return ValidityRestrictionType.NON;
            }
        }
        throw new IllegalArgumentException("Invalid ValidityRestriction \"" + String.valueOf(validityRestriction) + "\"");
    }

    protected OrdrExeRestrictionType mapExecutionRestriction(ExecutionRestriction executionRestriction) {
        switch (executionRestriction) {
            case ALL_OR_NOTHING: {
                return OrdrExeRestrictionType.AON;
            }
            case FILL_OR_KILL: {
                return OrdrExeRestrictionType.FOK;
            }
            case IMMEDIATE_OR_CANCEL: {
                return OrdrExeRestrictionType.IOC;
            }
            case NONE: {
                return OrdrExeRestrictionType.NON;
            }
        }
        throw new IllegalArgumentException("Invalid ExecutionRestriction \"" + String.valueOf(executionRestriction) + "\"");
    }
}

