/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper.AbstractTextWithVarsMapper;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.Message;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.entities.type.SpecialMessage;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.m7.trading.api.ErrorCodeAndKey;
import com.deutscheboerse.m7.trading.api.v6.ErrorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorTypeMessageMapper
extends AbstractTextWithVarsMapper<ErrorType, Message> {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorTypeMessageMapper.class);
    private final TimeService timeService;

    public ErrorTypeMessageMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, ErrorType.class, Message.class);
        this.timeService = applicationContext.getService(TimeService.class);
    }

    @Override
    public Message translate(ErrorType from, MapperHandler mapperHandler, Object hint) {
        String errorText;
        try {
            errorText = this.getMessageFormatter().formatError(from.getErrCode(), this.mapVars(from.getVarList()));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Unknown error code: {}, using untranslated text as fallback: {}.", (Object)from.getErrCode(), (Object)from.getErr());
            errorText = from.getErr();
        }
        return Message.createGuiMessage(this.timeService.getServerTime(), errorText, MessageSeverity.ERROR, this.mapSpecialMessage(from.getErrCode()));
    }

    private SpecialMessage mapSpecialMessage(int errCode) {
        if (errCode == ErrorCodeAndKey.TRADE_DELIVERY_TOO_CLOSE.getErrorCode()) {
            return SpecialMessage.TRADE_RECALL_REJECTED_DELIVERY_TOO_CLOSE;
        }
        if (errCode == ErrorCodeAndKey.TRADE_EXECUTION_TOO_LONG_AGO.getErrorCode()) {
            return SpecialMessage.TRADE_RECALL_REJECTED_EXECUTION_TOO_LONG;
        }
        return null;
    }
}

