/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.mapper;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.RiskSet;
import com.deutscheboerse.comxerv.comtrader.entities.type.RiskSetState;
import com.deutscheboerse.comxerv.comtrader.service.mapper.AbstractMapper;
import com.deutscheboerse.comxerv.comtrader.service.mapper.MapperHandler;
import com.deutscheboerse.m7.trading.api.v6.ReportRiskSetListEntryType;
import com.deutscheboerse.m7.trading.api.v6.RiskSetModType;
import java.math.BigDecimal;

public class RiskSetMapper
extends AbstractMapper<ReportRiskSetListEntryType, RiskSet> {
    public RiskSetMapper(ApplicationContext applicationContext, Exchange exchange) {
        super(applicationContext, exchange, ReportRiskSetListEntryType.class, RiskSet.class);
    }

    private RiskSetState mapState(RiskSetModType riskSetModType) {
        if (riskSetModType == null) {
            return null;
        }
        switch (riskSetModType) {
            case ACTI: {
                return RiskSetState.ACTI;
            }
            case ADEL: {
                return RiskSetState.ADEL;
            }
        }
        throw new IllegalArgumentException("Unknown risk set state: " + String.valueOf((Object)riskSetModType));
    }

    @Override
    public RiskSet translate(ReportRiskSetListEntryType from, MapperHandler mapperHandler, Object hint) {
        RiskSet riskSet = new RiskSet();
        riskSet.setId(from.getRiskSetId());
        riskSet.setName(from.getRiskSetName());
        riskSet.setRevisionNumber(from.getRevisionNo());
        riskSet.setState(this.mapState(from.getStatus()));
        riskSet.setPosBuyOrder(new LongDisplayValue(BigDecimal.valueOf(from.getCashLmtAParameters().getPosBuyOrdr())));
        riskSet.setPosSellOrder(new LongDisplayValue(BigDecimal.valueOf(from.getCashLmtAParameters().getPosSellOrdr())));
        riskSet.setPosBuyTrade(new LongDisplayValue(BigDecimal.valueOf(from.getCashLmtAParameters().getPosBuyTrade())));
        riskSet.setPosSellTrade(new LongDisplayValue(BigDecimal.valueOf(from.getCashLmtAParameters().getPosSellTrade())));
        riskSet.setNegBuyOrder(new LongDisplayValue(BigDecimal.valueOf(from.getCashLmtAParameters().getNegBuyOrdr())));
        riskSet.setNegSellOrder(new LongDisplayValue(BigDecimal.valueOf(from.getCashLmtAParameters().getNegSellOrdr())));
        riskSet.setNegBuyTrade(new LongDisplayValue(BigDecimal.valueOf(from.getCashLmtAParameters().getNegBuyTrade())));
        riskSet.setNegSellTrade(new LongDisplayValue(BigDecimal.valueOf(from.getCashLmtAParameters().getNegSellTrade())));
        riskSet.setAlphaBuyOrder(new LongDisplayValue(BigDecimal.valueOf(from.getCashLmtAlphaParameters().getBuyOrdr())));
        riskSet.setAlphaSellOrder(new LongDisplayValue(BigDecimal.valueOf(from.getCashLmtAlphaParameters().getSellOrdr())));
        riskSet.setAlphaBuyTrade(new LongDisplayValue(BigDecimal.valueOf(from.getCashLmtAlphaParameters().getBuyTrade())));
        riskSet.setAlphaSellTrade(new LongDisplayValue(BigDecimal.valueOf(from.getCashLmtAlphaParameters().getSellTrade())));
        return riskSet;
    }
}

