/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.api.m7.v6.message;

import com.deutscheboerse.m7.trading.api.ErrorCodeAndKey;
import com.deutscheboerse.m7.trading.api.type.StatusMessageType;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.stream.Collectors;

public class MessageResourceBundle {
    private final Map<Integer, String> messageKeysByCode;
    private final Map<Integer, String> errorKeysByCode = EnumSet.allOf(ErrorCodeAndKey.class).stream().collect(Collectors.toMap(ErrorCodeAndKey::getErrorCode, ErrorCodeAndKey::getText));
    private final Map<Locale, ResourceBundle> resourceBundleCache;

    public MessageResourceBundle() {
        this.messageKeysByCode = EnumSet.allOf(StatusMessageType.class).stream().collect(Collectors.toMap(StatusMessageType::getMessageCode, StatusMessageType::getKey, (v1, v2) -> v2));
        this.resourceBundleCache = new HashMap<Locale, ResourceBundle>();
    }

    public ResourceBundle getMessageResourceBundle(Locale locale) {
        return this.resourceBundleCache.computeIfAbsent(locale, uncachedLocale -> ResourceBundle.getBundle("MessageResources", uncachedLocale));
    }

    String getMessageKey(int messageCode) {
        return this.messageKeysByCode.get(messageCode);
    }

    String getErrorKey(int errorCode) {
        return this.errorKeysByCode.get(errorCode);
    }
}

