/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.core.entity;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemInfo {
    private static final Logger LOG = LoggerFactory.getLogger(SystemInfo.class);
    private final int requestLimit;
    private final String backendVersion;
    private final String currentComtraderVersion;
    private final int contractStoreTimeInDays;
    private final DateTimeZone timeZone;
    private final boolean pncOrders;
    private final DynamicCapability quoteRequests = new DynamicCapability("guisettings/overrides/dynamic/suppress-order-request-overrides.json");
    private final boolean localExchange;
    private final DynamicCapability openCloseIndicator = new DynamicCapability("guisettings/overrides/dynamic/suppress-open-close-indicator-overrides.json");
    private final DynamicCapability tradingLimit = new DynamicCapability("guisettings/overrides/dynamic/suppress-trading-limit-overrides.json");
    private final DynamicCapability settlement = new DynamicCapability("guisettings/overrides/dynamic/suppress-settlement-overrides.json");
    private final boolean settlementInfoForTrader;
    private final DynamicCapability locations = new DynamicCapability("guisettings/overrides/dynamic/suppress-locations-overrides.json");
    private int maxOrders;
    private Set<String> allowedClearingAccountTypes;

    private SystemInfo(Builder builder) {
        this.requestLimit = builder.requestLimit;
        this.backendVersion = builder.backendVersion;
        this.currentComtraderVersion = builder.currentComtraderVersion;
        this.contractStoreTimeInDays = builder.contractStoreTimeInDays;
        this.timeZone = builder.timezone;
        this.pncOrders = builder.pncOrders;
        this.quoteRequests.setEnabled(builder.quoteRequests);
        this.localExchange = builder.localExchange;
        this.openCloseIndicator.setEnabled(builder.openCloseIndicator);
        this.tradingLimit.setEnabled(builder.tradingLimit);
        this.settlement.setEnabled(builder.settlement);
        this.settlementInfoForTrader = builder.settlementInfoForTrader;
        this.locations.setEnabled(builder.locations);
        this.maxOrders = builder.maxOrders;
        this.allowedClearingAccountTypes = builder.allowedClearingAccountTypes;
    }

    protected SystemInfo() {
        this.requestLimit = Integer.MAX_VALUE;
        this.backendVersion = "";
        this.currentComtraderVersion = "";
        this.contractStoreTimeInDays = 0;
        this.timeZone = DateTimeZone.forID("UTC");
        this.pncOrders = false;
        this.quoteRequests.setEnabled(false);
        this.localExchange = false;
        this.openCloseIndicator.setEnabled(false);
        this.tradingLimit.setEnabled(false);
        this.settlement.setEnabled(false);
        this.settlementInfoForTrader = false;
        this.locations.setEnabled(false);
        this.maxOrders = 0;
        this.allowedClearingAccountTypes = new TreeSet<String>();
    }

    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    public int getRequestLimit() {
        return this.requestLimit;
    }

    public String getBackendVersion() {
        return this.backendVersion;
    }

    public String getCurrentComtraderVersion() {
        return this.currentComtraderVersion;
    }

    public int getContractStoreTimeInDays() {
        return this.contractStoreTimeInDays;
    }

    public boolean supportsPncOrders() {
        return this.pncOrders;
    }

    public boolean supportsQuoteRequests() {
        return this.quoteRequests.isEnabled();
    }

    public boolean isLocalExchange() {
        return this.localExchange;
    }

    public boolean supportsOpenCloseIndicator() {
        return this.openCloseIndicator.isEnabled();
    }

    public boolean supportsTradingLimit() {
        return this.tradingLimit.isEnabled();
    }

    public boolean supportsSettlement() {
        return this.settlement.isEnabled();
    }

    public boolean supportsSettlementInfoForTrader() {
        return this.settlementInfoForTrader;
    }

    public boolean supportsLocations() {
        return this.locations.isEnabled();
    }

    public int getMaxOrders() {
        return this.maxOrders;
    }

    public Set<String> getAllowedClearingAccountTypes() {
        return this.allowedClearingAccountTypes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public List<String> getOverridePath() {
        ArrayList<String> paths = new ArrayList<String>();
        for (Field f : this.getClass().getDeclaredFields()) {
            if (f.getType() != DynamicCapability.class) continue;
            try {
                DynamicCapability capability = (DynamicCapability)f.get(this);
                if (capability.isEnabled()) continue;
                paths.add(capability.getOverrideJsonFilePath());
            }
            catch (IllegalAccessException e) {
                LOG.error("Error reading dynamic capability.", e);
            }
        }
        return paths;
    }

    private static class DynamicCapability {
        private boolean enabled;
        private final String overrideJsonFilePath;

        public DynamicCapability(String overrideJsonFilePath) {
            this.overrideJsonFilePath = overrideJsonFilePath;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getOverrideJsonFilePath() {
            return this.overrideJsonFilePath;
        }
    }

    public static final class Builder {
        private int requestLimit;
        private String backendVersion;
        private String currentComtraderVersion;
        private int contractStoreTimeInDays;
        private DateTimeZone timezone;
        private boolean pncOrders = false;
        private boolean quoteRequests = false;
        private boolean localExchange = false;
        private boolean openCloseIndicator = false;
        private boolean tradingLimit = false;
        private boolean settlement = false;
        private boolean settlementInfoForTrader = false;
        private boolean locations = false;
        private int maxOrders;
        private Set<String> allowedClearingAccountTypes;

        public Builder withRequestLimit(int requestLimit) {
            this.requestLimit = requestLimit;
            return this;
        }

        public Builder withBackendVersion(String backendVersion) {
            this.backendVersion = backendVersion;
            return this;
        }

        public Builder withCurrentComtraderVersion(String currentComtraderVersion) {
            this.currentComtraderVersion = currentComtraderVersion;
            return this;
        }

        public Builder withContractStoreTimeInDays(int contractStoreTimeInDays) {
            this.contractStoreTimeInDays = contractStoreTimeInDays;
            return this;
        }

        public Builder withTimeZone(DateTimeZone timeZone) {
            this.timezone = timeZone;
            return this;
        }

        public Builder withPncOrders() {
            this.pncOrders = true;
            return this;
        }

        public Builder withQuoteRequests() {
            this.quoteRequests = true;
            return this;
        }

        public Builder withLocalExchange() {
            this.localExchange = true;
            return this;
        }

        public Builder withOpenCloseIndicator() {
            this.openCloseIndicator = true;
            return this;
        }

        public Builder withTradingLimit() {
            this.tradingLimit = true;
            return this;
        }

        public Builder withSettlement() {
            this.settlement = true;
            return this;
        }

        public Builder withSettlementInfoForTrader() {
            this.settlementInfoForTrader = true;
            return this;
        }

        public Builder withLocations() {
            this.locations = true;
            return this;
        }

        public Builder withMaxOrders(int maxOrders) {
            this.maxOrders = maxOrders;
            return this;
        }

        public Builder withAllowedClearingAccountTypes(String allowedClearingAccountTypes) {
            String[] accounts = allowedClearingAccountTypes.split(",");
            this.allowedClearingAccountTypes = new TreeSet<String>(Arrays.asList(accounts));
            return this;
        }

        public SystemInfo build() {
            return new SystemInfo(this);
        }
    }
}

