/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.datamodel.SmallFastDataModelBase;
import com.deutscheboerse.comxerv.comtrader.entities.AtcId;
import com.deutscheboerse.comxerv.comtrader.entities.HubToHub;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import java.util.function.Predicate;
import org.joda.time.DateTime;

public class HubToHubDataModel
extends SmallFastDataModelBase<AtcId, HubToHub> {
    protected static final int H2H_RETENTION_HOURS = 2;

    public HubToHubDataModel(ApplicationContext applicationContext) {
        super(applicationContext);
    }

    @Override
    public Class<HubToHub> getEntityClass() {
        return HubToHub.class;
    }

    @Override
    public void runCleanup() {
        this.removeIf(this.removePredicate());
    }

    private Predicate<HubToHub> removePredicate() {
        DateTime serverTime = this.appContext.getService(TimeService.class).getServerTime();
        return hubToHub -> hubToHub.getDeliveryPeriod().getEnd().isBefore(serverTime.minusHours(2));
    }

    @Override
    public HubToHub add(HubToHub hubToHub) {
        if (this.removePredicate().test(hubToHub)) {
            return null;
        }
        HubToHub oldHubToHub = (HubToHub)this.findById((AtcId)hubToHub.getId());
        if (oldHubToHub != null) {
            oldHubToHub.merge(hubToHub);
            return oldHubToHub;
        }
        return super.add(hubToHub);
    }
}

