/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.datamodel.query;

import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataQuery;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.datamodel.mapdb.Pair;
import com.deutscheboerse.comxerv.comtrader.datamodel.mapdb.Utils;
import com.deutscheboerse.comxerv.comtrader.datamodel.query.AbstractDataQuery;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class LargeDataModelRangeQuery<I extends Comparable<I>, T extends BroadcastEntity<I>, K2 extends Comparable<?>>
extends AbstractDataQuery<T> {
    private final NavigableSet<Pair<K2, I>> index;
    private final Function<I, T> entitySupplier;
    private final Interval<K2> interval;
    private final boolean distinct;

    public LargeDataModelRangeQuery(Function<I, T> entitySupplier, NavigableSet<Pair<K2, I>> index, Interval<K2> interval, boolean distinct2) {
        this(entitySupplier, index, interval, distinct2, i -> true);
    }

    private LargeDataModelRangeQuery(Function<I, T> entitySupplier, NavigableSet<Pair<K2, I>> index, Interval<K2> interval, boolean distinct2, Predicate<T> filter) {
        super(filter);
        this.index = index;
        this.entitySupplier = entitySupplier;
        this.interval = interval;
        this.distinct = distinct2;
    }

    @Override
    protected DataQuery<T> newInstance(Predicate<T> filter) {
        return new LargeDataModelRangeQuery<I, T, K2>(this.entitySupplier, this.index, this.interval, this.distinct, filter);
    }

    @Override
    public Stream<T> getAll() {
        return (this.distinct ? this.idsAsDistinctStream() : this.idsAsStream()).map(this.entitySupplier).filter(Objects::nonNull).filter(this.getFilter());
    }

    @Override
    public Optional<T> getFirst() {
        return this.getAll().findFirst();
    }

    private Stream<I> idsAsDistinctStream() {
        return this.idsAsStream().distinct();
    }

    private Stream<I> idsAsStream() {
        return StreamSupport.stream(Utils.filter(this.index, this.interval.low, this.interval.lowInclusive, this.interval.high, this.interval.highInclusive).spliterator(), false);
    }

    public static class Interval<V extends Comparable<?>> {
        private final V low;
        private final boolean lowInclusive;
        private final V high;
        private final boolean highInclusive;

        private Interval(V low, boolean lowInclusive, V high, boolean highInclusive) {
            this.low = low;
            this.lowInclusive = lowInclusive;
            this.high = high;
            this.highInclusive = highInclusive;
        }

        public static <V extends Comparable<?>> Interval<V> of(V low, boolean lowInclusive, V high, boolean highInclusive) {
            return new Interval<V>(low, lowInclusive, high, highInclusive);
        }
    }
}

