/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractPhase;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractStatus;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.binding.ObservableBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInterval;

public class CompoundStatus {
    private final ObjectProperty<ContractStatus> contractStatus = new SimpleObjectProperty<ContractStatus>();
    private final ObjectProperty<ContractPhase> tradingPhase = new SimpleObjectProperty<ContractPhase>();
    private final Map<DeliveryArea, DeliveryAreaInfo> deliveryAreaInfos = new HashMap<DeliveryArea, DeliveryAreaInfo>();
    private final ObservableBase invalidator = new ObservableBase();
    private final DependentBinding<ContractPhase> tradingPhaseDependentBinding = DependentBinding.get(this.tradingPhase::get, this.invalidator);
    private final DependentBinding<ContractStatus> contractStatusDependentBinding = DependentBinding.get(this.contractStatus::get, this.invalidator);

    public ContractStatus getContractStatus() {
        return (ContractStatus)this.contractStatus.get();
    }

    public ObservableValue<ContractStatus> contractStatusProperty() {
        return this.contractStatusDependentBinding;
    }

    public void setContractStatus(ContractStatus contractStatus) {
        this.contractStatus.set(contractStatus);
        this.invalidator.invalidate();
    }

    public ContractPhase getTradingPhase() {
        return (ContractPhase)this.tradingPhase.get();
    }

    public ObservableValue<ContractPhase> tradingPhaseProperty() {
        return this.tradingPhaseDependentBinding;
    }

    public void setTradingPhase(ContractPhase tradingPhase) {
        this.tradingPhase.set(tradingPhase);
        this.invalidator.invalidate();
    }

    public void setDeliveryAreaInfo(DeliveryArea deliveryArea, DeliveryAreaInfo deliveryAreaInfo) {
        this.deliveryAreaInfos.put(deliveryArea, deliveryAreaInfo);
        this.invalidator.invalidate();
    }

    public DateTime getLastTradeEnd() {
        Optional<DateTime> max = this.deliveryAreaInfos.values().stream().map(DeliveryAreaInfo::getActivePeriod).filter(Objects::nonNull).map(AbstractInterval::getEnd).max((o1, o2) -> o1.compareTo((ReadableInstant)o2));
        return max.isPresent() ? max.get() : null;
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        this.deliveryAreaInfos.keySet().stream().sorted((da1, da2) -> ((String)da1.getId()).compareTo((String)da2.getId())).forEach(da -> sb.append(da.getName()).append(": ").append(this.getDeliveryAreaPhase((DeliveryArea)da).getDisplayName()).append(System.lineSeparator()));
        return sb.toString();
    }

    public ObservableValue<String> descriptionProperty() {
        return DependentBinding.get(this::getDescription, this.invalidator);
    }

    public ContractStatus getDeliveryAreaStatusOrContractStatus(DeliveryArea deliveryArea) {
        DeliveryAreaInfo daInfo = this.deliveryAreaInfos.get(deliveryArea);
        if (daInfo == null) {
            return this.getContractStatus();
        }
        ContractStatus daStatus = daInfo.getDeliveryAreaStatus();
        if (daStatus == null || daStatus.ordinal() < this.getContractStatus().ordinal()) {
            return this.getContractStatus();
        }
        return daStatus;
    }

    public ContractStatus getDeliveryAreaStatusOrInactive(DeliveryArea deliveryArea) {
        DeliveryAreaInfo daInfo = this.deliveryAreaInfos.get(deliveryArea);
        if (daInfo == null) {
            return ContractStatus.IACT;
        }
        ContractStatus daStatus = daInfo.getDeliveryAreaStatus();
        if (daStatus == null || daStatus.ordinal() < this.getContractStatus().ordinal()) {
            return this.getContractStatus();
        }
        return daStatus;
    }

    public ContractPhase getDeliveryAreaPhase(DeliveryArea deliveryArea) {
        if (this.getDeliveryAreaStatusOrContractStatus(deliveryArea) != ContractStatus.ACTI) {
            return ContractPhase.CLSD;
        }
        DeliveryAreaInfo daInfo = this.deliveryAreaInfos.get(deliveryArea);
        return daInfo == null || daInfo.getTradingPhase() == null ? this.getTradingPhase() : daInfo.getTradingPhase();
    }

    public ObservableValue<ContractPhase> deliveryAreaPhaseProperty(DeliveryArea deliveryArea) {
        return DependentBinding.get(() -> this.getDeliveryAreaPhase(deliveryArea), this.invalidator);
    }

    public ObservableValue<ContractStatus> deliveryAreaStatusProperty(DeliveryArea deliveryArea) {
        return DependentBinding.get(() -> this.getDeliveryAreaStatusOrContractStatus(deliveryArea), this.invalidator);
    }

    public Interval getActivePeriod(DeliveryArea deliveryArea) {
        DeliveryAreaInfo deliveryAreaInfo = this.deliveryAreaInfos.get(deliveryArea);
        if (deliveryAreaInfo != null) {
            return deliveryAreaInfo.getActivePeriod();
        }
        return null;
    }

    public List<DeliveryArea> getDeliveryAreas() {
        return new ArrayList<DeliveryArea>(this.deliveryAreaInfos.keySet());
    }

    public String toLongString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompoundStatus{");
        sb.append("contractStatus=").append(this.getContractStatus()).append(", ");
        sb.append("tradingPhase=").append(this.getTradingPhase()).append(", ");
        sb.append("deliveryAreaInfos={");
        this.deliveryAreaInfos.keySet().stream().sorted((da1, da2) -> ((String)da1.getId()).compareTo((String)da2.getId())).forEach(da -> {
            sb.append("{").append(da.getName()).append(": ");
            sb.append(this.getDeliveryAreaStatusOrContractStatus((DeliveryArea)da)).append(", ");
            sb.append(this.getDeliveryAreaPhase((DeliveryArea)da)).append(", ");
            Interval activePeriod = this.getActivePeriod((DeliveryArea)da);
            if (activePeriod == null) {
                sb.append("null");
            } else {
                sb.append("(").append(activePeriod.getStart().getMillis()).append(", ").append(activePeriod.getEnd().getMillis()).append(")");
            }
            sb.append("}");
        });
        sb.append("}}");
        return sb.toString();
    }

    public void merge(CompoundStatus other) {
        this.contractStatus.set(other.getContractStatus());
        this.tradingPhase.set(other.getTradingPhase());
        this.deliveryAreaInfos.clear();
        this.deliveryAreaInfos.putAll(other.deliveryAreaInfos);
        this.invalidator.invalidate();
    }

    public static class DeliveryAreaInfo {
        private final ContractStatus deliveryAreaStatus;
        private final ContractPhase tradingPhase;
        private final Interval activePeriod;

        public DeliveryAreaInfo(ContractStatus deliveryAreaStatus, ContractPhase tradingPhase, Interval activePeriod) {
            this.deliveryAreaStatus = deliveryAreaStatus;
            this.tradingPhase = tradingPhase;
            this.activePeriod = activePeriod;
        }

        public Interval getActivePeriod() {
            return this.activePeriod;
        }

        public ContractStatus getDeliveryAreaStatus() {
            return this.deliveryAreaStatus;
        }

        public ContractPhase getTradingPhase() {
            return this.tradingPhase;
        }
    }
}

