/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.entities.Mergeable;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.entities.TradeInfo;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;

public class HalfTrade
extends Trade
implements Mergeable<HalfTrade> {
    private Trade.OrderInfo order;
    private Long tradeId;
    private Direction direction;
    private long halfTradeRevision;
    private boolean dirty = true;

    public HalfTrade() {
        this.tradeId = null;
        this.direction = null;
    }

    public HalfTrade(long tradeId, Direction direction, TradeInfo tradeInfo) {
        super(HalfTrade.getHalfTradeId(tradeId, direction), tradeInfo);
        this.tradeId = tradeId;
        this.direction = direction;
    }

    public HalfTrade(HalfTrade other) {
        super(other);
        this.tradeId = other.getTradeId();
        this.direction = null;
        this.halfTradeRevision = other.halfTradeRevision;
        this.dirty = other.dirty;
        this.setOrder(other.getOrder());
    }

    @Override
    public boolean isParentOf(Trade childTrade) {
        return super.isParentOf(childTrade) && this.getDirection() == ((HalfTrade)childTrade).getDirection();
    }

    public Trade.OrderInfo getOrder() {
        return this.order;
    }

    public void setOrder(Trade.OrderInfo order) {
        this.order = order;
        this.direction = order != null ? order.getDirection() : null;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public String getMemberId() {
        return this.order.getMemberCode();
    }

    public String getTraderId() {
        return this.order.getTraderUserCode();
    }

    @Override
    public Long getTradeId() {
        return this.tradeId;
    }

    public void setTradeId(Long tradeId) {
        this.tradeId = tradeId;
    }

    @Override
    public long getRevisionNumber() {
        return this.halfTradeRevision;
    }

    @Override
    public void setRevisionNumber(long revisionNumber) {
        this.halfTradeRevision = revisionNumber;
    }

    @Override
    public Class<HalfTrade> getEntityClass() {
        return HalfTrade.class;
    }

    @Override
    public void merge(HalfTrade object) {
        super.mergeCommon(object);
    }

    public static long getHalfTradeId(long tradeId, Direction direction) {
        return tradeId * 10L + (long)direction.ordinal();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

