/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.core.entity.SmallDataModelEntity;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Mergeable;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.RevisionNumbered;
import com.deutscheboerse.comxerv.comtrader.entities.TimeStampProvider;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.AcceptOrRejectType;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ModificationType;
import com.deutscheboerse.comxerv.comtrader.entities.type.OpenOrClose;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValidityRestriction;
import java.util.UUID;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.joda.time.DateTime;

public class Order
extends BroadcastEntity<Long>
implements RevisionNumbered,
Comparable<Order>,
Mergeable<Order>,
TimeStampProvider,
SmallDataModelEntity {
    private final ObjectProperty<String> initialOrderId;
    private final ObjectProperty<String> clientOrderId;
    private final ObjectProperty<Contract> contract;
    private final ObjectProperty<DeliveryArea> deliveryArea;
    private final ObjectProperty<Direction> direction;
    private final ObjectProperty<OrderType> orderType;
    private final ObjectProperty<LongDisplayValue> limitPrice;
    private final ObjectProperty<LongDisplayValue> stopPrice;
    private final ObjectProperty<LongDisplayValue> remainingQuantity;
    private final ObjectProperty<LongDisplayValue> peakQuantity;
    private final ObjectProperty<LongDisplayValue> peakPriceDelta;
    private final ObjectProperty<LongDisplayValue> initialQuantity;
    private final ObjectProperty<LongDisplayValue> shownQuantity;
    private final ObjectProperty<ExecutionRestriction> executionRestriction;
    private final ObjectProperty<ValidityRestriction> validityRestriction;
    private final ObjectProperty<DateTime> validityDate;
    private final ObjectProperty<DateTime> extendedValidityDate;
    private final StringProperty account;
    private final ObjectProperty<OpenOrClose> openOrClose;
    private final ObjectProperty<BalancingGroup> balancingGroup;
    private final StringProperty memberCode;
    private final StringProperty traderUserCode;
    private final ObjectProperty<User> user;
    private final ObjectProperty<Integer> brokerUserId;
    private final ObjectProperty<User> onBehalfUser;
    private final ObjectProperty<AcceptOrRejectType> preArrangedAcceptOrReject;
    private final ObjectProperty<BalancingGroup> preArrangedBalancingGroup;
    private final StringProperty text;
    private final StringProperty location;
    private final ObjectProperty<Boolean> marketBased;
    private final StringProperty contractReference;
    private final StringProperty facilityType;
    private final ObjectProperty<Integer> usageFraction;
    private final ObjectProperty<OrderStatus> status;
    private final ObjectProperty<DateTime> timeStamp;
    private final ObjectProperty<DateTime> lastUpdateTimeStamp;
    private final StringProperty lastUpdateUser;
    private final LongProperty revisionNumber;
    private final BooleanProperty quote;
    private final StringProperty errorMessage;
    private final ObjectProperty<ModificationType> modificationType;
    private final ObjectProperty<Boolean> aot;
    private final ObjectProperty<Long> preAotId;

    public Order() {
        this.initialOrderId = new SimpleObjectProperty<String>();
        this.clientOrderId = new SimpleObjectProperty<String>(Order.generateNewClientOrderId());
        this.contract = new SimpleObjectProperty<Contract>();
        this.deliveryArea = new SimpleObjectProperty<DeliveryArea>();
        this.direction = new SimpleObjectProperty<Direction>(Direction.BUY);
        this.orderType = new SimpleObjectProperty<OrderType>();
        this.limitPrice = new SimpleObjectProperty<LongDisplayValue>();
        this.stopPrice = new SimpleObjectProperty<Object>(null);
        this.remainingQuantity = new SimpleObjectProperty<LongDisplayValue>();
        this.peakQuantity = new SimpleObjectProperty<Object>(null);
        this.peakPriceDelta = new SimpleObjectProperty<Object>(null);
        this.initialQuantity = new SimpleObjectProperty<Object>(null);
        this.shownQuantity = new SimpleObjectProperty<LongDisplayValue>();
        this.executionRestriction = new SimpleObjectProperty<ExecutionRestriction>();
        this.validityRestriction = new SimpleObjectProperty<ValidityRestriction>();
        this.validityDate = new SimpleObjectProperty<DateTime>();
        this.extendedValidityDate = new SimpleObjectProperty<DateTime>();
        this.account = new SimpleStringProperty();
        this.openOrClose = new SimpleObjectProperty<OpenOrClose>();
        this.balancingGroup = new SimpleObjectProperty<Object>(null);
        this.memberCode = new SimpleStringProperty();
        this.traderUserCode = new SimpleStringProperty();
        this.user = new SimpleObjectProperty<User>();
        this.brokerUserId = new SimpleObjectProperty<Integer>();
        this.onBehalfUser = new SimpleObjectProperty<User>();
        this.preArrangedBalancingGroup = new SimpleObjectProperty<BalancingGroup>();
        this.preArrangedAcceptOrReject = new SimpleObjectProperty<AcceptOrRejectType>();
        this.text = new SimpleStringProperty();
        this.location = new SimpleStringProperty();
        this.marketBased = new SimpleObjectProperty<Boolean>();
        this.contractReference = new SimpleStringProperty();
        this.facilityType = new SimpleStringProperty();
        this.usageFraction = new SimpleObjectProperty<Integer>();
        this.status = new SimpleObjectProperty<OrderStatus>();
        this.timeStamp = new SimpleObjectProperty<DateTime>();
        this.lastUpdateTimeStamp = new SimpleObjectProperty<DateTime>();
        this.lastUpdateUser = new SimpleStringProperty();
        this.revisionNumber = new SimpleLongProperty();
        this.quote = new SimpleBooleanProperty();
        this.errorMessage = new SimpleStringProperty();
        this.modificationType = new SimpleObjectProperty<ModificationType>();
        this.preAotId = new SimpleObjectProperty<Long>();
        this.aot = new SimpleObjectProperty<Boolean>();
    }

    public Order(Order original) {
        super(original);
        this.initialOrderId = new SimpleObjectProperty<String>(original.getInitialOrderId());
        this.clientOrderId = new SimpleObjectProperty<String>(original.getClientOrderId());
        this.contract = new SimpleObjectProperty<Contract>(original.getContract());
        this.deliveryArea = new SimpleObjectProperty<DeliveryArea>(original.getDeliveryArea());
        this.direction = new SimpleObjectProperty<Direction>(original.getDirection());
        this.orderType = new SimpleObjectProperty<OrderType>(original.getOrderType());
        this.limitPrice = new SimpleObjectProperty<LongDisplayValue>(original.getLimitPrice());
        this.stopPrice = new SimpleObjectProperty<LongDisplayValue>(original.getStopPrice());
        this.remainingQuantity = new SimpleObjectProperty<LongDisplayValue>(original.getRemainingQuantity());
        this.peakQuantity = new SimpleObjectProperty<LongDisplayValue>(original.getPeakQuantity());
        this.peakPriceDelta = new SimpleObjectProperty<LongDisplayValue>(original.getPeakPriceDelta());
        this.initialQuantity = new SimpleObjectProperty<LongDisplayValue>(original.getInitialQuantity());
        this.shownQuantity = new SimpleObjectProperty<LongDisplayValue>(original.getShownQuantity());
        this.executionRestriction = new SimpleObjectProperty<ExecutionRestriction>(original.getExecutionRestriction());
        this.validityRestriction = new SimpleObjectProperty<ValidityRestriction>(original.getValidityRestriction());
        this.validityDate = new SimpleObjectProperty<DateTime>(original.getValidityDate());
        this.extendedValidityDate = new SimpleObjectProperty<DateTime>(original.getExtendedValidityDate());
        this.account = new SimpleStringProperty(original.getAccount());
        this.openOrClose = new SimpleObjectProperty<OpenOrClose>(original.getOpenOrClose());
        this.balancingGroup = new SimpleObjectProperty<BalancingGroup>(original.getBalancingGroup());
        this.memberCode = new SimpleStringProperty(original.getMemberCode());
        this.traderUserCode = new SimpleStringProperty(original.getTraderUserCode());
        this.user = new SimpleObjectProperty<User>(original.getUser());
        this.brokerUserId = new SimpleObjectProperty<Integer>(original.getBrokerUserId());
        this.onBehalfUser = new SimpleObjectProperty<User>(original.getOnBehalfUser());
        this.preArrangedBalancingGroup = new SimpleObjectProperty<BalancingGroup>(original.getPreArrangedBalancingGroup());
        this.preArrangedAcceptOrReject = new SimpleObjectProperty<AcceptOrRejectType>(original.getPreArrangedAcceptOrReject());
        this.text = new SimpleStringProperty(original.getText());
        this.location = new SimpleStringProperty(original.getLocation());
        this.marketBased = new SimpleObjectProperty<Boolean>(original.isMarketBased());
        this.contractReference = new SimpleStringProperty(original.getContractReference());
        this.facilityType = new SimpleStringProperty(original.getFacilityType());
        this.usageFraction = new SimpleObjectProperty<Integer>(original.getUsageFraction());
        this.status = new SimpleObjectProperty<OrderStatus>(original.getStatus());
        this.timeStamp = new SimpleObjectProperty<DateTime>(original.getTimeStamp());
        this.lastUpdateTimeStamp = new SimpleObjectProperty<DateTime>(original.getLastUpdateTimeStamp());
        this.lastUpdateUser = new SimpleStringProperty(original.getLastUpdateUser());
        this.revisionNumber = new SimpleLongProperty(original.getRevisionNumber());
        this.quote = new SimpleBooleanProperty(original.isQuote());
        this.errorMessage = new SimpleStringProperty(original.getErrorMessage());
        this.modificationType = new SimpleObjectProperty<ModificationType>(original.getModificationType());
        this.preAotId = new SimpleObjectProperty<Long>(original.getPreAotId());
        this.aot = new SimpleObjectProperty<Boolean>(original.getAot());
    }

    public void initNewClientOrderId() {
        this.setClientOrderId(Order.generateNewClientOrderId());
    }

    private static String generateNewClientOrderId() {
        return UUID.randomUUID().toString();
    }

    public Exchange getExchange() {
        return this.getContract() != null ? this.getContract().getExchange() : null;
    }

    public ObjectProperty<String> initialOrderIdProperty() {
        return this.initialOrderId;
    }

    public ObjectProperty<OpenOrClose> openOrCloseProperty() {
        return this.openOrClose;
    }

    public ObjectProperty<BalancingGroup> balancingGroupProperty() {
        return this.balancingGroup;
    }

    public ObjectProperty<OrderType> orderTypeProperty() {
        return this.orderType;
    }

    public ObjectProperty<Direction> directionProperty() {
        return this.direction;
    }

    public ObjectProperty<DeliveryArea> deliveryAreaProperty() {
        return this.deliveryArea;
    }

    public ObjectProperty<Contract> contractProperty() {
        return this.contract;
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public StringProperty locationProperty() {
        return this.location;
    }

    public ObjectProperty<Boolean> marketBasedProperty() {
        return this.marketBased;
    }

    public StringProperty contractReferenceProperty() {
        return this.contractReference;
    }

    public StringProperty facilityTypeProperty() {
        return this.facilityType;
    }

    public ObjectProperty<Integer> usageFractionProperty() {
        return this.usageFraction;
    }

    public StringProperty accountProperty() {
        return this.account;
    }

    public ObjectProperty<OrderStatus> statusProperty() {
        return this.status;
    }

    public ObjectProperty<DateTime> timeStampProperty() {
        return this.timeStamp;
    }

    public ObjectProperty<DateTime> lastUpdateTimeStampProperty() {
        return this.lastUpdateTimeStamp;
    }

    public StringProperty lastUpdateUserProperty() {
        return this.lastUpdateUser;
    }

    public StringProperty memberCodeProperty() {
        return this.memberCode;
    }

    public StringProperty traderUserCodeProperty() {
        return this.traderUserCode;
    }

    public User getUser() {
        return (User)this.user.get();
    }

    public void setUser(User user) {
        this.user.set(user);
    }

    public ObjectProperty<User> userProperty() {
        return this.user;
    }

    public Integer getBrokerUserId() {
        return (Integer)this.brokerUserId.get();
    }

    public void setBrokerUserId(Integer userId) {
        this.brokerUserId.set(userId);
    }

    public ObjectProperty<Integer> brokerUserIdProperty() {
        return this.brokerUserId;
    }

    public User getOnBehalfUser() {
        return (User)this.onBehalfUser.get();
    }

    public ObjectProperty<User> onBehalfUserProperty() {
        return this.onBehalfUser;
    }

    public void setOnBehalfUser(User onBehalfUser) {
        this.onBehalfUser.set(onBehalfUser);
    }

    public AcceptOrRejectType getPreArrangedAcceptOrReject() {
        return (AcceptOrRejectType)((Object)this.preArrangedAcceptOrReject.get());
    }

    public void setPreArrangedAcceptOrReject(AcceptOrRejectType preArrangedAcceptOrReject) {
        this.preArrangedAcceptOrReject.set(preArrangedAcceptOrReject);
    }

    public ObjectProperty<AcceptOrRejectType> preArrangedAcceptOrRejectProperty() {
        return this.preArrangedAcceptOrReject;
    }

    public LongProperty revisionNumberProperty() {
        return this.revisionNumber;
    }

    public ObjectProperty<BalancingGroup> preArrangedBalancingGroupProperty() {
        return this.preArrangedBalancingGroup;
    }

    public ObjectProperty<DateTime> validityDateProperty() {
        return this.validityDate;
    }

    public ObjectProperty<ValidityRestriction> validityRestrictionProperty() {
        return this.validityRestriction;
    }

    public ObjectProperty<LongDisplayValue> initialQuantityProperty() {
        return this.initialQuantity;
    }

    public ObjectProperty<LongDisplayValue> peakQuantityProperty() {
        return this.peakQuantity;
    }

    public ObjectProperty<LongDisplayValue> peakPriceDeltaProperty() {
        return this.peakPriceDelta;
    }

    public ObjectProperty<LongDisplayValue> shownQuantityProperty() {
        return this.shownQuantity;
    }

    public LongDisplayValue getShownQuantity() {
        return (LongDisplayValue)this.shownQuantity.get();
    }

    public void setShownQuantity(LongDisplayValue shownQuantity) {
        this.shownQuantity.set(shownQuantity);
    }

    public ValidityRestriction getValidityRestriction() {
        return (ValidityRestriction)this.validityRestriction.get();
    }

    public void setValidityRestriction(ValidityRestriction validityRestriction) {
        this.validityRestriction.set(validityRestriction);
    }

    public DateTime getValidityDate() {
        return (DateTime)this.validityDate.get();
    }

    public void setValidityDate(DateTime validityDate) {
        this.validityDate.set(validityDate);
    }

    public String getPreArrangedBalancingGroupId() {
        return this.getPreArrangedBalancingGroup() != null ? (String)this.getPreArrangedBalancingGroup().getId() : null;
    }

    public BalancingGroup getPreArrangedBalancingGroup() {
        return (BalancingGroup)this.preArrangedBalancingGroup.get();
    }

    public void setPreArrangedBalancingGroup(BalancingGroup preArrangedBalancingGroup) {
        this.preArrangedBalancingGroup.set(preArrangedBalancingGroup);
    }

    @Override
    public Class<Order> getEntityClass() {
        return Order.class;
    }

    public Contract getContract() {
        return (Contract)this.contract.get();
    }

    public void setContract(Contract contract) {
        this.contract.set(contract);
    }

    public Product getProduct() {
        return this.contract.get() != null ? ((Contract)this.contract.get()).getProduct() : null;
    }

    public OpenOrClose getOpenOrClose() {
        return (OpenOrClose)this.openOrClose.get();
    }

    public void setOpenOrClose(OpenOrClose openOrClose) {
        this.openOrClose.set(openOrClose);
    }

    public String getInitialOrderId() {
        return (String)this.initialOrderId.get();
    }

    public void setInitialOrderId(String initialOrderId) {
        this.initialOrderId.set(initialOrderId);
    }

    public String getBalancingGroupId() {
        return this.getBalancingGroup() != null ? (String)this.getBalancingGroup().getId() : null;
    }

    public BalancingGroup getBalancingGroup() {
        return (BalancingGroup)this.balancingGroup.get();
    }

    public void setBalancingGroup(BalancingGroup balancingGroup) {
        this.balancingGroup.set(balancingGroup);
    }

    public Direction getDirection() {
        return (Direction)this.direction.get();
    }

    public void setDirection(Direction direction) {
        this.direction.set(direction);
    }

    public Long getContractId() {
        return this.getContract() != null ? (Long)this.getContract().getId() : null;
    }

    public String getDeliveryAreaId() {
        return this.getDeliveryArea() != null ? (String)this.getDeliveryArea().getId() : null;
    }

    public DeliveryArea getDeliveryArea() {
        return (DeliveryArea)this.deliveryArea.get();
    }

    public void setDeliveryArea(DeliveryArea deliveryArea) {
        this.deliveryArea.set(deliveryArea);
    }

    public LongDisplayValue getLimitPrice() {
        return (LongDisplayValue)this.limitPrice.get();
    }

    public void setLimitPrice(LongDisplayValue limitPrice) {
        this.limitPrice.set(limitPrice);
    }

    public ObjectProperty<LongDisplayValue> limitPriceProperty() {
        return this.limitPrice;
    }

    public LongDisplayValue getStopPrice() {
        return (LongDisplayValue)this.stopPrice.get();
    }

    public void setStopPrice(LongDisplayValue stopPrice) {
        this.stopPrice.set(stopPrice);
    }

    public ObjectProperty<LongDisplayValue> stopPriceProperty() {
        return this.stopPrice;
    }

    public LongDisplayValue getRemainingQuantity() {
        return (LongDisplayValue)this.remainingQuantity.get();
    }

    public void setRemainingQuantity(LongDisplayValue remainingQuantity) {
        this.remainingQuantity.set(remainingQuantity);
    }

    public ObjectProperty<LongDisplayValue> remainingQuantityProperty() {
        return this.remainingQuantity;
    }

    public String getText() {
        return (String)this.text.get();
    }

    public void setText(String text) {
        this.text.set(text);
    }

    public String getLocation() {
        return (String)this.location.get();
    }

    public void setLocation(String location) {
        this.location.set(location);
    }

    public Boolean isMarketBased() {
        return (Boolean)this.marketBased.get();
    }

    public void setMarketBased(Boolean marketBased) {
        this.marketBased.set(marketBased);
    }

    public String getContractReference() {
        return (String)this.contractReference.get();
    }

    public void setContractReference(String contractReference) {
        this.contractReference.set(contractReference);
    }

    public String getFacilityType() {
        return (String)this.facilityType.get();
    }

    public void setFacilityType(String facilityType) {
        this.facilityType.set(facilityType);
    }

    public Integer getUsageFraction() {
        return (Integer)this.usageFraction.get();
    }

    public void setUsageFraction(Integer usageFraction) {
        this.usageFraction.set(usageFraction);
    }

    public ExecutionRestriction getExecutionRestriction() {
        return (ExecutionRestriction)this.executionRestriction.get();
    }

    public void setExecutionRestriction(ExecutionRestriction executionRestriction) {
        this.executionRestriction.set(executionRestriction);
    }

    public ObjectProperty<ExecutionRestriction> executionRestrictionProperty() {
        return this.executionRestriction;
    }

    public DateTime getExtendedValidityDate() {
        return (DateTime)this.extendedValidityDate.get();
    }

    public ObjectProperty<DateTime> extendedValidityDateProperty() {
        return this.extendedValidityDate;
    }

    public void setExtendedValidityDate(DateTime extendedValidityDate) {
        this.extendedValidityDate.set(extendedValidityDate);
    }

    public String getAccount() {
        return (String)this.account.get();
    }

    public void setAccount(String account) {
        this.account.set(account);
    }

    public OrderStatus getStatus() {
        return (OrderStatus)this.status.get();
    }

    public void setStatus(OrderStatus status) {
        this.status.set(status);
    }

    public void setTimeStamp(DateTime timeStamp) {
        this.timeStamp.set(timeStamp);
    }

    public DateTime getLastUpdateTimeStamp() {
        return (DateTime)this.lastUpdateTimeStamp.get();
    }

    public void setLastUpdateTimeStamp(DateTime lastUpdateTimeStamp) {
        this.lastUpdateTimeStamp.set(lastUpdateTimeStamp);
    }

    public String getLastUpdateUser() {
        return (String)this.lastUpdateUser.get();
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser.set(lastUpdateUser);
    }

    @Override
    public long getRevisionNumber() {
        return this.revisionNumber.get();
    }

    public void setRevisionNumber(long revisionNumber) {
        this.revisionNumber.set(revisionNumber);
    }

    public String getMemberCode() {
        return (String)this.memberCode.get();
    }

    public void setMemberCode(String memberCode) {
        this.memberCode.set(memberCode);
    }

    public String getTraderUserCode() {
        return (String)this.traderUserCode.get();
    }

    public void setTraderUserCode(String traderUserCode) {
        this.traderUserCode.set(traderUserCode);
    }

    public LongDisplayValue getPeakQuantity() {
        return (LongDisplayValue)this.peakQuantity.get();
    }

    public void setPeakQuantity(LongDisplayValue peakQuantity) {
        this.peakQuantity.setValue(peakQuantity);
    }

    public LongDisplayValue getInitialQuantity() {
        return (LongDisplayValue)this.initialQuantity.get();
    }

    public void setInitialQuantity(LongDisplayValue initialQuantity) {
        this.initialQuantity.setValue(initialQuantity);
    }

    public OrderType getOrderType() {
        return (OrderType)this.orderType.get();
    }

    public void setOrderType(OrderType orderType) {
        this.orderType.set(orderType);
    }

    public String getClientOrderId() {
        return (String)this.clientOrderId.get();
    }

    public void setClientOrderId(String clientOrderId) {
        this.clientOrderId.set(clientOrderId);
    }

    public ObjectProperty<String> clientOrderIdProperty() {
        return this.clientOrderId;
    }

    public LongDisplayValue getPeakPriceDelta() {
        return (LongDisplayValue)this.peakPriceDelta.get();
    }

    public void setPeakPriceDelta(LongDisplayValue deltaPrice) {
        this.peakPriceDelta.setValue(deltaPrice);
    }

    public boolean isQuote() {
        return this.quote.get();
    }

    public BooleanProperty quoteProperty() {
        return this.quote;
    }

    public void setQuote(boolean quote) {
        this.quote.set(quote);
    }

    public String getErrorMessage() {
        return (String)this.errorMessage.get();
    }

    public StringProperty errorMessageProperty() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage.set(errorMessage);
    }

    public ModificationType getModificationType() {
        return (ModificationType)((Object)this.modificationType.get());
    }

    public ObjectProperty<ModificationType> modificationTypeProperty() {
        return this.modificationType;
    }

    public void setModificationType(ModificationType modificationType) {
        this.modificationType.set(modificationType);
    }

    public Long getPreAotId() {
        return (Long)this.preAotId.get();
    }

    public void setPreAotId(Long preAotId) {
        this.preAotId.set(preAotId);
    }

    public Boolean getAot() {
        return (Boolean)this.aot.get();
    }

    public ObjectProperty<Boolean> aotProperty() {
        return this.aot;
    }

    public void setAot(Boolean aot) {
        this.aot.set(aot);
    }

    @Override
    public void merge(Order other) {
        this.initialOrderId.set(other.getInitialOrderId());
        this.clientOrderId.set(other.getClientOrderId());
        this.contract.set(other.getContract());
        this.deliveryArea.set(other.getDeliveryArea());
        this.direction.set(other.getDirection());
        this.orderType.set(other.getOrderType());
        this.limitPrice.set(other.getLimitPrice());
        this.stopPrice.set(other.getStopPrice());
        this.remainingQuantity.set(other.getRemainingQuantity());
        this.peakQuantity.set(other.getPeakQuantity());
        if (!other.isQuote()) {
            this.initialQuantity.set(other.getInitialQuantity());
        }
        this.shownQuantity.setValue(other.getShownQuantity());
        this.executionRestriction.set(other.getExecutionRestriction());
        this.validityRestriction.set(other.getValidityRestriction());
        this.validityDate.set(other.getValidityDate());
        this.extendedValidityDate.set(other.getExtendedValidityDate());
        this.account.set(other.getAccount());
        this.openOrClose.set(other.getOpenOrClose());
        this.balancingGroup.set(other.getBalancingGroup());
        this.memberCode.set(other.getMemberCode());
        this.traderUserCode.set(other.getTraderUserCode());
        this.onBehalfUser.set(other.getOnBehalfUser());
        this.preArrangedBalancingGroup.set(other.getPreArrangedBalancingGroup());
        this.text.set(other.getText());
        this.location.set(other.getLocation());
        this.marketBased.set(other.isMarketBased());
        this.contractReference.set(other.getContractReference());
        this.facilityType.set(other.getFacilityType());
        this.usageFraction.set(other.getUsageFraction());
        this.status.set(other.getStatus());
        this.timeStamp.set(other.getTimeStamp());
        this.lastUpdateTimeStamp.set(other.getLastUpdateTimeStamp());
        this.lastUpdateUser.set(other.getLastUpdateUser());
        this.revisionNumber.set(other.getRevisionNumber());
        this.peakPriceDelta.set(other.getPeakPriceDelta());
        this.errorMessage.setValue(other.getErrorMessage());
        this.modificationType.setValue(other.getModificationType());
        this.preAotId.set(other.getPreAotId());
        this.aot.setValue(other.getAot());
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [id=" + String.valueOf(this.getId()) + ", initialOrderId=" + this.getInitialOrderId() + ", clientOrderId=" + this.getClientOrderId() + ", contractId=" + this.getContractId() + ", deliveryAreaId=" + this.getDeliveryAreaId() + ", direction=" + String.valueOf(this.getDirection()) + ", orderType=" + String.valueOf(this.getOrderType()) + ", limitPrice=" + String.valueOf(this.getLimitPrice() == null ? "null" : this.getLimitPrice().getDisplayValue()) + ", stopPrice=" + String.valueOf(this.getStopPrice() == null ? "null" : this.getStopPrice().getDisplayValue()) + ", quantity=" + String.valueOf(this.getRemainingQuantity() == null ? "null" : this.getRemainingQuantity().getDisplayValue()) + ", peakQuantity=" + String.valueOf(this.getPeakQuantity()) + ", peakPriceDelta=" + String.valueOf(this.getPeakPriceDelta()) + ", initialQuantity=" + String.valueOf(this.getInitialQuantity()) + ", shownQuantity=" + String.valueOf(this.getShownQuantity()) + ", executionRestriction=" + String.valueOf(this.getExecutionRestriction()) + ", validityRestriction=" + String.valueOf(this.getValidityRestriction()) + ", validityDate=" + String.valueOf(this.getValidityDate()) + ", extValidityDate=" + String.valueOf(this.getExtendedValidityDate()) + ", account=" + this.getAccount() + ", openOrClose=" + String.valueOf(this.getOpenOrClose()) + ", balancingGroupId=" + this.getBalancingGroupId() + ", memberCode=" + this.getMemberCode() + ", modificationType=" + String.valueOf((Object)this.getModificationType()) + ", traderUserCode=" + this.getTraderUserCode() + ", onBehalfUser" + String.valueOf(this.getOnBehalfUser()) + ", preArrangedBalancingGroupId=" + this.getPreArrangedBalancingGroupId() + ", text=" + this.getText() + ", location=" + this.getLocation() + ", marketBased=" + this.isMarketBased() + ", contractReference=" + this.getContractReference() + ", facilityType=" + this.getFacilityType() + ", usageFraction=" + this.getUsageFraction() + ", timeStamp=" + String.valueOf(this.getTimeStamp()) + ", lastUpdateTimeStamp=" + String.valueOf(this.getLastUpdateTimeStamp()) + ", lastUpdateUser=" + this.getLastUpdateUser() + ", status=" + String.valueOf(this.getStatus()) + ", revisionNumber=" + this.getRevisionNumber() + ", preAotId=" + this.getPreAotId() + ", aot=" + this.getAot() + "]";
    }

    @Override
    public int compareTo(Order order) {
        return ((Long)this.getId()).compareTo((Long)order.getId());
    }

    @Override
    public DateTime getTimeStamp() {
        return (DateTime)this.timeStamp.get();
    }
}

