/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import java.util.function.Consumer;

public class BatchedCounter {
    private final Consumer<Boolean> targetNonZeroProperty;
    private int entryCount;
    private boolean dirty;

    public BatchedCounter(Consumer<Boolean> targetNonZeroProperty) {
        this.targetNonZeroProperty = targetNonZeroProperty;
        this.entryCount = 0;
        this.dirty = false;
    }

    public void add() {
        ++this.entryCount;
        this.dirty = true;
    }

    public void remove() {
        --this.entryCount;
        this.dirty = true;
    }

    public void reset() {
        this.entryCount = 0;
        this.dirty = true;
    }

    public void set(int entryCount) {
        this.entryCount = entryCount;
        this.dirty = true;
    }

    public void flush() {
        if (this.dirty) {
            this.targetNonZeroProperty.accept(this.entryCount > 0);
            this.dirty = false;
        }
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public boolean isEmpty() {
        return this.entryCount == 0;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

