/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

class BatchedCumulativeQuantity {
    private final ObjectProperty<LongDisplayValue> targetQuantityProperty;
    private LongDisplayValue quantityInternal;
    private int entryCount;
    private boolean dirty;

    BatchedCumulativeQuantity(int quantityShift) {
        this(quantityShift, new SimpleObjectProperty<LongDisplayValue>(LongDisplayValue.toZero(quantityShift)));
    }

    BatchedCumulativeQuantity(int quantityShift, ObjectProperty<LongDisplayValue> targetQuantityProperty) {
        this.targetQuantityProperty = targetQuantityProperty;
        this.quantityInternal = LongDisplayValue.toZero(quantityShift);
        this.entryCount = 0;
        this.dirty = false;
    }

    public void add(LongDisplayValue delta) {
        this.quantityInternal = this.quantityInternal.add(delta.getDisplayValue());
        ++this.entryCount;
        this.dirty = true;
    }

    public void remove(LongDisplayValue delta) {
        this.quantityInternal = this.quantityInternal.subtract(delta.getDisplayValue());
        --this.entryCount;
        this.dirty = true;
    }

    public void reset() {
        this.quantityInternal = LongDisplayValue.toZero(this.quantityInternal.getShift());
        this.entryCount = 0;
        this.dirty = true;
    }

    public void flush() {
        if (this.dirty) {
            this.targetQuantityProperty.set(this.quantityInternal);
            this.dirty = false;
        }
    }

    public boolean isEmpty() {
        return this.entryCount == 0;
    }

    protected ReadOnlyObjectProperty<LongDisplayValue> targetQuantityProperty() {
        return this.targetQuantityProperty;
    }
}

