/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.CommonOrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryType;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.ui.jfx.util.binding.ConstantObservableValue;
import javafx.beans.value.ObservableValue;

public class EmptyOrderbookEntry
extends CommonOrderbookEntry {
    private final LongDisplayValue quantityZero;
    private final OrderbookEntryType orderbookEntryType;

    public static EmptyOrderbookEntry create(Orderbook orderbook, Direction direction, OrderbookEntryType orderbookEntryType) {
        LongDisplayValue quantityZero = new LongDisplayValue(0L, orderbook.getContract().getProduct().getQuantityDecimalShift());
        return new EmptyOrderbookEntry(orderbook, direction, null, quantityZero, orderbookEntryType);
    }

    private EmptyOrderbookEntry(Orderbook orderbook, Direction direction, LongDisplayValue priceZero, LongDisplayValue quantityZero, OrderbookEntryType orderbookEntryType) {
        super(0L, quantityZero, priceZero, quantityZero, priceZero, orderbook, direction, OrderType.REGULAR, false, false, false);
        this.quantityZero = quantityZero;
        this.orderbookEntryType = orderbookEntryType;
    }

    @Override
    public LongDisplayValue getTradableQuantity() {
        return this.quantityZero;
    }

    @Override
    public LongDisplayValue getOwnQuantity() {
        return this.quantityZero;
    }

    @Override
    public ObservableValue<LongDisplayValue> ownQuantityProperty() {
        return new ConstantObservableValue<LongDisplayValue>(this.quantityZero);
    }

    @Override
    public OrderbookEntryType getType() {
        return this.orderbookEntryType;
    }
}

