/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.orderbook.AbstractComputedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OutrightExtendedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OutrightPriceGroupedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;

public class LazyOrderbookEntries {
    private final Map<ComputedEntriesKey, WeakReference<AbstractComputedOrderbookEntries>> computedEntries = new EnumMap<ComputedEntriesKey, WeakReference<AbstractComputedOrderbookEntries>>(ComputedEntriesKey.class);

    public LazyOrderbookEntries() {
        this.initLazyEntries();
    }

    private void initLazyEntries() {
        this.initComputedEntries();
    }

    private void initComputedEntries() {
        for (ComputedEntriesKey key : ComputedEntriesKey.values()) {
            this.computedEntries.put(key, new WeakReference<Object>(null));
        }
    }

    public OutrightPriceGroupedOrderbookEntries getGroupedBuys(Orderbook orderbook) {
        return (OutrightPriceGroupedOrderbookEntries)Optional.ofNullable((AbstractComputedOrderbookEntries)this.computedEntries.get((Object)ComputedEntriesKey.GROUPED_BUYS).get()).orElseGet(() -> {
            OutrightPriceGroupedOrderbookEntries entries2 = new OutrightPriceGroupedOrderbookEntries(orderbook, Direction.BUY);
            this.computedEntries.put(ComputedEntriesKey.GROUPED_BUYS, new WeakReference<OutrightPriceGroupedOrderbookEntries>(entries2));
            return entries2;
        });
    }

    public OutrightPriceGroupedOrderbookEntries getGroupedSells(Orderbook orderbook) {
        return (OutrightPriceGroupedOrderbookEntries)Optional.ofNullable((AbstractComputedOrderbookEntries)this.computedEntries.get((Object)ComputedEntriesKey.GROUPED_SELLS).get()).orElseGet(() -> {
            OutrightPriceGroupedOrderbookEntries entries2 = new OutrightPriceGroupedOrderbookEntries(orderbook, Direction.SELL);
            this.computedEntries.put(ComputedEntriesKey.GROUPED_SELLS, new WeakReference<OutrightPriceGroupedOrderbookEntries>(entries2));
            return entries2;
        });
    }

    public OutrightExtendedOrderbookEntries getExtendedSells(Orderbook orderbook) {
        return (OutrightExtendedOrderbookEntries)Optional.ofNullable((AbstractComputedOrderbookEntries)this.computedEntries.get((Object)ComputedEntriesKey.EXTENDED_SELLS).get()).orElseGet(() -> {
            OutrightExtendedOrderbookEntries entries2 = new OutrightExtendedOrderbookEntries(orderbook, Direction.SELL);
            this.computedEntries.put(ComputedEntriesKey.EXTENDED_SELLS, new WeakReference<OutrightExtendedOrderbookEntries>(entries2));
            return entries2;
        });
    }

    public OutrightExtendedOrderbookEntries getExtendedBuys(Orderbook orderbook) {
        return (OutrightExtendedOrderbookEntries)Optional.ofNullable((AbstractComputedOrderbookEntries)this.computedEntries.get((Object)ComputedEntriesKey.EXTENDED_BUYS).get()).orElseGet(() -> {
            OutrightExtendedOrderbookEntries entries2 = new OutrightExtendedOrderbookEntries(orderbook, Direction.BUY);
            this.computedEntries.put(ComputedEntriesKey.EXTENDED_BUYS, new WeakReference<OutrightExtendedOrderbookEntries>(entries2));
            return entries2;
        });
    }

    private static enum ComputedEntriesKey {
        GROUPED_BUYS,
        GROUPED_SELLS,
        EXTENDED_BUYS,
        EXTENDED_SELLS;

    }
}

