/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.core.entity.SmallDataModelEntity;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Mergeable;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.RevisionNumbered;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ExtendedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.FilteredOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.LazyOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryFilter;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryLookup;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.PersistentOrderbookId;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.PriceGroupedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractPhase;
import com.deutscheboerse.comxerv.comtrader.entities.type.ContractStatus;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValueChange;
import com.deutscheboerse.ui.jfx.util.binding.WeakObservableValue;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Orderbook
extends BroadcastEntity<String>
implements RevisionNumbered,
Mergeable<Orderbook>,
SmallDataModelEntity {
    private static final Logger LOG = LoggerFactory.getLogger(Orderbook.class);
    private final LongProperty revisionNumber;
    private final ObjectProperty<Contract> contract;
    private final ObjectProperty<DeliveryArea> deliveryArea;
    private final OrderbookEntries buys;
    private final OrderbookEntries sells;
    private final ObjectProperty<LongDisplayValue> lastPrice;
    private final ObjectProperty<LongDisplayValue> lastQuantity;
    private final ObjectProperty<DateTime> lastTradeTime;
    private final ObjectProperty<ValueChange> priceChange;
    private final ObjectProperty<LongDisplayValue> hi;
    private final ObjectProperty<LongDisplayValue> low;
    private final ObjectProperty<LongDisplayValue> auctionIndicativePrice;
    private final ObjectProperty<LongDisplayValue> auctionSurplus;
    private final ObjectProperty<LongDisplayValue> totalTradedQty;
    private final ObjectProperty<LongDisplayValue> openingPrice;
    private final ObjectProperty<DateTime> openingPriceDate;
    private final ObjectProperty<LongDisplayValue> closingPrice;
    private final ObjectProperty<DateTime> closingPriceDate;
    private final ObjectProperty<ContractPhase> tradingPhase;
    private final ObjectProperty<ContractStatus> status;
    private final LazyOrderbookEntries lazyOrderbookEntries;
    private final OrderbookEntryLookup orderbookEntryLookup;
    private final Map<OrderbookEntryFilter, WeakReference<Orderbook>> clones;
    private final List<Orderbook> orderbooksForVwapCalculation;

    public Orderbook(Contract contract, DeliveryArea deliveryArea, OrderbookEntryLookup orderbookEntryLookup) {
        this.orderbookEntryLookup = orderbookEntryLookup;
        this.contract = new SimpleObjectProperty<Contract>(contract);
        this.deliveryArea = new SimpleObjectProperty<DeliveryArea>(deliveryArea);
        this.buys = new OrderbookEntries(Direction.BUY);
        this.sells = new OrderbookEntries(Direction.SELL);
        this.lastPrice = new SimpleObjectProperty<LongDisplayValue>();
        this.lastQuantity = new SimpleObjectProperty<LongDisplayValue>();
        this.lastTradeTime = new SimpleObjectProperty<Object>(null);
        this.revisionNumber = new SimpleLongProperty();
        this.priceChange = new SimpleObjectProperty<ValueChange>();
        this.hi = new SimpleObjectProperty<LongDisplayValue>();
        this.low = new SimpleObjectProperty<LongDisplayValue>();
        this.auctionIndicativePrice = new SimpleObjectProperty<LongDisplayValue>();
        this.auctionSurplus = new SimpleObjectProperty<LongDisplayValue>();
        this.openingPrice = new SimpleObjectProperty<LongDisplayValue>();
        this.openingPriceDate = new SimpleObjectProperty<DateTime>();
        this.closingPrice = new SimpleObjectProperty<LongDisplayValue>();
        this.closingPriceDate = new SimpleObjectProperty<DateTime>();
        this.totalTradedQty = new SimpleObjectProperty<LongDisplayValue>();
        this.tradingPhase = new SimpleObjectProperty<ContractPhase>();
        this.tradingPhase.bind(contract.getCompoundStatus().deliveryAreaPhaseProperty(deliveryArea));
        this.status = new SimpleObjectProperty<ContractStatus>();
        this.status.bind(contract.getCompoundStatus().deliveryAreaStatusProperty(deliveryArea));
        this.lazyOrderbookEntries = new LazyOrderbookEntries();
        this.clones = new HashMap<OrderbookEntryFilter, WeakReference<Orderbook>>();
        this.orderbooksForVwapCalculation = new LinkedList<Orderbook>();
    }

    public Orderbook(Orderbook original) {
        super(original);
        this.orderbookEntryLookup = original.getOrderbookEntryLookup();
        this.contract = new SimpleObjectProperty<Contract>(original.getContract());
        this.deliveryArea = new SimpleObjectProperty<DeliveryArea>(original.getDeliveryArea());
        this.buys = new OrderbookEntries(original.getBuys());
        this.sells = new OrderbookEntries(original.getSells());
        this.lastPrice = new SimpleObjectProperty<LongDisplayValue>(original.getLastPrice());
        this.lastQuantity = new SimpleObjectProperty<LongDisplayValue>(original.getLastQuantity());
        this.lastTradeTime = new SimpleObjectProperty<DateTime>(original.getLastTradeTime());
        this.revisionNumber = new SimpleLongProperty(original.getRevisionNumber());
        this.priceChange = new SimpleObjectProperty<ValueChange>(original.getPriceChange());
        this.hi = new SimpleObjectProperty<LongDisplayValue>(original.getHi());
        this.low = new SimpleObjectProperty<LongDisplayValue>(original.getLow());
        this.auctionIndicativePrice = new SimpleObjectProperty<LongDisplayValue>(original.getAuctionIndicativePrice());
        this.auctionSurplus = new SimpleObjectProperty<LongDisplayValue>(original.getAuctionSurplus());
        this.openingPrice = new SimpleObjectProperty<LongDisplayValue>(original.getOpeningPrice());
        this.openingPriceDate = new SimpleObjectProperty<DateTime>(original.getOpeningPriceDate());
        this.closingPrice = new SimpleObjectProperty<LongDisplayValue>(original.getClosingPrice());
        this.closingPriceDate = new SimpleObjectProperty<DateTime>(original.getClosingPriceDate());
        this.totalTradedQty = new SimpleObjectProperty<LongDisplayValue>(original.getTotalTradedQty());
        this.tradingPhase = new SimpleObjectProperty<ContractPhase>();
        this.tradingPhase.bind(((Contract)this.contract.get()).getCompoundStatus().deliveryAreaPhaseProperty((DeliveryArea)this.deliveryArea.get()));
        this.status = new SimpleObjectProperty<ContractStatus>();
        this.status.bind(((Contract)this.contract.get()).getCompoundStatus().deliveryAreaStatusProperty((DeliveryArea)this.deliveryArea.get()));
        this.lazyOrderbookEntries = new LazyOrderbookEntries();
        this.clones = new HashMap<OrderbookEntryFilter, WeakReference<Orderbook>>();
        this.orderbooksForVwapCalculation = new LinkedList<Orderbook>(original.orderbooksForVwapCalculation);
    }

    private Orderbook(Orderbook original, OrderbookEntryFilter filter) {
        super(original);
        this.orderbookEntryLookup = original.getOrderbookEntryLookup();
        this.contract = this.weakBind(original.contractProperty());
        this.deliveryArea = this.weakBind(original.deliveryAreaProperty());
        this.lastPrice = this.weakBind(original.lastPriceProperty());
        this.lastQuantity = this.weakBind(original.lastQuantityProperty());
        this.lastTradeTime = this.weakBind(original.lastTradeTimeProperty());
        this.revisionNumber = this.weakBind(original.revisionNumberProperty());
        this.priceChange = this.weakBind(original.priceChangeProperty());
        this.hi = this.weakBind(original.hiProperty());
        this.low = this.weakBind(original.lowProperty());
        this.auctionIndicativePrice = this.weakBind(original.auctionIndicativePriceProperty());
        this.auctionSurplus = this.weakBind(original.auctionSurplusProperty());
        this.openingPrice = this.weakBind(original.openingPriceProperty());
        this.openingPriceDate = this.weakBind(original.openingPriceDateProperty());
        this.closingPrice = this.weakBind(original.closingPriceProperty());
        this.closingPriceDate = this.weakBind(original.closingPriceDateProperty());
        this.totalTradedQty = this.weakBind(original.totalTradedQtyProperty());
        this.tradingPhase = this.weakBind(original.tradingPhase);
        this.status = this.weakBind(original.status);
        this.clones = Collections.emptyMap();
        this.orderbooksForVwapCalculation = new LinkedList<Orderbook>(original.orderbooksForVwapCalculation);
        this.lazyOrderbookEntries = new LazyOrderbookEntries();
        this.buys = new FilteredOrderbookEntries(this, original.getBuys(), filter);
        this.sells = new FilteredOrderbookEntries(this, original.getSells(), filter);
    }

    private <T> ObjectProperty<T> weakBind(ObjectProperty<T> source) {
        SimpleObjectProperty<T> property = new SimpleObjectProperty<T>();
        property.bind(new WeakObservableValue<T>(source));
        return property;
    }

    private LongProperty weakBind(LongProperty source) {
        SimpleLongProperty property = new SimpleLongProperty();
        property.bind(new WeakObservableValue<Number>(source));
        return property;
    }

    OrderbookEntryLookup getOrderbookEntryLookup() {
        return this.orderbookEntryLookup;
    }

    @Override
    public Class<Orderbook> getEntityClass() {
        return Orderbook.class;
    }

    public LongProperty revisionNumberProperty() {
        return this.revisionNumber;
    }

    public ObjectProperty<ValueChange> priceChangeProperty() {
        return this.priceChange;
    }

    public OrderbookEntries getSells() {
        return this.sells;
    }

    public void setSells(Set<OrderbookEntry> newSells) {
        try {
            this.sells.batchStarted();
            this.sells.clear();
            this.sells.addAll(newSells);
        }
        finally {
            this.sells.batchFinished();
        }
    }

    public OrderbookEntries getBuys() {
        return this.buys;
    }

    public void setBuys(Set<OrderbookEntry> newBuys) {
        try {
            this.buys.batchStarted();
            this.buys.clear();
            this.buys.addAll(newBuys);
        }
        finally {
            this.buys.batchFinished();
        }
    }

    public Exchange getExchange() {
        return ((Contract)this.contract.get()).getExchange();
    }

    public LongDisplayValue getLastPrice() {
        return (LongDisplayValue)this.lastPrice.get();
    }

    public ObjectProperty<LongDisplayValue> lastPriceProperty() {
        return this.lastPrice;
    }

    public void setLastPrice(LongDisplayValue lastPrice) {
        this.lastPrice.set(lastPrice);
    }

    public LongDisplayValue getLastQuantity() {
        return (LongDisplayValue)this.lastQuantity.get();
    }

    public ObjectProperty<LongDisplayValue> lastQuantityProperty() {
        return this.lastQuantity;
    }

    public void setLastQuantity(LongDisplayValue lastQuantity) {
        this.lastQuantity.set(lastQuantity);
    }

    public DateTime getLastTradeTime() {
        return (DateTime)this.lastTradeTime.get();
    }

    public ObjectProperty<DateTime> lastTradeTimeProperty() {
        return this.lastTradeTime;
    }

    public void setLastTradeTime(DateTime lastTradeTime) {
        this.lastTradeTime.set(lastTradeTime);
    }

    public ValueChange getPriceChange() {
        return (ValueChange)((Object)this.priceChange.get());
    }

    public void setPriceChange(ValueChange priceChange) {
        this.priceChange.set(priceChange);
    }

    @Override
    public long getRevisionNumber() {
        return this.revisionNumber.get();
    }

    public void setRevisionNumber(long revisionNumber) {
        this.revisionNumber.set(revisionNumber);
    }

    public ContractPhase getTradingPhase() {
        return (ContractPhase)this.tradingPhase.get();
    }

    public ReadOnlyObjectProperty<ContractPhase> tradingPhaseProperty() {
        return this.tradingPhase;
    }

    public ContractStatus getStatus() {
        return (ContractStatus)this.status.get();
    }

    public ObjectProperty<ContractStatus> statusProperty() {
        return this.status;
    }

    public ContractStatus getContractStatus() {
        return ((Contract)this.contract.get()).getCompoundStatus().getDeliveryAreaStatusOrContractStatus((DeliveryArea)this.deliveryArea.get());
    }

    public ObservableValue<ContractStatus> contractStatusPropery() {
        return ((Contract)this.contract.get()).getCompoundStatus().deliveryAreaStatusProperty((DeliveryArea)this.deliveryArea.get());
    }

    public LongDisplayValue getHi() {
        return (LongDisplayValue)this.hi.get();
    }

    public void setHi(LongDisplayValue hi) {
        this.hi.set(hi);
    }

    public ObjectProperty<LongDisplayValue> hiProperty() {
        return this.hi;
    }

    public LongDisplayValue getTotalTradedQty() {
        return (LongDisplayValue)this.totalTradedQty.get();
    }

    public ObjectProperty<LongDisplayValue> totalTradedQtyProperty() {
        return this.totalTradedQty;
    }

    public void setTotalTradedQty(LongDisplayValue totalTradedQty) {
        this.totalTradedQty.set(totalTradedQty);
    }

    public LongDisplayValue getLow() {
        return (LongDisplayValue)this.low.get();
    }

    public void setLow(LongDisplayValue low) {
        this.low.set(low);
    }

    public ObjectProperty<LongDisplayValue> lowProperty() {
        return this.low;
    }

    public LongDisplayValue getAuctionIndicativePrice() {
        return (LongDisplayValue)this.auctionIndicativePrice.get();
    }

    public ObjectProperty<LongDisplayValue> auctionIndicativePriceProperty() {
        return this.auctionIndicativePrice;
    }

    public void setAuctionIndicativePrice(LongDisplayValue auctionIndicativePrice) {
        this.auctionIndicativePrice.set(auctionIndicativePrice);
    }

    public LongDisplayValue getAuctionSurplus() {
        return (LongDisplayValue)this.auctionSurplus.get();
    }

    public ObjectProperty<LongDisplayValue> auctionSurplusProperty() {
        return this.auctionSurplus;
    }

    public void setAuctionSurplus(LongDisplayValue auctionSurplus) {
        this.auctionSurplus.set(auctionSurplus);
    }

    public LongDisplayValue getOpeningPrice() {
        return (LongDisplayValue)this.openingPrice.get();
    }

    public ObjectProperty<LongDisplayValue> openingPriceProperty() {
        return this.openingPrice;
    }

    public void setOpeningPrice(LongDisplayValue openingPrice) {
        this.openingPrice.set(openingPrice);
    }

    public DateTime getOpeningPriceDate() {
        return (DateTime)this.openingPriceDate.get();
    }

    public ObjectProperty<DateTime> openingPriceDateProperty() {
        return this.openingPriceDate;
    }

    public void setOpeningPriceDate(DateTime openingPriceDate) {
        this.openingPriceDate.set(openingPriceDate);
    }

    public LongDisplayValue getClosingPrice() {
        return (LongDisplayValue)this.closingPrice.get();
    }

    public ObjectProperty<LongDisplayValue> closingPriceProperty() {
        return this.closingPrice;
    }

    public void setClosingPrice(LongDisplayValue closingPrice) {
        this.closingPrice.set(closingPrice);
    }

    public DateTime getClosingPriceDate() {
        return (DateTime)this.closingPriceDate.get();
    }

    public ObjectProperty<DateTime> closingPriceDateProperty() {
        return this.closingPriceDate;
    }

    public void setClosingPriceDate(DateTime closingPriceDate) {
        this.closingPriceDate.set(closingPriceDate);
    }

    public DeliveryArea getDeliveryArea() {
        return (DeliveryArea)this.deliveryArea.get();
    }

    public ObjectProperty<DeliveryArea> deliveryAreaProperty() {
        return this.deliveryArea;
    }

    public String getDeliveryAreaId() {
        return this.deliveryArea.get() == null ? null : (String)((DeliveryArea)this.deliveryArea.get()).getId();
    }

    public Contract getContract() {
        return (Contract)this.contract.get();
    }

    public ObjectProperty<Contract> contractProperty() {
        return this.contract;
    }

    public Long getContractId() {
        return this.contract.get() == null ? null : (Long)((Contract)this.contract.get()).getId();
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", this.getId()).append("revisionNumber", this.getRevisionNumber()).append("buysSize", this.buys.size()).append("sellsSize", this.sells.size()).toString();
    }

    @Override
    public void merge(Orderbook other) {
        if (other.getOpeningPrice() != null && other.getOpeningPriceDate() != null) {
            this.setOpeningPrice(other.getOpeningPrice());
            this.setOpeningPriceDate(other.getOpeningPriceDate());
        } else if (other.getClosingPrice() != null && other.getClosingPriceDate() != null) {
            if (this.getClosingPriceDate() == null || !other.getClosingPriceDate().isBefore(this.getClosingPriceDate())) {
                this.setClosingPrice(other.getClosingPrice());
                this.setClosingPriceDate(other.getClosingPriceDate());
            }
        } else if (other.getRevisionNumber() == Long.MAX_VALUE) {
            this.mergeOrderbookEntries(this.getBuys(), other.getBuys());
            this.mergeOrderbookEntries(this.getSells(), other.getSells());
        } else {
            if (other.getLastTradeTime() != null) {
                this.setLastTradeTime(other.getLastTradeTime());
            }
            this.setLastPrice(other.getLastPrice());
            this.setLastQuantity(other.getLastQuantity());
            this.setHi(other.getHi());
            this.setLow(other.getLow());
            this.setTotalTradedQty(other.getTotalTradedQty());
            this.setPriceChange(other.getPriceChange());
            this.setAuctionSurplus(other.getAuctionSurplus());
            this.setAuctionIndicativePrice(other.getAuctionIndicativePrice());
            this.setRevisionNumber(other.getRevisionNumber());
            this.mergeOrderbookEntries(this.getBuys(), other.getBuys());
            this.mergeOrderbookEntries(this.getSells(), other.getSells());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeOrderbookEntries(OrderbookEntries ownEntries, OrderbookEntries delta) {
        if (delta != null && delta.size() > 0) {
            try {
                ownEntries.batchStarted();
                List sortedDeltas = delta.getEntries().stream().sorted((o1, o2) -> o1.getQuantity().compareTo(o2.getQuantity())).toList();
                for (OrderbookEntry entry : sortedDeltas) {
                    if (entry.getQuantity().getValue() == 0L) {
                        ownEntries.remove(entry);
                        continue;
                    }
                    ownEntries.remove(entry);
                    ownEntries.add(entry);
                }
            }
            finally {
                ownEntries.batchFinished();
            }
        }
    }

    public PersistentOrderbookId getPersistentOrderbookId() {
        return new PersistentOrderbookId(this.getContract().getName(), this.getContract().getProduct().getName(), this.getDeliveryAreaId());
    }

    public PriceGroupedOrderbookEntries getGroupedBuys() {
        return this.lazyOrderbookEntries.getGroupedBuys(this);
    }

    public PriceGroupedOrderbookEntries getGroupedSells() {
        return this.lazyOrderbookEntries.getGroupedSells(this);
    }

    public ExtendedOrderbookEntries getExtendedBuys() {
        return this.lazyOrderbookEntries.getExtendedBuys(this);
    }

    public ExtendedOrderbookEntries getExtendedSells() {
        return this.lazyOrderbookEntries.getExtendedSells(this);
    }

    protected List<Orderbook> getOrderbooksForVwapCalculation() {
        return this.orderbooksForVwapCalculation;
    }

    public void updateOrderbooksForVwapCalculation(List<? extends Orderbook> orderbooks) {
        this.orderbooksForVwapCalculation.clear();
        this.orderbooksForVwapCalculation.addAll(orderbooks);
        this.clones.values().stream().map(Reference::get).filter(Objects::nonNull).map(Orderbook.class::cast).forEach(clone -> clone.updateOrderbooksForVwapCalculation(orderbooks));
    }

    public Orderbook clone(OrderbookEntryFilter filter) {
        this.cleanUpClones();
        if (filter.acceptsAll()) {
            return this;
        }
        WeakReference<Orderbook> reference = this.clones.get(filter);
        if (reference != null) {
            return (Orderbook)reference.get();
        }
        Orderbook orderbook = new Orderbook(this, filter);
        orderbook.setId((String)this.getId() + "|(" + String.valueOf(filter) + ")");
        this.clones.put(filter, new WeakReference<Orderbook>(orderbook));
        return orderbook;
    }

    private void cleanUpClones() {
        this.clones.entrySet().removeIf(entry -> ((WeakReference)entry.getValue()).get() == null);
    }

    public void updateEntry(Order order) {
        OrderbookEntries entries2 = order.getDirection() == Direction.BUY ? this.getBuys() : this.getSells();
        OrderbookEntry entry = entries2.getEntry((Long)order.getId());
        if (entry != null) {
            OrderbookEntry newOrderbookEntry = OrderbookEntry.newBuilder().withOrderId(entry.getOrderId()).withPrice(entry.getPrice()).withQuantity(entry.getQuantity()).withTime(entry.getTime()).withOrderType(order.getOrderType()).withExecutionRestriction(entry.getExecutionRestriction()).withRemainingQuantity(order.getRemainingQuantity()).withLocalTimestamp(entry.getLocalTimestamp()).build();
            LOG.info("Replacing entry {} with {}", (Object)entry, (Object)newOrderbookEntry);
            entries2.batchStarted();
            entries2.remove(entry);
            entries2.add(newOrderbookEntry);
            entries2.batchFinished();
        }
    }
}

