/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook;

import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ComputedOrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.ContractAdditionOrigin;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryType;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookValueWrapper;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import com.deutscheboerse.ui.jfx.util.binding.ObservableBase;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

public class OrderbookValueWrapperWithEntries
extends OrderbookValueWrapper {
    private final ObjectProperty<ComputedOrderbookEntries> buys = new SimpleObjectProperty<ComputedOrderbookEntries>();
    private final ObjectProperty<ComputedOrderbookEntries> sells = new SimpleObjectProperty<ComputedOrderbookEntries>();
    private final ObjectProperty<OrderbookEntryType> type = new SimpleObjectProperty<OrderbookEntryType>(OrderbookEntryType.AGGREGATED);
    private final ObservableBase reloadEntriesObservable = new ObservableBase();

    public OrderbookValueWrapperWithEntries(ContractAdditionOrigin origin, Consumer<Orderbook> contractBecameInactive, BiConsumer<Orderbook, Boolean> compaundContractStatus, Consumer<OrderbookValueWrapper> orderbookChanged) {
        super(origin, contractBecameInactive, compaundContractStatus, orderbookChanged);
        this.buys.bind(DependentBinding.get(this::computeBuys, this.type, this.reloadEntriesObservable, this.orderbookProperty()));
        this.sells.bind(DependentBinding.get(this::computeSells, this.type, this.reloadEntriesObservable, this.orderbookProperty()));
    }

    private ComputedOrderbookEntries computeBuys() {
        if (this.getOrderbook() != null) {
            return this.type.get() == OrderbookEntryType.AGGREGATED ? this.getOrderbook().getGroupedBuys() : this.getOrderbook().getExtendedBuys();
        }
        return null;
    }

    private ComputedOrderbookEntries computeSells() {
        if (this.getOrderbook() != null) {
            return this.type.get() == OrderbookEntryType.AGGREGATED ? this.getOrderbook().getGroupedSells() : this.getOrderbook().getExtendedSells();
        }
        return null;
    }

    public ComputedOrderbookEntries getBuys() {
        return (ComputedOrderbookEntries)this.buys.get();
    }

    public ReadOnlyObjectProperty<ComputedOrderbookEntries> buysProperty() {
        return this.buys;
    }

    public ComputedOrderbookEntries getSells() {
        return (ComputedOrderbookEntries)this.sells.get();
    }

    public ReadOnlyObjectProperty<ComputedOrderbookEntries> sellsProperty() {
        return this.sells;
    }

    public OrderbookEntryType getType() {
        return (OrderbookEntryType)((Object)this.type.get());
    }

    public ObjectProperty<OrderbookEntryType> typeProperty() {
        return this.type;
    }

    public void setType(OrderbookEntryType type) {
        this.type.set(type);
    }

    public void reloadEntries() {
        this.reloadEntriesObservable.invalidate();
    }
}

