/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.entities.orderbook.filter;

import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntryFilter;

public abstract class AbstractOrderbookEntryFilter
implements OrderbookEntryFilter {
    public static final AbstractOrderbookEntryFilter TRUE_FILTER = new ConstantFilter(true);
    public static final AbstractOrderbookEntryFilter FALSE_FILTER = new ConstantFilter(false);

    @Override
    public OrderbookEntryFilter and(OrderbookEntryFilter filter) {
        return new AndOrderbookEntryFilter(this, filter);
    }

    private static final class AndOrderbookEntryFilter
    extends AbstractOrderbookEntryFilter
    implements OrderbookEntryFilter {
        private final OrderbookEntryFilter filter1;
        private final OrderbookEntryFilter filter2;

        private AndOrderbookEntryFilter(OrderbookEntryFilter filter1, OrderbookEntryFilter filter2) {
            this.filter1 = filter1;
            this.filter2 = filter2;
        }

        @Override
        public boolean accepts(Orderbook orderbook, OrderbookEntry entry) {
            return this.filter1.accepts(orderbook, entry) && this.filter2.accepts(orderbook, entry);
        }

        @Override
        public boolean acceptsAll() {
            return this.filter1.acceptsAll() && this.filter2.acceptsAll();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AndOrderbookEntryFilter that = (AndOrderbookEntryFilter)o;
            if (!this.filter1.equals(that.filter1)) {
                return false;
            }
            return this.filter2.equals(that.filter2);
        }

        public int hashCode() {
            return this.filter1.hashCode() + this.filter2.hashCode();
        }

        public String toString() {
            return String.valueOf(this.filter1) + "," + String.valueOf(this.filter2);
        }
    }

    private static final class ConstantFilter
    extends AbstractOrderbookEntryFilter {
        private final boolean value;

        private ConstantFilter(boolean value) {
            this.value = value;
        }

        @Override
        public boolean accepts(Orderbook orderbook, OrderbookEntry entry) {
            return this.value;
        }

        @Override
        public boolean acceptsAll() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConstantFilter filter = (ConstantFilter)o;
            return this.value == filter.value;
        }

        public int hashCode() {
            return this.value ? 1 : 0;
        }
    }
}

