/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ContentTab;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.FXMLBorderPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.PanelWrapper;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPanel
extends FXMLBorderPane
implements Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPanel.class);
    private final ContentTab.ContentTabLookup contentTabLookup;
    private final EventBus eventBus;
    private final OverrideGuiConfigurationsExecutor overrideGuiConfigurationsExecutor;

    public AbstractPanel(ApplicationContext appContext) {
        super(appContext);
        this.contentTabLookup = appContext.getService(ContentTab.ContentTabLookup.class);
        this.eventBus = appContext.getService(EventBus.class);
        this.overrideGuiConfigurationsExecutor = this.getAppContext().getService(OverrideGuiConfigurationsExecutor.class);
    }

    public void initialize() {
        this.eventBus.register(this);
        this.overrideGuiConfigurationsExecutor.registerAndApply(this);
    }

    protected ContentTab getContentTab() {
        return this.contentTabLookup.findContentTabOfNode(this);
    }

    protected ContentTab.ContentTabLookup getContentTabLookup() {
        return this.contentTabLookup;
    }

    @Override
    public void destroy() {
        this.unregisterAsStorableComponent();
        LOG.info("Unregistering {}", (Object)this.getClass().getSimpleName());
        this.eventBus.unregister(this);
        this.destroyChildrenRecursively(this);
    }

    protected void unregisterAsStorableComponent() {
        ContentTab contentTabOfNode = this.getContentTab();
        if (this instanceof StorableComponent && contentTabOfNode != null) {
            contentTabOfNode.unregisterStorableComponent((StorableComponent)((Object)this));
        }
    }

    protected Optional<PanelWrapper> getPanelWrapper() {
        return Optional.of(this.getParent()).filter(PanelWrapper.class::isInstance).map(PanelWrapper.class::cast);
    }

    public String getPersistentId() {
        return this.getPanelWrapper().map(PanelWrapper::getPersistentId).orElse(null);
    }

    public String getComponentName() {
        return Optional.ofNullable(this.getClass().getAnnotation(DraggableComponent.class)).map(annotation -> Strings.isNullOrEmpty(annotation.nameKey()) ? null : Util.getLabel(annotation.nameKey())).orElse(null);
    }
}

