/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.OrderLimit;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.PanelWithLoadingIndicator;
import com.deutscheboerse.comxerv.comtrader.jfx.components.instruments.InstrumentsContractTreeContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.instruments.InstrumentsTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.SlideInContractTreePane;
import com.deutscheboerse.comxerv.comtrader.jfx.util.DragAndDropService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Optional;
import javafx.fxml.FXML;
import javafx.scene.control.TableView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.text.Text;

@DraggableComponent(hasPublicAccess=true, nameKey="instrumentsPanel_header_label", descriptionKey="instrumentsPanel_description")
@PanelWithLoadingIndicator(entityClasses={Contract.class})
public class InstrumentsPanel
extends AbstractPanel {
    private final SlideInContractTreePane slideInContractTreePane;
    @FXML
    private Text header;
    @FXML
    private InstrumentsTableView instrumentsTableView;
    private Contract currentContract;
    private Product currentProduct;
    private final DragAndDropService dragAndDropService;
    private final AbstractDataModelListener<Contract> contractDataModelListener;
    private final AbstractDataModelListener<OrderLimit> orderLimitDataModelListener;

    public InstrumentsPanel() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public InstrumentsPanel(ApplicationContext appContext) {
        super(appContext);
        this.dragAndDropService = appContext.getService(DragAndDropService.class);
        this.slideInContractTreePane = new SlideInContractTreePane(appContext, new InstrumentsContractTreeContext(this::shouldContractBeDisplayed, this::selectContract, this::selectProduct));
        this.loadFxml();
        this.contractDataModelListener = new AbstractDataModelListener<Contract>(){

            @Override
            public DataModelListener.NotificationResult notifyUpdate(Contract object) {
                if (object.equals(InstrumentsPanel.this.currentContract)) {
                    InstrumentsPanel.this.selectContract(object);
                }
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                InstrumentsPanel.this.clear();
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyRemove(Contract object) {
                InstrumentsPanel.this.clear();
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }
        };
        appContext.getSmallDataModel(Contract.class).registerListener(new WeakDataModelListener<Contract>(this.contractDataModelListener));
        this.orderLimitDataModelListener = new AbstractDataModelListener<OrderLimit>(){

            private DataModelListener.NotificationResult refreshProduct() {
                if (InstrumentsPanel.this.currentProduct != null) {
                    InstrumentsPanel.this.selectProduct(InstrumentsPanel.this.currentProduct);
                }
                return DataModelListener.NotificationResult.RETAIN_LISTENER;
            }

            @Override
            public DataModelListener.NotificationResult notifyUpdate(OrderLimit object) {
                return this.refreshProduct();
            }

            @Override
            public DataModelListener.NotificationResult notifyAdd(OrderLimit object) {
                return this.refreshProduct();
            }

            @Override
            public DataModelListener.NotificationResult notifyRemove(OrderLimit object) {
                return this.refreshProduct();
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                return this.refreshProduct();
            }
        };
        appContext.getSmallDataModel(OrderLimit.class).registerListener(new WeakDataModelListener<OrderLimit>(this.orderLimitDataModelListener));
    }

    @Override
    public void initialize() {
        super.initialize();
        this.instrumentsTableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.setLeft(this.slideInContractTreePane);
    }

    private boolean shouldContractBeDisplayed(Contract contract) {
        return !contract.getCompoundStatus().getContractStatus().isInactive() || contract.isBetweenTradingAndDeliveryEnd();
    }

    private void selectContract(Contract contract) {
        this.header.setText(contract.getProduct().getDisplayName() + " " + contract.getDisplayName());
        this.instrumentsTableView.selectContract(contract);
        this.currentContract = contract;
        this.currentProduct = null;
    }

    private void selectProduct(Product product) {
        this.header.setText(Util.getLabel("commons_product") + " " + product.getDisplayName());
        this.instrumentsTableView.selectProduct(product);
        this.currentContract = null;
        this.currentProduct = product;
    }

    private void clear() {
        this.header.setText("");
        this.instrumentsTableView.clear();
        this.currentContract = null;
        this.currentProduct = null;
    }

    @FXML
    public void instrumentsTableViewDragOver(DragEvent dragEvent) {
        Dragboard dragboard = dragEvent.getDragboard();
        if (this.dragAndDropService.hasProductList(dragboard) || this.dragAndDropService.hasContractList(dragboard)) {
            dragEvent.acceptTransferModes(TransferMode.COPY);
        }
        dragEvent.consume();
    }

    @FXML
    public void instrumentsTableViewDragDropped(DragEvent dragEvent) {
        Dragboard dragboard = dragEvent.getDragboard();
        Optional product = this.dragAndDropService.getProductList(dragboard).stream().findFirst();
        Optional contract = this.dragAndDropService.getContractList(dragboard).stream().findFirst();
        if (product.isPresent()) {
            this.selectProduct((Product)product.get());
            dragEvent.setDropCompleted(true);
        } else if (contract.isPresent()) {
            this.selectContract((Contract)contract.get());
            dragEvent.setDropCompleted(true);
        }
        dragEvent.consume();
    }
}

