/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components;

import com.deutscheboerse.comxerv.comtrader.app.login.StorableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ContentTab;
import com.deutscheboerse.comxerv.comtrader.jfx.components.ConvertableToFxml;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DropTargetParent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.layout.PanelWrapper;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Skin;
import javafx.scene.control.SplitPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitPanel
extends SplitPane
implements DropTargetParent,
ConvertableToFxml {
    private static final Logger LOG = LoggerFactory.getLogger(SplitPanel.class);

    public SplitPanel() {
        this.getItems().addListener(observable2 -> this.updateDropTargetParentOfItems());
    }

    @Override
    public void dispose() {
        this.disposeChildren();
        this.getItems().clear();
        this.cleanupSkin();
    }

    private void updateDropTargetParentOfItems() {
        this.getItems().stream().filter(PanelWrapper.class::isInstance).map(PanelWrapper.class::cast).forEach(panelWrapper -> panelWrapper.setDropTargetParent(this));
    }

    private void cleanupSkin() {
        try {
            Skin<?> skin = this.getSkin();
            if (skin instanceof Parent) {
                Field removedField = Parent.class.getDeclaredField("removed");
                removedField.setAccessible(true);
                Object removedValue = removedField.get(skin);
                if (removedValue instanceof List) {
                    ((List)removedValue).clear();
                }
            }
        }
        catch (Exception e) {
            LOG.error("Error while cleaning up skin.", e);
        }
        this.setSkin(null);
    }

    private void disposeChildren() {
        this.getItems().stream().filter(child -> child instanceof DropTargetParent).forEach(child -> ((DropTargetParent)((Object)child)).dispose());
    }

    public void registerStorableComponents(ContentTab contentTab) {
        for (Node node : this.getItems()) {
            if (node instanceof PanelWrapper && ((PanelWrapper)node).isStoreable()) {
                contentTab.registerNewStorableComponent((StorableComponent)((Object)((PanelWrapper)node).getPanel()));
            }
            if (!(node instanceof SplitPanel)) continue;
            ((SplitPanel)node).registerStorableComponents(contentTab);
        }
    }

    public void addComponent(int index, InsertionMode insertionMode, Node node) {
        double[] dividerPositions = this.getDividerPositions();
        if (insertionMode == InsertionMode.REPLACE) {
            Node oldNode = (Node)this.getItems().get(index);
            this.getItems().set(index, node);
            if (oldNode instanceof DropTargetParent) {
                ((DropTargetParent)((Object)oldNode)).dispose();
            }
            this.setDividerPositions(dividerPositions);
        } else {
            double width = 1.0;
            if (dividerPositions.length > 0 && index <= dividerPositions.length) {
                double start = index == 0 ? 0.0 : dividerPositions[index - 1];
                double end = index == dividerPositions.length ? 1.0 : dividerPositions[index];
                width = end - start;
            }
            double[] updatedDividerPositions = new double[dividerPositions.length + 1];
            for (int i = 0; i < updatedDividerPositions.length; ++i) {
                if (i < index) {
                    updatedDividerPositions[i] = dividerPositions[i];
                    continue;
                }
                if (i == index) {
                    if (i > 0) {
                        updatedDividerPositions[i] = dividerPositions[i - 1] + 0.5 * width;
                        continue;
                    }
                    updatedDividerPositions[i] = 0.5 * width;
                    continue;
                }
                updatedDividerPositions[i] = dividerPositions[i - 1];
            }
            if (insertionMode == InsertionMode.BEFORE) {
                this.getItems().add(index, node);
            } else if (insertionMode == InsertionMode.AFTER) {
                this.getItems().add(index + 1, node);
            }
            this.updateDividerPositions(updatedDividerPositions);
        }
        ContentTab contentTabOfNode = new ContentTab.ContentTabLookup().findContentTabOfNode(node);
        if (node instanceof PanelWrapper && ((PanelWrapper)node).isStoreable() && contentTabOfNode != null) {
            contentTabOfNode.registerNewStorableComponent((StorableComponent)((Object)((PanelWrapper)node).getPanel()));
        }
    }

    @Override
    public void removeNode(Node node) {
        int index = this.getItems().indexOf(node);
        if (index != -1) {
            double[] dividerPositions = this.getDividerPositions();
            this.getItems().remove(index);
            if (node instanceof DropTargetParent) {
                ((DropTargetParent)((Object)node)).dispose();
            }
            if (dividerPositions.length > 0) {
                double[] updatedDividerPositions = new double[dividerPositions.length - 1];
                for (int i = 0; i < updatedDividerPositions.length; ++i) {
                    updatedDividerPositions[i] = index == 0 ? dividerPositions[i + 1] : (i < index ? dividerPositions[i] : dividerPositions[i + 1]);
                }
                this.updateDividerPositions(updatedDividerPositions);
            }
            Object parent = this.findParent();
            if (this.getItems().isEmpty()) {
                if (parent instanceof DropTargetParent) {
                    ((DropTargetParent)parent).removeNode(this);
                }
            } else if (this.getItems().size() == 1) {
                Node replaceNode = (Node)this.getItems().get(0);
                if (parent instanceof SplitPanel) {
                    SplitPanel parentSplitPanel = (SplitPanel)parent;
                    parentSplitPanel.getItems().set(parentSplitPanel.getItems().indexOf(this), replaceNode);
                    this.getItems().clear();
                    this.dispose();
                }
            }
        }
        this.requestLayout();
    }

    private void updateDividerPositions(double[] newDividerPositions) {
        FxUtil.runInFxThread(() -> {
            this.setDividerPositions(newDividerPositions);
            this.requestLayout();
        });
    }

    protected Object findParent() {
        return ContentTab.findParentOfNode(this);
    }

    @Override
    public String generateFxml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.getClass().getSimpleName()).append(" ");
        this.writeFxmlAttribute(sb, "orientation", this.getOrientation().toString());
        this.writeFxmlAttribute(sb, "dividerPositions", this.getDividerPositionsAsString());
        sb.append(">");
        for (Node node : this.getItems()) {
            if (!(node instanceof ConvertableToFxml)) continue;
            sb.append(((ConvertableToFxml)((Object)node)).generateFxml());
        }
        sb.append("</").append(this.getClass().getSimpleName()).append(">");
        return sb.toString();
    }

    private String getDividerPositionsAsString() {
        return DoubleStream.of(this.getDividerPositions()).mapToObj(Double::toString).collect(Collectors.joining(","));
    }

    private void writeFxmlAttribute(StringBuilder target, String attributeName, String attributeValue) {
        target.append(attributeName).append("=\"").append(attributeValue).append("\" ");
    }

    public static enum InsertionMode {
        BEFORE,
        AFTER,
        REPLACE;

    }
}

