/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.chart;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.MarketArea;
import com.deutscheboerse.comxerv.comtrader.entities.PublicTradeConfirmation;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.chart.LastTradeInfo;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Label;
import org.joda.time.DateTime;

public class LastTradeInfoText
extends Label {
    private final ObjectProperty<Contract> contract = new SimpleObjectProperty<Contract>();
    private final ObjectProperty<MarketArea> marketArea = new SimpleObjectProperty<MarketArea>();
    private final AbstractDataModelListener<PublicTradeConfirmation> dataModelListener = new AbstractDataModelListener<PublicTradeConfirmation>(){

        @Override
        public DataModelListener.NotificationResult notifyAdd(PublicTradeConfirmation object) {
            if (LastTradeInfoText.this.contractAndDeliveryAreaMatch(object)) {
                LastTradeInfoText.this.update(object);
            }
            return DataModelListener.NotificationResult.RETAIN_LISTENER;
        }
    };
    private final LocalService localService;

    public LastTradeInfoText() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    protected LastTradeInfoText(ApplicationContext applicationContext) {
        applicationContext.getDataModel(PublicTradeConfirmation.class).registerHencePostOperationListener(new WeakDataModelListener<PublicTradeConfirmation>(this.dataModelListener));
        this.localService = applicationContext.getService(LocalService.class);
        this.contract.addListener(this::reset);
        this.marketArea.addListener(this::reset);
    }

    private void reset(Observable observable2) {
        this.setText("");
    }

    private void update(PublicTradeConfirmation publicTradeConfirmation) {
        this.loadValues(publicTradeConfirmation.getPrice(), publicTradeConfirmation.getQuantity(), publicTradeConfirmation.getTradeExecutionTime());
    }

    private boolean contractAndDeliveryAreaMatch(PublicTradeConfirmation publicTradeConfirmation) {
        return publicTradeConfirmation.getContract().equals(this.contract.get()) && (this.marketAreaEquals(publicTradeConfirmation.getBuyDeliveryArea()) || this.marketAreaEquals(publicTradeConfirmation.getSellDeliveryArea()));
    }

    private boolean marketAreaEquals(DeliveryArea da) {
        if (da == null) {
            return false;
        }
        return this.getMarketArea().equals(da.getMarketArea());
    }

    public void loadValues(Optional<LastTradeInfo> lastTradeInfo) {
        if (lastTradeInfo.isPresent() && this.getContract() != null) {
            this.loadValues(lastTradeInfo.get().getPrice(), lastTradeInfo.get().getQuantity(), lastTradeInfo.get().getExecutionTime());
        } else {
            this.reset(null);
        }
    }

    private void loadValues(LongDisplayValue price, LongDisplayValue quantity, DateTime executionTime) {
        this.setText(Util.getLabel("chartPanel_chart_lasTradeInfo", quantity.toString(), this.getContract().getProduct().getQuantityUnit(), price.toString(), this.getContract().getProduct().getCurrencyCode(), this.localService.formatDateTime(executionTime)));
    }

    public Contract getContract() {
        return (Contract)this.contract.get();
    }

    public ObjectProperty<Contract> contractProperty() {
        return this.contract;
    }

    public void setContract(Contract contract) {
        this.contract.set(contract);
    }

    public MarketArea getMarketArea() {
        return (MarketArea)this.marketArea.get();
    }

    public ObjectProperty<MarketArea> marketAreaProperty() {
        return this.marketArea;
    }

    public void setMarketArea(MarketArea marketArea) {
        this.marketArea.set(marketArea);
    }
}

