/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.componentlist;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.AbstractPanel;
import com.deutscheboerse.comxerv.comtrader.jfx.components.DraggableComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.components.componentlist.AllComponents;
import com.deutscheboerse.comxerv.comtrader.jfx.components.componentlist.ComponentDescriptor;
import com.deutscheboerse.comxerv.comtrader.jfx.components.componentlist.ComponentListOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.service.ComponentAccessService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.GuiStateService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.EditEvent;
import com.deutscheboerse.comxerv.comtrader.jfx.util.UtilityStages;
import com.deutscheboerse.comxerv.comtrader.service.event.LoadingFinishedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.event.KeyEventUtil;
import com.deutscheboerse.ui.jfx.util.stream.JFXCollectors;
import com.google.common.base.Strings;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Singleton;
import jakarta.inject.Inject;
import java.util.Comparator;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

@Singleton
@OverrideGuiConfiguration(field="componentsList", overrideId="ComponentListPane", strategy=ComponentListOverrideGuiStrategy.class)
public class ComponentListPane
extends BorderPane {
    private final UserService userService;
    private final ComponentAccessService componentAccessService;
    private final Stage stage;
    private final GuiStateService guiStateService;
    private final OverrideGuiConfigurationsExecutor overrideGuiConfigurationExecutor;
    @FXML
    private TableView<ComponentDescriptor> componentsTable;

    @Inject
    public ComponentListPane(ApplicationContext appContext) {
        this.guiStateService = appContext.getService(GuiStateService.class);
        this.overrideGuiConfigurationExecutor = appContext.getService(OverrideGuiConfigurationsExecutor.class);
        this.userService = appContext.getService(UserService.class);
        this.componentAccessService = appContext.getService(ComponentAccessService.class);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        this.stage = appContext.getService(UtilityStages.class).withKey(ComponentListPane.class.getName()).withStageStyle(StageStyle.DECORATED).withRoot(this).get();
        this.stage.setAlwaysOnTop(true);
        this.stage.setTitle(Util.getLabel("panelList_title"));
        this.stage.setOnCloseRequest(windowEvent -> this.close());
        appContext.getService(EventBus.class).register(this);
        this.refreshComponentList();
    }

    public void initialize() {
        this.addEventFilter(KeyEvent.KEY_PRESSED, (? super T keyEvent) -> {
            if (KeyEventUtil.isAltKeyCode(KeyCode.C, keyEvent)) {
                this.close();
                keyEvent.consume();
            }
        });
    }

    @Subscribe
    public void handleLoadingFinishedEvent(LoadingFinishedEvent loadingFinishedEvent) {
        this.refreshComponentList();
    }

    @Subscribe
    public void handleLogoutEvent(LogoutEvent logoutEvent) {
        this.stage.hide();
        this.refreshComponentList();
    }

    @Subscribe
    public void handleEditEvent(EditEvent editEvent) {
        if (editEvent.isEditMode()) {
            this.stage.show();
        } else {
            this.stage.hide();
        }
    }

    protected void refreshComponentList() {
        this.componentsTable.setItems(AllComponents.get().stream().filter(this.componentAccessService::isComponentAllowedForCurrentUser).map(this::createComponentDescriptor).sorted(Comparator.comparing(ComponentDescriptor::getName)).collect(JFXCollectors.toObservableList()));
        this.overrideGuiConfigurationExecutor.registerAndApply(this);
    }

    private ComponentDescriptor createComponentDescriptor(Class<? extends AbstractPanel> clazz) {
        DraggableComponent annotation = clazz.getAnnotation(DraggableComponent.class);
        String descriptionKey = this.userService.getOwnUserRoles().isAdmin() && !Strings.isNullOrEmpty(annotation.adminDescriptionKey()) ? annotation.adminDescriptionKey() : annotation.descriptionKey();
        return new ComponentDescriptor(clazz.getName(), annotation.nameKey(), descriptionKey);
    }

    @FXML
    public void close() {
        this.guiStateService.stopEditMode();
    }

    public ObservableList<ComponentDescriptor> getComponentsList() {
        return this.componentsTable.getItems();
    }
}

