/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class NumberTextField
extends TextField {
    private Integer min;
    private Integer max;
    private Boolean sanitized;
    private Integer lengthLimit;
    private Integer intValue;

    public NumberTextField() {
        this.textProperty().addListener(new ChangeListener<String>(){

            @Override
            public void changed(ObservableValue<? extends String> arg0, String oldValue, String newValue) {
                if (StringUtils.isEmpty(newValue)) {
                    return;
                }
                if (!(this.isNumeric(newValue) && NumberTextField.this.isLengthValid(newValue) && NumberTextField.this.isValid())) {
                    NumberTextField.this.setText(oldValue);
                } else if (BooleanUtils.isTrue(NumberTextField.this.sanitized)) {
                    NumberTextField.this.setText("" + Integer.parseInt(newValue));
                    NumberTextField.this.intValue = Integer.parseInt(newValue);
                }
            }

            private boolean isNumeric(String text) {
                return text != null && !text.isEmpty() && text.matches("-?\\d+(.\\d+)?");
            }
        });
    }

    private boolean isLengthValid(String text) {
        return this.lengthLimit == null || text == null || text.length() <= this.lengthLimit;
    }

    private boolean isValid() {
        String testText = this.getText();
        if (testText == null) {
            return false;
        }
        if (testText.length() == 0) {
            return true;
        }
        try {
            int value = Integer.parseInt(testText);
            if (this.max != null && value > this.max || this.min != null && value < this.min) {
                return false;
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public Boolean getSanitized() {
        return this.sanitized;
    }

    public void setSanitized(Boolean sanitized) {
        this.sanitized = sanitized;
    }

    public Integer getLengthLimit() {
        return this.lengthLimit;
    }

    public void setLengthLimit(Integer lengthLimit) {
        this.lengthLimit = lengthLimit;
    }

    public Integer getIntValue() {
        return this.intValue;
    }
}

