/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.AbstractProductField;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class OptProductField
extends AbstractProductField {
    private final UserService userService;
    private final AssignmentService assignmentService;

    public OptProductField() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public OptProductField(ApplicationContext appContext) {
        super(appContext);
        this.userService = appContext.getService(UserService.class);
        this.assignmentService = appContext.getService(AssignmentService.class);
    }

    @Override
    public Stream<Product> getSuggestedEntities(String currentText) {
        return this.productQueries.findActiveProductsByNameContains(StringUtils.stripToEmpty(currentText)).getAll().filter(this::isProductAssigned).filter(Product::isOnExchangePrearrangedTrade);
    }

    @Override
    public Optional<Product> getEntity(String currentText) {
        return this.productQueries.findActiveProductsByNameContains(StringUtils.stripToEmpty(currentText)).addFilter(this::isProductAssigned).addFilter(Product::isOnExchangePrearrangedTrade).getFirst();
    }

    private boolean isProductAssigned(Product product) {
        User user = this.userService.getOwnUser();
        if (user == null) {
            return false;
        }
        if (user.getRoles().isAdmin()) {
            return true;
        }
        if (user.getRoles().isBroker()) {
            return this.assignmentService.isProductAssignedToBroker(product, user);
        }
        return this.assignmentService.isProductAssignedToUser((String)product.getId(), user);
    }
}

