/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.DateFilterChoice;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.DateFilterChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.DateTypeFilterChoice;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.DateTypeFilterChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.HourIntervalChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.bottomtoolbar.TimeframeChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.customization.toolbar.BottomToolbarNode;
import com.deutscheboerse.comxerv.comtrader.jfx.util.TooltipUtils;
import com.deutscheboerse.comxerv.comtrader.service.event.FullHourEvent;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.function.Predicate;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.IntegerRange;
import org.joda.time.DateTime;

public class DateFilterBottomToolbarComponent<T extends Trade>
extends HBox
implements BottomToolbarNode,
Destroyable {
    @FXML
    private DateTypeFilterChoiceBox dateTypeChoiceBox;
    @FXML
    private DateFilterChoiceBox dateChoiceBox;
    @FXML
    private TimeframeChoiceBox timeframeChoiceBox;
    @FXML
    private Label hourIntervalLabel;
    @FXML
    private HourIntervalChoiceBox hourIntervalChoiceBox;
    @FXML
    private CheckBox automaticReloadCheckBox;
    private final TimeService timeService;
    private final UserService userService;
    private final EventBus eventBus;
    private final ObjectProperty<Predicate<T>> filter = new SimpleObjectProperty<Predicate<Trade>>(t -> true);
    private final BooleanProperty ignoreFullHourEvent = new SimpleBooleanProperty(false);

    public DateFilterBottomToolbarComponent() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public DateFilterBottomToolbarComponent(ApplicationContext appContext) {
        this.timeService = appContext.getService(TimeService.class);
        this.userService = appContext.getService(UserService.class);
        this.eventBus = appContext.getService(EventBus.class);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
        this.eventBus.register(this);
    }

    public ObservableValue<Predicate<T>> filterProperty() {
        return this.filter;
    }

    public Predicate<T> getFilter() {
        return (Predicate)this.filter.get();
    }

    public void initialize() {
        TooltipUtils.setTooltip(this.dateTypeChoiceBox, this.getDescription());
        TooltipUtils.setTooltip(this.dateChoiceBox, this.getDescription());
        TooltipUtils.setTooltip(this.automaticReloadCheckBox, Util.getLabel("descriptions_toolbar_allTradePanel_automatic_reload_tooltip"));
        InvalidationListener reloadFilterListener = observable2 -> this.reloadFilterValue();
        this.dateTypeChoiceBox.valueProperty().addListener(reloadFilterListener);
        this.dateChoiceBox.valueProperty().addListener(reloadFilterListener);
        this.timeframeChoiceBox.valueProperty().addListener(reloadFilterListener);
        this.timeframeChoiceBox.hourIntervalProperty().bind(this.hourIntervalChoiceBox.valueProperty());
        this.timeframeChoiceBox.disableProperty().bind(this.automaticReloadCheckBox.selectedProperty());
        this.automaticReloadCheckBox.selectedProperty().addListener((observable2, wasSelected, isSelected) -> this.automaticReload());
        this.ignoreFullHourEvent.addListener((observable2, oldValue, newValue) -> {
            if (BooleanUtils.isFalse(newValue)) {
                this.automaticReload();
            }
        });
        this.reloadFilterValue();
    }

    private void automaticReload() {
        if (this.automaticReloadCheckBox.isSelected()) {
            this.timeframeChoiceBox.selectCurrentTimeframe();
        }
    }

    public void removeTimeFramePaginationControls() {
        this.getChildren().removeAll((Node[])new Node[]{this.timeframeChoiceBox, this.hourIntervalLabel, this.hourIntervalChoiceBox, this.automaticReloadCheckBox});
    }

    private void reloadFilterValue() {
        this.filter.setValue(new TradeDateFilter((DateTypeFilterChoice)this.dateTypeChoiceBox.getValue(), (DateFilterChoice)this.dateChoiceBox.getValue(), (IntegerRange)this.timeframeChoiceBox.getValue(), this.timeService));
    }

    @Override
    public Node getPreviewForConfigTable() {
        HBox hBox = new HBox(10.0);
        DateTypeFilterChoiceBox dateTypeFilterChoiceBox = new DateTypeFilterChoiceBox();
        DateFilterChoiceBox dateFilterChoiceBox = new DateFilterChoiceBox();
        dateTypeFilterChoiceBox.setDisable(true);
        dateFilterChoiceBox.setDisable(true);
        hBox.getChildren().addAll((Node[])new Node[]{dateTypeFilterChoiceBox, dateFilterChoiceBox});
        if (this.userService.getOwnUserRoles().isAdmin()) {
            TimeframeChoiceBox tfChoiceBox = new TimeframeChoiceBox();
            tfChoiceBox.setDisable(true);
            hBox.getChildren().add(tfChoiceBox);
        }
        return hBox;
    }

    public DateTypeFilterChoice getDateType() {
        return (DateTypeFilterChoice)this.dateTypeChoiceBox.getValue();
    }

    public DateTime getDate() {
        DateTime masterServerTime = this.timeService.getServerTime();
        return masterServerTime == null ? null : ((DateFilterChoice)this.dateChoiceBox.getValue()).getStartTime(masterServerTime);
    }

    public DateTypeFilterChoiceBox getDateTypeChoiceBox() {
        return this.dateTypeChoiceBox;
    }

    public DateFilterChoiceBox getDateChoiceBox() {
        return this.dateChoiceBox;
    }

    public TimeframeChoiceBox getTimeframeChoiceBox() {
        return this.timeframeChoiceBox;
    }

    public HourIntervalChoiceBox getHourIntervalChoiceBox() {
        return this.hourIntervalChoiceBox;
    }

    public CheckBox getAutomaticReloadCheckBox() {
        return this.automaticReloadCheckBox;
    }

    @Override
    public String getDescription() {
        return Util.getLabel("descriptions_toolbar_ownTradePanel_tradingDateAndDeliveryDate");
    }

    public int getOffsetInDays() {
        return ((DateFilterChoice)this.dateChoiceBox.getValue()).getOffsetInDays();
    }

    @Override
    public void destroy() {
        this.eventBus.unregister(this);
    }

    @Subscribe
    public void handleFullHourEvent(FullHourEvent fullHourEvent) {
        if (BooleanUtils.isTrue(this.ignoreFullHourEvent.getValue())) {
            return;
        }
        if (this.automaticReloadCheckBox.isSelected()) {
            this.timeframeChoiceBox.selectCurrentTimeframe();
        } else if (fullHourEvent.getHour() == 0) {
            this.reloadFilterValue();
        }
    }

    public BooleanProperty ignoreFullHourEventProperty() {
        return this.ignoreFullHourEvent;
    }

    protected static final class TradeDateFilter<T extends Trade>
    implements Predicate<T> {
        private final DateTypeFilterChoice type;
        private final DateFilterChoice filterValue;
        private final IntegerRange hourRange;
        private final TimeService timeService;

        public TradeDateFilter(DateTypeFilterChoice type, DateFilterChoice filterValue, IntegerRange hourRange, TimeService timeService) {
            this.type = type;
            this.filterValue = filterValue;
            this.hourRange = hourRange;
            this.timeService = timeService;
        }

        @Override
        public boolean test(T trade) {
            DateTime now = this.timeService.getServerTime();
            return this.type.isIn((Trade)trade, this.filterValue.getStartTime(now).withHourOfDay((Integer)this.hourRange.getMinimum()), this.applyEndHour(this.filterValue.getEndTime(now), (Integer)this.hourRange.getMaximum()));
        }

        private DateTime applyEndHour(DateTime dateTime, int hour) {
            return hour > 23 ? dateTime : dateTime.withHourOfDay(hour - 1);
        }
    }
}

