/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.contextmenu;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.entities.BalancingGroup;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.image.ContextMenuIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.OrderPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.service.event.MarketSelectionEvent;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.OwnQuantityLookupService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderSender;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrdersToSend;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.CommonOrderValidationService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.OrderValidationService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMode;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;

public abstract class LazyOrderContextMenu
extends ContextMenu {
    protected final OrderValidationService validationService;
    private final UserService userService;
    private final DataModel<String, BalancingGroup> balancingGroupDataModel;
    private final AssignmentService assignmentService;
    protected final OrderSender orderSender;
    protected final SmallFastDataModel<Long, Order> orderDataModel;
    protected final OrderPopup orderPopup;
    protected final OwnQuantityLookupService ownQuantityLookupService;
    protected final EventBus eventBus;
    protected final UserAlertService userAlertService;

    protected LazyOrderContextMenu(ApplicationContext appContext) {
        this.validationService = appContext.getService(OrderValidationService.class);
        this.userService = appContext.getService(UserService.class);
        this.balancingGroupDataModel = appContext.getDataModel(BalancingGroup.class);
        this.assignmentService = appContext.getService(AssignmentService.class);
        this.orderSender = appContext.getService(OrderSender.class);
        this.orderPopup = appContext.getService(OrderPopup.class);
        this.orderDataModel = appContext.getSmallDataModel(Order.class);
        this.ownQuantityLookupService = appContext.getService(OwnQuantityLookupService.class);
        this.eventBus = appContext.getService(EventBus.class);
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.setOnShowing(event -> this.getItems().setAll((Collection<MenuItem>)this.rebuildItems()));
        this.getItems().add(new MenuItem());
    }

    protected abstract List<? extends MenuItem> rebuildItems();

    protected MenuItem activateMenuItem(Order originalOrder) {
        MenuItem menuItem = new MenuItem(Util.getLabel("commons_Activate"));
        menuItem.setGraphic(new IconView(ContextMenuIcon.ACTIVATE.getIconStyleClass()));
        menuItem.setOnAction(event -> this.orderSender.sendOrder(new OrdersToSend(originalOrder, RequestType.ACTIVATE)));
        menuItem.setDisable(this.validationService.validateOrder(originalOrder, ValidationMode.ORDERENTRY).getResult() != CommonOrderValidationService.ValidationFlag.SUBMIT);
        return menuItem;
    }

    protected MenuItem activateMenuItem(List<Order> orders) {
        MenuItem menuItem = new MenuItem(Util.getLabel("commons_Activate"));
        menuItem.setGraphic(new IconView(ContextMenuIcon.ACTIVATE.getIconStyleClass()));
        menuItem.setOnAction(event -> this.orderSender.sendOrder(new OrdersToSend(orders, RequestType.ACTIVATE, ResponseHandler.EMPTY)));
        return menuItem;
    }

    protected MenuItem deactivateMenuItem(List<Order> orders) {
        MenuItem menuItem = new MenuItem(Util.getLabel("commons_Deactivate"));
        menuItem.setGraphic(new IconView(ContextMenuIcon.DEACTIVATE.getIconStyleClass()));
        menuItem.setOnAction(event -> this.orderSender.sendOrder(new OrdersToSend(orders, RequestType.DEACTIVATE, ResponseHandler.EMPTY)));
        return menuItem;
    }

    protected MenuItem modifyMenuItem(Order originalOrder) {
        MenuItem menuItem = new MenuItem(Util.getLabel("commons_modifyOrder"));
        menuItem.setGraphic(new IconView(ContextMenuIcon.MODIFY.getIconStyleClass()));
        menuItem.setOnAction(event -> this.orderPopup.showExtendedOrderPopup(originalOrder, false, menuItem.getGraphic()));
        return menuItem;
    }

    protected MenuItem deleteMenuItem(List<Order> orders) {
        MenuItem menuItem = new MenuItem(Util.getLabel("commons_cancel"));
        menuItem.setGraphic(new IconView(ContextMenuIcon.CANCEL.getIconStyleClass()));
        menuItem.setOnAction(event -> this.orderSender.sendOrder(new OrdersToSend(orders, RequestType.DELETE, ResponseHandler.EMPTY)));
        return menuItem;
    }

    protected MenuItem resendMenuItem(Order ownOrder) {
        MenuItem resendMenuItem = new MenuItem(Util.getLabel("commons_resend"));
        resendMenuItem.setGraphic(new IconView(ContextMenuIcon.RESEND.getIconStyleClass()));
        resendMenuItem.setOnAction(event -> this.resendAction(ownOrder));
        return resendMenuItem;
    }

    private void resendAction(Order ownOrder) {
        if (this.userAlertService.showQuestionDialog(Util.getLabel("commons_resend"), Util.getLabel("commons_resend_confirmation"), UserAlertService.Flag.YES_NO)) {
            this.orderSender.sendOrder(new OrdersToSend(ownOrder, RequestType.ADD));
        }
    }

    protected MenuItem removeMenuItem(Order ownOrder) {
        MenuItem removeMenuItem = new MenuItem(Util.getLabel("commons_remove"));
        removeMenuItem.setGraphic(new IconView(ContextMenuIcon.DELETE.getIconStyleClass()));
        removeMenuItem.setOnAction(event -> this.orderDataModel.remove(ownOrder));
        return removeMenuItem;
    }

    protected MenuItem removeAllMenuItem() {
        MenuItem removeAllMenuItem = new MenuItem(Util.getLabel("commons_removeAll"));
        removeAllMenuItem.setGraphic(new IconView(ContextMenuIcon.DELETE.getIconStyleClass()));
        removeAllMenuItem.setOnAction(event -> this.orderDataModel.removeIf(order -> OrderStatus.ERROR.equals(order.getStatus())));
        return removeAllMenuItem;
    }

    protected MenuItem prefillMenuItem(Order ownOrder) {
        MenuItem menuItem = new MenuItem(Util.getLabel("commons_prefill"));
        menuItem.setGraphic(new IconView(ContextMenuIcon.PREFILL.getIconStyleClass()));
        menuItem.setOnAction(event -> this.orderPopup.showExtendedOrderPopup(ownOrder, false, menuItem.getGraphic()));
        return menuItem;
    }

    protected List<MenuItem> addMenuItem(Order order) {
        ArrayList<MenuItem> list = new ArrayList<MenuItem>();
        Set<BalancingGroup> balancingGroups = this.getPossibleBalancingGroups(order.getContract(), order.getDeliveryArea());
        for (BalancingGroup balancingGroup : balancingGroups) {
            String label = balancingGroups.size() == 1 ? Util.getLabel("commons_addOrderLabel") : Util.getLabel("orderContextMenu_addVolumeAs", balancingGroup.getDisplayName());
            MenuItem menuItem = new MenuItem(label);
            menuItem.setGraphic(new IconView(ContextMenuIcon.ADD.getIconStyleClass()));
            menuItem.setOnAction(event -> {
                Order preparedOrder = new Order(order);
                preparedOrder.setId(null);
                preparedOrder.setInitialOrderId(null);
                preparedOrder.initNewClientOrderId();
                preparedOrder.setBalancingGroup(balancingGroup);
                MarketSelectionEvent selectionEvent = new MarketSelectionEvent(preparedOrder);
                this.eventBus.post(selectionEvent);
                if (!selectionEvent.wasProcessed()) {
                    this.orderPopup.showExtendedOrderPopup(preparedOrder, false, menuItem.getGraphic());
                }
            });
            list.add(menuItem);
        }
        return list;
    }

    protected Set<BalancingGroup> getPossibleBalancingGroups(Contract contract, DeliveryArea deliveryArea) {
        User ownUser = this.userService.getOwnUser();
        User user = this.userService.getCurrentUser();
        String productId = (String)contract.getProduct().getId();
        String daId = (String)deliveryArea.getId();
        return user.getBalancingGroupIds().stream().map(this.balancingGroupDataModel::findById).filter(Objects::nonNull).filter(bg -> Objects.equals(ownUser, user) || this.assignmentService.getAssignedBgIdsForBroker(ownUser).contains(bg.getId())).filter(bg -> this.assignmentService.isUserAssignedToBgProductAndDa(user, (String)bg.getId(), productId, daId)).collect(Collectors.toSet());
    }
}

