/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.contextmenu;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderStatus;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.contextmenu.LazyOrderContextMenu;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.contextmenu.OwnOrderContextMenuFactory;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;

public class OwnOrderContextMenuFactoryImpl
implements OwnOrderContextMenuFactory {
    private final ApplicationContext appContext;

    @Inject
    public OwnOrderContextMenuFactoryImpl(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    @Override
    public ContextMenu createOwnOrderContextMenu(List<Order> ownOrders) {
        return new OwnOrderContextMenu(this.appContext, ownOrders);
    }

    private static class OwnOrderContextMenu
    extends LazyOrderContextMenu {
        private final List<Order> ownOrders;

        public OwnOrderContextMenu(ApplicationContext appContext, List<Order> ownOrders) {
            super(appContext);
            this.ownOrders = ownOrders;
        }

        @Override
        protected List<? extends MenuItem> rebuildItems() {
            if (this.ownOrders.size() == 1) {
                return this.rebuildItems(this.ownOrders.get(0));
            }
            ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
            if (this.validationService.canBeActivated(this.ownOrders)) {
                menuItems.add(this.activateMenuItem(this.ownOrders));
            } else if (this.validationService.canBeDeactivated(this.ownOrders)) {
                menuItems.add(this.deactivateMenuItem(this.ownOrders));
            }
            if (this.validationService.canBeDeleted(this.ownOrders)) {
                menuItems.add(this.deleteMenuItem(this.ownOrders));
            }
            return menuItems;
        }

        private List<? extends MenuItem> rebuildItems(Order ownOrder) {
            if (OrderStatus.MODI == ownOrder.getStatus() || OrderStatus.SENT == ownOrder.getStatus()) {
                return Collections.emptyList();
            }
            if (OrderStatus.ERROR.equals(ownOrder.getStatus())) {
                return this.getErrorOrderMenuItems(ownOrder);
            }
            return this.getActiveOrHibernamtedOrderMenuItems(ownOrder);
        }

        private List<? extends MenuItem> getErrorOrderMenuItems(Order ownOrder) {
            return Lists.newArrayList(this.resendMenuItem(ownOrder), this.prefillMenuItem(ownOrder), this.removeMenuItem(ownOrder), this.removeAllMenuItem());
        }

        private List<? extends MenuItem> getActiveOrHibernamtedOrderMenuItems(Order ownOrder) {
            ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
            if (OrderStatus.ACTIVE.equals(ownOrder.getStatus())) {
                menuItems.add(this.deactivateMenuItem(List.of(ownOrder)));
            } else {
                menuItems.add(this.activateMenuItem(ownOrder));
            }
            menuItems.add(this.modifyMenuItem(ownOrder));
            menuItems.add(this.deleteMenuItem(List.of(ownOrder)));
            menuItems.addAll(this.addMenuItem(ownOrder));
            return menuItems;
        }
    }
}

